/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.federation.ldap.idm.query.Condition;
import org.keycloak.federation.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapper;
import org.keycloak.federation.ldap.mappers.TxAwareLDAPUserModelDelegate;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.models.utils.reflection.Property;
import org.keycloak.models.utils.reflection.PropertyCriteria;
import org.keycloak.models.utils.reflection.PropertyQueries;

public class UserAttributeLDAPFederationMapper
extends AbstractLDAPFederationMapper {
    private static final Logger logger = Logger.getLogger(UserAttributeLDAPFederationMapper.class);
    private static final Map<String, Property<Object>> userModelProperties;
    public static final String USER_MODEL_ATTRIBUTE = "user.model.attribute";
    public static final String LDAP_ATTRIBUTE = "ldap.attribute";
    public static final String READ_ONLY = "read.only";
    public static final String ALWAYS_READ_VALUE_FROM_LDAP = "always.read.value.from.ldap";
    public static final String IS_MANDATORY_IN_LDAP = "is.mandatory.in.ldap";

    public UserAttributeLDAPFederationMapper(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, RealmModel realm) {
        super(mapperModel, ldapProvider, realm);
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, boolean isCreate) {
        String userModelAttrName = (String)this.mapperModel.getConfig().get(USER_MODEL_ATTRIBUTE);
        String ldapAttrName = (String)this.mapperModel.getConfig().get(LDAP_ATTRIBUTE);
        Property<Object> userModelProperty = userModelProperties.get(userModelAttrName.toLowerCase());
        if (userModelProperty != null) {
            String ldapAttrValue = ldapUser.getAttributeAsString(ldapAttrName);
            this.checkDuplicateEmail(userModelAttrName, ldapAttrValue, this.realm, this.ldapProvider.getSession(), user);
            this.setPropertyOnUserModel(userModelProperty, user, ldapAttrValue);
        } else {
            Set<String> ldapAttrValue = ldapUser.getAttributeAsSet(ldapAttrName);
            if (ldapAttrValue != null) {
                user.setAttribute(userModelAttrName, new ArrayList<String>(ldapAttrValue));
            } else {
                user.removeAttribute(userModelAttrName);
            }
        }
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser) {
        String userModelAttrName = (String)this.mapperModel.getConfig().get(USER_MODEL_ATTRIBUTE);
        String ldapAttrName = (String)this.mapperModel.getConfig().get(LDAP_ATTRIBUTE);
        boolean isMandatoryInLdap = UserAttributeLDAPFederationMapper.parseBooleanParameter(this.mapperModel, IS_MANDATORY_IN_LDAP);
        Property<Object> userModelProperty = userModelProperties.get(userModelAttrName.toLowerCase());
        if (userModelProperty != null) {
            Object attrValue = userModelProperty.getValue((Object)localUser);
            if (attrValue == null) {
                if (isMandatoryInLdap) {
                    ldapUser.setSingleAttribute(ldapAttrName, " ");
                } else {
                    ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>());
                }
            } else {
                ldapUser.setSingleAttribute(ldapAttrName, attrValue.toString());
            }
        } else {
            List attrValues = localUser.getAttribute(userModelAttrName);
            if (attrValues.size() == 0) {
                if (isMandatoryInLdap) {
                    ldapUser.setSingleAttribute(ldapAttrName, " ");
                } else {
                    ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>());
                }
            } else {
                ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>(attrValues));
            }
        }
        if (this.isReadOnly()) {
            ldapUser.addReadOnlyAttributeName(ldapAttrName);
        }
    }

    protected void checkDuplicateEmail(String userModelAttrName, String email, RealmModel realm, KeycloakSession session, UserModel user) {
        if ("email".equalsIgnoreCase(userModelAttrName)) {
            email = KeycloakModelUtils.toLowerCaseSafe((String)email);
            UserModel that = session.userStorage().getUserByEmail(email, realm);
            if (that != null && !that.getId().equals(user.getId())) {
                session.getTransaction().setRollbackOnly();
                String exceptionMessage = String.format("Can't import user '%s' from LDAP because email '%s' already exists in Keycloak. Existing user with this email is '%s'", user.getUsername(), email, that.getUsername());
                throw new ModelDuplicateException(exceptionMessage, "email");
            }
        }
    }

    @Override
    public UserModel proxy(final LDAPObject ldapUser, UserModel delegate) {
        final String userModelAttrName = (String)this.mapperModel.getConfig().get(USER_MODEL_ATTRIBUTE);
        final String ldapAttrName = (String)this.mapperModel.getConfig().get(LDAP_ATTRIBUTE);
        boolean isAlwaysReadValueFromLDAP = UserAttributeLDAPFederationMapper.parseBooleanParameter(this.mapperModel, ALWAYS_READ_VALUE_FROM_LDAP);
        final boolean isMandatoryInLdap = UserAttributeLDAPFederationMapper.parseBooleanParameter(this.mapperModel, IS_MANDATORY_IN_LDAP);
        if (this.ldapProvider.getEditMode() == UserFederationProvider.EditMode.WRITABLE && !this.isReadOnly()) {
            delegate = new TxAwareLDAPUserModelDelegate((UserModel)delegate, this.ldapProvider, ldapUser){

                public void setSingleAttribute(String name, String value) {
                    this.setLDAPAttribute(name, value);
                    super.setSingleAttribute(name, value);
                }

                public void setAttribute(String name, List<String> values) {
                    this.setLDAPAttribute(name, values);
                    super.setAttribute(name, values);
                }

                public void removeAttribute(String name) {
                    this.setLDAPAttribute(name, null);
                    super.removeAttribute(name);
                }

                public void setEmail(String email) {
                    UserAttributeLDAPFederationMapper.this.checkDuplicateEmail(userModelAttrName, email, UserAttributeLDAPFederationMapper.this.realm, UserAttributeLDAPFederationMapper.this.ldapProvider.getSession(), (UserModel)this);
                    this.setLDAPAttribute("email", email);
                    super.setEmail(email);
                }

                public void setLastName(String lastName) {
                    this.setLDAPAttribute("lastName", lastName);
                    super.setLastName(lastName);
                }

                public void setFirstName(String firstName) {
                    this.setLDAPAttribute("firstName", firstName);
                    super.setFirstName(firstName);
                }

                protected void setLDAPAttribute(String modelAttrName, Object value) {
                    if (modelAttrName.equalsIgnoreCase(userModelAttrName)) {
                        if (logger.isTraceEnabled()) {
                            logger.tracef("Pushing user attribute to LDAP. username: %s, Model attribute name: %s, LDAP attribute name: %s, Attribute value: %s", new Object[]{this.getUsername(), modelAttrName, ldapAttrName, value});
                        }
                        this.ensureTransactionStarted();
                        if (value == null) {
                            if (isMandatoryInLdap) {
                                this.ldapUser.setSingleAttribute(ldapAttrName, " ");
                            } else {
                                this.ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>());
                            }
                        } else if (value instanceof String) {
                            this.ldapUser.setSingleAttribute(ldapAttrName, (String)value);
                        } else {
                            List asList = (List)value;
                            if (asList.isEmpty() && isMandatoryInLdap) {
                                this.ldapUser.setSingleAttribute(ldapAttrName, " ");
                            } else {
                                this.ldapUser.setAttribute(ldapAttrName, new LinkedHashSet<String>(asList));
                            }
                        }
                    }
                }
            };
        }
        if (isAlwaysReadValueFromLDAP) {
            delegate = new UserModelDelegate((UserModel)delegate){

                public String getFirstAttribute(String name) {
                    if (name.equalsIgnoreCase(userModelAttrName)) {
                        return ldapUser.getAttributeAsString(ldapAttrName);
                    }
                    return super.getFirstAttribute(name);
                }

                public List<String> getAttribute(String name) {
                    if (name.equalsIgnoreCase(userModelAttrName)) {
                        Set<String> ldapAttrValue = ldapUser.getAttributeAsSet(ldapAttrName);
                        if (ldapAttrValue == null) {
                            return Collections.emptyList();
                        }
                        return new ArrayList<String>(ldapAttrValue);
                    }
                    return super.getAttribute(name);
                }

                public Map<String, List<String>> getAttributes() {
                    HashMap<String, List<String>> attrs = new HashMap<String, List<String>>(super.getAttributes());
                    if (userModelProperties.get(userModelAttrName.toLowerCase()) != null) {
                        return attrs;
                    }
                    Set<String> allLdapAttrValues = ldapUser.getAttributeAsSet(ldapAttrName);
                    if (allLdapAttrValues != null) {
                        attrs.put(userModelAttrName, new ArrayList<String>(allLdapAttrValues));
                    }
                    return attrs;
                }

                public String getEmail() {
                    if ("email".equalsIgnoreCase(userModelAttrName)) {
                        return ldapUser.getAttributeAsString(ldapAttrName);
                    }
                    return super.getEmail();
                }

                public String getLastName() {
                    if ("lastName".equalsIgnoreCase(userModelAttrName)) {
                        return ldapUser.getAttributeAsString(ldapAttrName);
                    }
                    return super.getLastName();
                }

                public String getFirstName() {
                    if ("firstName".equalsIgnoreCase(userModelAttrName)) {
                        return ldapUser.getAttributeAsString(ldapAttrName);
                    }
                    return super.getFirstName();
                }
            };
        }
        return delegate;
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
        String userModelAttrName = (String)this.mapperModel.getConfig().get(USER_MODEL_ATTRIBUTE);
        String ldapAttrName = (String)this.mapperModel.getConfig().get(LDAP_ATTRIBUTE);
        query.addReturningLdapAttribute(ldapAttrName);
        if (this.isReadOnly()) {
            query.addReturningReadOnlyLdapAttribute(ldapAttrName);
        }
        for (Condition condition : query.getConditions()) {
            String paramName = condition.getParameterName();
            if (paramName == null || !paramName.equalsIgnoreCase(userModelAttrName)) continue;
            condition.setParameterName(ldapAttrName);
        }
    }

    private boolean isReadOnly() {
        return UserAttributeLDAPFederationMapper.parseBooleanParameter(this.mapperModel, READ_ONLY);
    }

    protected void setPropertyOnUserModel(Property<Object> userModelProperty, UserModel user, String ldapAttrValue) {
        if (ldapAttrValue == null) {
            userModelProperty.setValue((Object)user, null);
        } else {
            Class clazz = userModelProperty.getJavaClass();
            if (String.class.equals((Object)clazz)) {
                userModelProperty.setValue((Object)user, (Object)ldapAttrValue);
            } else if (Boolean.class.equals((Object)clazz) || Boolean.TYPE.equals(clazz)) {
                Boolean boolVal = Boolean.valueOf(ldapAttrValue);
                userModelProperty.setValue((Object)user, (Object)boolVal);
            } else {
                logger.warnf("Don't know how to set the property '%s' on user '%s' . Value of LDAP attribute is '%s' ", (Object)userModelProperty.getName(), (Object)user.getUsername(), (Object)ldapAttrValue.toString());
            }
        }
    }

    static {
        Map userModelProps = PropertyQueries.createQuery(UserModel.class).addCriteria(new PropertyCriteria(){

            public boolean methodMatches(Method m) {
                return !m.getName().startsWith("get") && !m.getName().startsWith("is") || m.getParameterTypes().length <= 0;
            }
        }).getResultList();
        userModelProperties = new HashMap<String, Property<Object>>();
        for (Map.Entry entry : userModelProps.entrySet()) {
            userModelProperties.put(((String)entry.getKey()).toLowerCase(), (Property<Object>)entry.getValue());
        }
    }
}

