/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.federation.ldap.LDAPConfig;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapper;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapperFactory;
import org.keycloak.federation.ldap.mappers.FullNameLDAPFederationMapper;
import org.keycloak.mappers.FederationConfigValidationException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.provider.ProviderConfigProperty;

public class FullNameLDAPFederationMapperFactory
extends AbstractLDAPFederationMapperFactory {
    public static final String PROVIDER_ID = "full-name-ldap-mapper";
    protected static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getHelpText() {
        return "Used to map full-name of user from single attribute in LDAP (usually 'cn' attribute) to firstName and lastName attributes of UserModel in Keycloak DB";
    }

    public String getDisplayCategory() {
        return "Attribute Mapper";
    }

    public String getDisplayType() {
        return "Full Name";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public Map<String, String> getDefaultConfig(UserFederationProviderModel providerModel) {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        LDAPConfig config = new LDAPConfig(providerModel.getConfig());
        defaultValues.put("ldap.full.name.attribute", "cn");
        boolean readOnly = config.getEditMode() != UserFederationProvider.EditMode.WRITABLE;
        defaultValues.put("read.only", String.valueOf(readOnly));
        String writeOnly = String.valueOf(!readOnly);
        defaultValues.put("write.only", writeOnly);
        return defaultValues;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public void validateConfig(RealmModel realm, UserFederationProviderModel fedProviderModel, UserFederationMapperModel mapperModel) throws FederationConfigValidationException {
        this.checkMandatoryConfigAttribute("ldap.full.name.attribute", "LDAP Full Name Attribute", mapperModel);
        boolean readOnly = AbstractLDAPFederationMapper.parseBooleanParameter(mapperModel, "read.only");
        boolean writeOnly = AbstractLDAPFederationMapper.parseBooleanParameter(mapperModel, "write.only");
        LDAPConfig cfg = new LDAPConfig(fedProviderModel.getConfig());
        UserFederationProvider.EditMode editMode = cfg.getEditMode();
        if (writeOnly && cfg.getEditMode() != UserFederationProvider.EditMode.WRITABLE) {
            throw new FederationConfigValidationException("ldapErrorCantWriteOnlyForReadOnlyLdap");
        }
        if (writeOnly && readOnly) {
            throw new FederationConfigValidationException("ldapErrorCantWriteOnlyAndReadOnly");
        }
    }

    @Override
    protected AbstractLDAPFederationMapper createMapper(UserFederationMapperModel mapperModel, LDAPFederationProvider federationProvider, RealmModel realm) {
        return new FullNameLDAPFederationMapper(mapperModel, federationProvider, realm);
    }

    static {
        ProviderConfigProperty userModelAttribute = FullNameLDAPFederationMapperFactory.createConfigProperty("ldap.full.name.attribute", "LDAP Full Name Attribute", "Name of LDAP attribute, which contains fullName of user. Usually it will be 'cn' ", "String", null);
        configProperties.add(userModelAttribute);
        ProviderConfigProperty readOnly = FullNameLDAPFederationMapperFactory.createConfigProperty("read.only", "Read Only", "For Read-only is data imported from LDAP to Keycloak DB, but it's not saved back to LDAP when user is updated in Keycloak.", "boolean", null);
        configProperties.add(readOnly);
        ProviderConfigProperty writeOnly = FullNameLDAPFederationMapperFactory.createConfigProperty("write.only", "Write Only", "For Write-only is data propagated to LDAP when user is created or updated in Keycloak. But this mapper is not used to propagate data from LDAP back into Keycloak. This setting is useful if you configured separate firstName and lastName attribute mappers and you want to use those to read attribute from LDAP into Keycloak", "boolean", null);
        configProperties.add(writeOnly);
    }
}

