/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers;

import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.mappers.AbstractLDAPStorageMapper;

public class HardcodedLDAPRoleStorageMapper
extends AbstractLDAPStorageMapper {
    private static final Logger logger = Logger.getLogger(HardcodedLDAPRoleStorageMapper.class);
    public static final String ROLE = "role";

    public HardcodedLDAPRoleStorageMapper(ComponentModel mapperModel, LDAPStorageProvider ldapProvider) {
        super(mapperModel, ldapProvider);
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate, final RealmModel realm) {
        return new UserModelDelegate(delegate){

            public Stream<RoleModel> getRealmRoleMappingsStream() {
                Stream<RoleModel> realmRoleMappings = super.getRealmRoleMappingsStream();
                RoleModel role = HardcodedLDAPRoleStorageMapper.this.getRole(realm);
                if (role != null && role.getContainer().equals(realm)) {
                    realmRoleMappings = Stream.concat(realmRoleMappings, Stream.of(role));
                }
                return realmRoleMappings;
            }

            public Stream<RoleModel> getClientRoleMappingsStream(ClientModel app) {
                Stream clientRoleMappings = super.getClientRoleMappingsStream(app);
                RoleModel role = HardcodedLDAPRoleStorageMapper.this.getRole(realm);
                if (role != null && role.getContainer().equals(app)) {
                    return Stream.concat(clientRoleMappings, Stream.of(role));
                }
                return clientRoleMappings;
            }

            public boolean hasDirectRole(RoleModel role) {
                return super.hasDirectRole(role) || role.equals(HardcodedLDAPRoleStorageMapper.this.getRole(realm));
            }

            public boolean hasRole(RoleModel role) {
                return super.hasRole(role) || role.equals(HardcodedLDAPRoleStorageMapper.this.getRole(realm));
            }

            public Stream<RoleModel> getRoleMappingsStream() {
                Stream<RoleModel> roleMappings = super.getRoleMappingsStream();
                RoleModel role = HardcodedLDAPRoleStorageMapper.this.getRole(realm);
                if (role != null) {
                    roleMappings = Stream.concat(roleMappings, Stream.of(role));
                }
                return roleMappings;
            }

            public void deleteRoleMapping(RoleModel role) {
                if (role.equals(HardcodedLDAPRoleStorageMapper.this.getRole(realm))) {
                    throw new ModelException("Not possible to delete role. It's hardcoded by LDAP mapper");
                }
                super.deleteRoleMapping(role);
            }
        };
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser, RealmModel realm) {
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, RealmModel realm, boolean isCreate) {
    }

    private RoleModel getRole(RealmModel realm) {
        String roleName = (String)this.mapperModel.getConfig().getFirst((Object)ROLE);
        RoleModel role = KeycloakModelUtils.getRoleFromString((RealmModel)realm, (String)roleName);
        if (role == null) {
            logger.warnf("Hardcoded role '%s' configured in mapper '%s' is not available anymore", new Object[0]);
        }
        return role;
    }
}

