/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.ldap.mappers.msad;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.AuthenticationException;
import org.jboss.logging.Logger;
import org.keycloak.federation.ldap.LDAPFederationProvider;
import org.keycloak.federation.ldap.idm.model.LDAPObject;
import org.keycloak.federation.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.federation.ldap.mappers.AbstractLDAPFederationMapper;
import org.keycloak.federation.ldap.mappers.msad.UserAccountControl;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.UserModelDelegate;

public class MSADUserAccountControlMapper
extends AbstractLDAPFederationMapper {
    private static final Logger logger = Logger.getLogger(MSADUserAccountControlMapper.class);
    private static final Pattern AUTH_EXCEPTION_REGEX = Pattern.compile(".*AcceptSecurityContext error, data ([0-9a-f]*), v.*");
    private static final Pattern AUTH_INVALID_NEW_PASSWORD = Pattern.compile(".*error code ([0-9a-f]+) .*WILL_NOT_PERFORM.*");

    public MSADUserAccountControlMapper(UserFederationMapperModel mapperModel, LDAPFederationProvider ldapProvider, RealmModel realm) {
        super(mapperModel, ldapProvider, realm);
    }

    @Override
    public void beforeLDAPQuery(LDAPQuery query) {
        query.addReturningLdapAttribute("pwdLastSet");
        query.addReturningLdapAttribute("userAccountControl");
        query.addReturningReadOnlyLdapAttribute("pwdLastSet");
        if (this.ldapProvider.getEditMode() != UserFederationProvider.EditMode.WRITABLE) {
            query.addReturningReadOnlyLdapAttribute("userAccountControl");
        }
    }

    @Override
    public UserModel proxy(LDAPObject ldapUser, UserModel delegate) {
        return new MSADUserModelDelegate(delegate, ldapUser);
    }

    @Override
    public void onRegisterUserToLDAP(LDAPObject ldapUser, UserModel localUser) {
    }

    @Override
    public void onImportUserFromLDAP(LDAPObject ldapUser, UserModel user, boolean isCreate) {
    }

    @Override
    public boolean onAuthenticationFailure(LDAPObject ldapUser, UserModel user, AuthenticationException ldapException) {
        String exceptionMessage = ldapException.getMessage();
        Matcher m = AUTH_EXCEPTION_REGEX.matcher(exceptionMessage);
        if (m.matches()) {
            String errorCode = m.group(1);
            return this.processAuthErrorCode(errorCode, user);
        }
        return false;
    }

    protected boolean processAuthErrorCode(String errorCode, UserModel user) {
        logger.debugf("MSAD Error code is '%s' after failed LDAP login of user '%s'", (Object)errorCode, (Object)user.getUsername());
        if (this.ldapProvider.getEditMode() == UserFederationProvider.EditMode.WRITABLE) {
            if (errorCode.equals("532") || errorCode.equals("773")) {
                user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                return true;
            }
            if (errorCode.equals("533")) {
                user.setEnabled(false);
                return true;
            }
            if (errorCode.equals("775")) {
                logger.warnf("Locked user '%s' attempt to login", (Object)user.getUsername());
            }
        }
        return false;
    }

    protected ModelException processFailedPasswordUpdateException(ModelException e) {
        String errorCode;
        if (e.getCause() == null || e.getCause().getMessage() == null) {
            return e;
        }
        String exceptionMessage = e.getCause().getMessage().replace('\n', ' ');
        Matcher m = AUTH_INVALID_NEW_PASSWORD.matcher(exceptionMessage);
        if (m.matches() && (errorCode = m.group(1)).equals("53")) {
            ModelException me = new ModelException("invalidPasswordRegexPatternMessage", (Throwable)e);
            me.setParameters(new Object[]{"passwordConstraintViolation"});
            return me;
        }
        return e;
    }

    public class MSADUserModelDelegate
    extends UserModelDelegate {
        private final LDAPObject ldapUser;

        public MSADUserModelDelegate(UserModel delegate, LDAPObject ldapUser) {
            super(delegate);
            this.ldapUser = ldapUser;
        }

        public boolean isEnabled() {
            boolean kcEnabled = super.isEnabled();
            if (this.getPwdLastSet() > 0L) {
                return kcEnabled && !this.getUserAccountControl().has(2L);
            }
            return kcEnabled;
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (MSADUserAccountControlMapper.this.ldapProvider.getEditMode() == UserFederationProvider.EditMode.WRITABLE && this.getPwdLastSet() > 0L) {
                logger.debugf("Going to propagate enabled=%s for ldapUser '%s' to MSAD", (Object)enabled, (Object)this.ldapUser.getDn().toString());
                UserAccountControl control = this.getUserAccountControl();
                if (enabled) {
                    control.remove(2L);
                } else {
                    control.add(2L);
                }
                this.updateUserAccountControl(control);
            }
        }

        public void updateCredential(UserCredentialModel cred) {
            try {
                super.updateCredential(cred);
            }
            catch (ModelException me) {
                me = MSADUserAccountControlMapper.this.processFailedPasswordUpdateException(me);
                throw me;
            }
            if (MSADUserAccountControlMapper.this.ldapProvider.getEditMode() == UserFederationProvider.EditMode.WRITABLE && cred.getType().equals("password")) {
                logger.debugf("Going to update userAccountControl for ldap user '%s' after successful password update", (Object)this.ldapUser.getDn().toString());
                this.ldapUser.removeReadOnlyAttributeName("pwdLastSet");
                this.ldapUser.setSingleAttribute("pwdLastSet", "-1");
                UserAccountControl control = this.getUserAccountControl();
                control.remove(32L);
                control.remove(0x800000L);
                if (super.isEnabled()) {
                    control.remove(2L);
                }
                this.updateUserAccountControl(control);
            }
        }

        public void addRequiredAction(UserModel.RequiredAction action) {
            String actionName = action.name();
            this.addRequiredAction(actionName);
        }

        public void addRequiredAction(String action) {
            super.addRequiredAction(action);
            if (MSADUserAccountControlMapper.this.ldapProvider.getEditMode() == UserFederationProvider.EditMode.WRITABLE && UserModel.RequiredAction.UPDATE_PASSWORD.toString().equals(action)) {
                logger.debugf("Going to propagate required action UPDATE_PASSWORD to MSAD for ldap user '%s' ", (Object)this.ldapUser.getDn().toString());
                this.ldapUser.removeReadOnlyAttributeName("pwdLastSet");
                this.ldapUser.setSingleAttribute("pwdLastSet", "0");
                MSADUserAccountControlMapper.this.ldapProvider.getLdapIdentityStore().update(this.ldapUser);
            }
        }

        public void removeRequiredAction(UserModel.RequiredAction action) {
            String actionName = action.name();
            this.removeRequiredAction(actionName);
        }

        public void removeRequiredAction(String action) {
            UserAccountControl accountControl;
            super.removeRequiredAction(action);
            if (MSADUserAccountControlMapper.this.ldapProvider.getEditMode() == UserFederationProvider.EditMode.WRITABLE && UserModel.RequiredAction.UPDATE_PASSWORD.toString().equals(action) && (accountControl = this.getUserAccountControl()).getValue() != 0L && !accountControl.has(32L)) {
                logger.debugf("Going to remove required action UPDATE_PASSWORD from MSAD for ldap user '%s' ", (Object)this.ldapUser.getDn().toString());
                this.ldapUser.removeReadOnlyAttributeName("pwdLastSet");
                this.ldapUser.setSingleAttribute("pwdLastSet", "-1");
                MSADUserAccountControlMapper.this.ldapProvider.getLdapIdentityStore().update(this.ldapUser);
            }
        }

        public Set<String> getRequiredActions() {
            HashSet<String> requiredActions = super.getRequiredActions();
            if (MSADUserAccountControlMapper.this.ldapProvider.getEditMode() == UserFederationProvider.EditMode.WRITABLE && (this.getPwdLastSet() == 0L || this.getUserAccountControl().has(0x800000L))) {
                requiredActions = new HashSet<String>(requiredActions);
                requiredActions.add(UserModel.RequiredAction.UPDATE_PASSWORD.toString());
                return requiredActions;
            }
            return requiredActions;
        }

        protected long getPwdLastSet() {
            String pwdLastSet = this.ldapUser.getAttributeAsString("pwdLastSet");
            return pwdLastSet == null ? 0L : Long.parseLong(pwdLastSet);
        }

        protected UserAccountControl getUserAccountControl() {
            String userAccountControl = this.ldapUser.getAttributeAsString("userAccountControl");
            long longValue = userAccountControl == null ? 0L : Long.parseLong(userAccountControl);
            return new UserAccountControl(longValue);
        }

        protected void updateUserAccountControl(UserAccountControl accountControl) {
            String userAccountControlValue = String.valueOf(accountControl.getValue());
            logger.debugf("Updating userAccountControl of user '%s' to value '%s'", (Object)this.ldapUser.getDn().toString(), (Object)userAccountControlValue);
            this.ldapUser.setSingleAttribute("userAccountControl", userAccountControlValue);
            MSADUserAccountControlMapper.this.ldapProvider.getLdapIdentityStore().update(this.ldapUser);
        }
    }
}

