/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialAuthentication;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.federation.kerberos.impl.KerberosUsernamePasswordAuthenticator;
import org.keycloak.federation.kerberos.impl.SPNEGOAuthenticator;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ModelReadOnlyException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.UserCache;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.ldap.LDAPStorageProviderFactory;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.ReadonlyLDAPUserModelDelegate;
import org.keycloak.storage.ldap.UnsyncedLDAPUserModelDelegate;
import org.keycloak.storage.ldap.WritableLDAPUserModelDelegate;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.EscapeStrategy;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.storage.ldap.kerberos.LDAPProviderKerberosConfig;
import org.keycloak.storage.ldap.mappers.LDAPMappersComparator;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.PasswordUpdated;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryProvider;
import org.keycloak.storage.user.UserRegistrationProvider;

public class LDAPStorageProvider
implements UserStorageProvider,
CredentialInputValidator,
CredentialInputUpdater,
CredentialAuthentication,
UserLookupProvider,
UserRegistrationProvider,
UserQueryProvider,
ImportedUserValidation {
    private static final Logger logger = Logger.getLogger(LDAPStorageProvider.class);
    protected LDAPStorageProviderFactory factory;
    protected KeycloakSession session;
    protected ComponentModel model;
    protected LDAPIdentityStore ldapIdentityStore;
    protected UserStorageProvider.EditMode editMode;
    protected LDAPProviderKerberosConfig kerberosConfig;
    protected PasswordUpdated updater;
    protected final Set<String> supportedCredentialTypes = new HashSet<String>();

    public LDAPStorageProvider(LDAPStorageProviderFactory factory, KeycloakSession session, ComponentModel model, LDAPIdentityStore ldapIdentityStore) {
        this.factory = factory;
        this.session = session;
        this.model = model;
        this.ldapIdentityStore = ldapIdentityStore;
        this.kerberosConfig = new LDAPProviderKerberosConfig(model);
        this.editMode = ldapIdentityStore.getConfig().getEditMode();
        this.supportedCredentialTypes.add("password");
        if (this.kerberosConfig.isAllowKerberosAuthentication()) {
            this.supportedCredentialTypes.add("kerberos");
        }
    }

    public void setUpdater(PasswordUpdated updater) {
        this.updater = updater;
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public LDAPIdentityStore getLdapIdentityStore() {
        return this.ldapIdentityStore;
    }

    public UserStorageProvider.EditMode getEditMode() {
        return this.editMode;
    }

    public ComponentModel getModel() {
        return this.model;
    }

    public UserModel validate(RealmModel realm, UserModel local) {
        LDAPObject ldapObject = this.loadAndValidateUser(realm, local);
        if (ldapObject == null) {
            return null;
        }
        return this.proxy(realm, local, ldapObject);
    }

    protected UserModel proxy(RealmModel realm, UserModel local, LDAPObject ldapObject) {
        UserModel proxied = local;
        this.checkDNChanged(realm, local, ldapObject);
        switch (this.editMode) {
            case READ_ONLY: {
                proxied = new ReadonlyLDAPUserModelDelegate(local, this);
                break;
            }
            case WRITABLE: {
                proxied = new WritableLDAPUserModelDelegate(local, this, ldapObject);
                break;
            }
            case UNSYNCED: {
                proxied = new UnsyncedLDAPUserModelDelegate(local, this);
            }
        }
        List mappers = realm.getComponents(this.model.getId(), LDAPStorageMapper.class.getName());
        List<ComponentModel> sortedMappers = this.sortMappersAsc(mappers);
        for (ComponentModel mapperModel : sortedMappers) {
            LDAPStorageMapper ldapMapper = this.getMapper(mapperModel);
            proxied = ldapMapper.proxy(ldapObject, proxied, realm);
        }
        return proxied;
    }

    private void checkDNChanged(RealmModel realm, UserModel local, LDAPObject ldapObject) {
        String dnFromDB = local.getFirstAttribute("LDAP_ENTRY_DN");
        String ldapDn = ldapObject.getDn().toString();
        if (!ldapDn.equals(dnFromDB)) {
            logger.debugf("Updated LDAP DN of user '%s' to '%s'", (Object)local.getUsername(), (Object)ldapDn);
            local.setSingleAttribute("LDAP_ENTRY_DN", ldapDn);
            UserCache userCache = this.session.userCache();
            if (userCache != null) {
                userCache.evict(realm, local);
            }
        }
    }

    public boolean supportsCredentialAuthenticationFor(String type) {
        return type.equals("kerberos") && this.kerberosConfig.isAllowKerberosAuthentication();
    }

    public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
        return Collections.EMPTY_LIST;
    }

    public boolean synchronizeRegistrations() {
        return "true".equalsIgnoreCase((String)this.model.getConfig().getFirst((Object)"syncRegistrations")) && this.editMode == UserStorageProvider.EditMode.WRITABLE;
    }

    public UserModel addUser(RealmModel realm, String username) {
        if (!this.synchronizeRegistrations()) {
            return null;
        }
        UserModel user = this.session.userLocalStorage().addUser(realm, username);
        user.setFederationLink(this.model.getId());
        LDAPObject ldapUser = LDAPUtils.addUserToLDAP(this, realm, user);
        LDAPUtils.checkUuid(ldapUser, this.ldapIdentityStore.getConfig());
        user.setSingleAttribute("LDAP_ID", ldapUser.getUuid());
        user.setSingleAttribute("LDAP_ENTRY_DN", ldapUser.getDn().toString());
        return this.proxy(realm, user, ldapUser);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        if (this.editMode == UserStorageProvider.EditMode.READ_ONLY || this.editMode == UserStorageProvider.EditMode.UNSYNCED) {
            logger.warnf("User '%s' can't be deleted in LDAP as editMode is '%s'. Deleting user just from Keycloak DB, but he will be re-imported from LDAP again once searched in Keycloak", (Object)user.getUsername(), (Object)this.editMode.toString());
            return true;
        }
        LDAPObject ldapObject = this.loadAndValidateUser(realm, user);
        if (ldapObject == null) {
            logger.warnf("User '%s' can't be deleted from LDAP as it doesn't exist here", (Object)user.getUsername());
            return false;
        }
        this.ldapIdentityStore.remove(ldapObject);
        return true;
    }

    public UserModel getUserById(String id, RealmModel realm) {
        StorageId storageId = new StorageId(id);
        return this.getUserByUsername(storageId.getExternalId(), realm);
    }

    public int getUsersCount(RealmModel realm) {
        return 0;
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return Collections.EMPTY_LIST;
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        return Collections.EMPTY_LIST;
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, 0, 0x7FFFFFFE);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        int spaceIndex = search.lastIndexOf(32);
        if (spaceIndex > -1) {
            String firstName = search.substring(0, spaceIndex).trim();
            String lastName = search.substring(spaceIndex).trim();
            attributes.put("firstName", firstName);
            attributes.put("lastName", lastName);
        } else if (search.indexOf(64) > -1) {
            attributes.put("username", search.trim().toLowerCase());
            attributes.put("email", search.trim().toLowerCase());
        } else {
            attributes.put("lastName", search.trim());
            attributes.put("username", search.trim().toLowerCase());
        }
        return this.searchForUser(attributes, realm, firstResult, maxResults);
    }

    public List<UserModel> searchForUser(Map<String, String> params, RealmModel realm) {
        return this.searchForUser(params, realm, 0, 0x7FFFFFFE);
    }

    public List<UserModel> searchForUser(Map<String, String> params, RealmModel realm, int firstResult, int maxResults) {
        LinkedList<UserModel> searchResults = new LinkedList<UserModel>();
        List<LDAPObject> ldapUsers = this.searchLDAP(realm, params, maxResults + firstResult);
        int counter = 0;
        for (LDAPObject ldapUser : ldapUsers) {
            if (counter++ < firstResult) continue;
            String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
            if (this.session.userLocalStorage().getUserByUsername(ldapUsername, realm) != null) continue;
            UserModel imported = this.importUserFromLDAP(this.session, realm, ldapUser);
            searchResults.add(imported);
        }
        return searchResults;
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
        return this.getGroupMembers(realm, group, 0, 0x7FFFFFFE);
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
        List mappers = realm.getComponents(this.model.getId(), LDAPStorageMapper.class.getName());
        List<ComponentModel> sortedMappers = this.sortMappersAsc(mappers);
        for (ComponentModel mapperModel : sortedMappers) {
            LDAPStorageMapper ldapMapper = this.getMapper(mapperModel);
            List<UserModel> users = ldapMapper.getGroupMembers(realm, group, firstResult, maxResults);
            if (users.size() <= 0) continue;
            return users;
        }
        return Collections.emptyList();
    }

    public List<UserModel> loadUsersByUsernames(List<String> usernames, RealmModel realm) {
        ArrayList<UserModel> result = new ArrayList<UserModel>();
        for (String username : usernames) {
            UserModel kcUser = this.session.users().getUserByUsername(username, realm);
            if (kcUser == null) {
                logger.warnf("User '%s' referenced by membership wasn't found in LDAP", (Object)username);
                continue;
            }
            if (!this.model.getId().equals(kcUser.getFederationLink())) {
                logger.warnf("Incorrect federation provider of user '%s'", (Object)kcUser.getUsername());
                continue;
            }
            result.add(kcUser);
        }
        return result;
    }

    protected List<LDAPObject> searchLDAP(RealmModel realm, Map<String, String> attributes, int maxResults) {
        List<LDAPObject> ldapObjects;
        LDAPQueryConditionsBuilder conditionsBuilder;
        LDAPQuery ldapQuery;
        ArrayList<LDAPObject> results = new ArrayList<LDAPObject>();
        if (attributes.containsKey("username")) {
            ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);
            conditionsBuilder = new LDAPQueryConditionsBuilder();
            Condition usernameCondition = conditionsBuilder.equal("username", attributes.get("username"), EscapeStrategy.NON_ASCII_CHARS_ONLY);
            ldapQuery.addWhereCondition(usernameCondition);
            ldapObjects = ldapQuery.getResultList();
            results.addAll(ldapObjects);
        }
        if (attributes.containsKey("email")) {
            ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);
            conditionsBuilder = new LDAPQueryConditionsBuilder();
            Condition emailCondition = conditionsBuilder.equal("email", attributes.get("email"), EscapeStrategy.NON_ASCII_CHARS_ONLY);
            ldapQuery.addWhereCondition(emailCondition);
            ldapObjects = ldapQuery.getResultList();
            results.addAll(ldapObjects);
        }
        if (attributes.containsKey("firstName") || attributes.containsKey("lastName")) {
            ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);
            conditionsBuilder = new LDAPQueryConditionsBuilder();
            if (attributes.containsKey("firstName")) {
                ldapQuery.addWhereCondition(conditionsBuilder.equal("firstName", attributes.get("firstName"), EscapeStrategy.NON_ASCII_CHARS_ONLY));
            }
            if (attributes.containsKey("lastName")) {
                ldapQuery.addWhereCondition(conditionsBuilder.equal("lastName", attributes.get("lastName"), EscapeStrategy.NON_ASCII_CHARS_ONLY));
            }
            List<LDAPObject> ldapObjects2 = ldapQuery.getResultList();
            results.addAll(ldapObjects2);
        }
        return results;
    }

    protected LDAPObject loadAndValidateUser(RealmModel realm, UserModel local) {
        LDAPObject ldapUser = this.loadLDAPUserByUsername(realm, local.getUsername());
        if (ldapUser == null) {
            return null;
        }
        LDAPUtils.checkUuid(ldapUser, this.ldapIdentityStore.getConfig());
        if (ldapUser.getUuid().equals(local.getFirstAttribute("LDAP_ID"))) {
            return ldapUser;
        }
        logger.warnf("LDAP User invalid. ID doesn't match. ID from LDAP [%s], LDAP ID from local DB: [%s]", (Object)ldapUser.getUuid(), (Object)local.getFirstAttribute("LDAP_ID"));
        return null;
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        LDAPObject ldapUser = this.loadLDAPUserByUsername(realm, username);
        if (ldapUser == null) {
            return null;
        }
        return this.importUserFromLDAP(this.session, realm, ldapUser);
    }

    protected UserModel importUserFromLDAP(KeycloakSession session, RealmModel realm, LDAPObject ldapUser) {
        String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
        LDAPUtils.checkUuid(ldapUser, this.ldapIdentityStore.getConfig());
        UserModel imported = session.userLocalStorage().addUser(realm, ldapUsername);
        imported.setEnabled(true);
        List mappers = realm.getComponents(this.model.getId(), LDAPStorageMapper.class.getName());
        List<ComponentModel> sortedMappers = this.sortMappersDesc(mappers);
        for (ComponentModel mapperModel : sortedMappers) {
            if (logger.isTraceEnabled()) {
                logger.tracef("Using mapper %s during import user from LDAP", (Object)mapperModel);
            }
            LDAPStorageMapper ldapMapper = this.getMapper(mapperModel);
            ldapMapper.onImportUserFromLDAP(ldapUser, imported, realm, true);
        }
        String userDN = ldapUser.getDn().toString();
        imported.setFederationLink(this.model.getId());
        imported.setSingleAttribute("LDAP_ID", ldapUser.getUuid());
        imported.setSingleAttribute("LDAP_ENTRY_DN", userDN);
        logger.debugf("Imported new user from LDAP to Keycloak DB. Username: [%s], Email: [%s], LDAP_ID: [%s], LDAP Entry DN: [%s]", new Object[]{imported.getUsername(), imported.getEmail(), ldapUser.getUuid(), userDN});
        return this.proxy(realm, imported, ldapUser);
    }

    protected LDAPObject queryByEmail(RealmModel realm, String email) {
        LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);
        LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
        Condition emailCondition = conditionsBuilder.equal("email", email, EscapeStrategy.DEFAULT);
        ldapQuery.addWhereCondition(emailCondition);
        return ldapQuery.getFirstResult();
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        LDAPObject ldapUser = this.queryByEmail(realm, email);
        if (ldapUser == null) {
            return null;
        }
        String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
        UserModel user = this.session.userLocalStorage().getUserByUsername(ldapUsername, realm);
        if (user != null) {
            LDAPUtils.checkUuid(ldapUser, this.ldapIdentityStore.getConfig());
            if (ldapUser.getUuid().equals(user.getFirstAttribute("LDAP_ID"))) {
                return user;
            }
            throw new ModelDuplicateException("User with username '" + ldapUsername + "' already exists in Keycloak. It conflicts with LDAP user with email '" + email + "'");
        }
        return this.importUserFromLDAP(this.session, realm, ldapUser);
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public void preRemove(RealmModel realm, GroupModel group) {
    }

    public boolean validPassword(RealmModel realm, UserModel user, String password) {
        if (this.kerberosConfig.isAllowKerberosAuthentication() && this.kerberosConfig.isUseKerberosForPasswordAuthentication()) {
            KerberosUsernamePasswordAuthenticator authenticator = this.factory.createKerberosUsernamePasswordAuthenticator(this.kerberosConfig);
            return authenticator.validUser(user.getUsername(), password);
        }
        LDAPObject ldapUser = this.loadAndValidateUser(realm, user);
        try {
            this.ldapIdentityStore.validatePassword(ldapUser, password);
            return true;
        }
        catch (AuthenticationException ae) {
            boolean processed = false;
            List mappers = realm.getComponents(this.model.getId(), LDAPStorageMapper.class.getName());
            List<ComponentModel> sortedMappers = this.sortMappersDesc(mappers);
            for (ComponentModel mapperModel : sortedMappers) {
                if (logger.isTraceEnabled()) {
                    logger.tracef("Using mapper %s during import user from LDAP", (Object)mapperModel);
                }
                LDAPStorageMapper ldapMapper = this.getMapper(mapperModel);
                processed = processed || ldapMapper.onAuthenticationFailure(ldapUser, user, ae, realm);
            }
            return processed;
        }
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        if (!"password".equals(input.getType()) || !(input instanceof UserCredentialModel)) {
            return false;
        }
        if (this.editMode == UserStorageProvider.EditMode.READ_ONLY) {
            throw new ModelReadOnlyException("Federated storage is not writable");
        }
        if (this.editMode == UserStorageProvider.EditMode.WRITABLE) {
            LDAPIdentityStore ldapIdentityStore = this.getLdapIdentityStore();
            UserCredentialModel cred = (UserCredentialModel)input;
            String password = cred.getValue();
            LDAPObject ldapUser = this.loadAndValidateUser(realm, user);
            try {
                ldapIdentityStore.updatePassword(ldapUser, password);
                if (this.updater != null) {
                    this.updater.passwordUpdated(user, ldapUser, input);
                }
                return true;
            }
            catch (ModelException me) {
                if (this.updater != null) {
                    this.updater.passwordUpdateFailed(user, ldapUser, input, me);
                    return false;
                }
                throw me;
            }
        }
        return false;
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
    }

    public Set<String> getDisableableCredentialTypes(RealmModel realm, UserModel user) {
        return Collections.EMPTY_SET;
    }

    public Set<String> getSupportedCredentialTypes() {
        return new HashSet<String>(this.supportedCredentialTypes);
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getSupportedCredentialTypes().contains(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return this.getSupportedCredentialTypes().contains(credentialType);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            return false;
        }
        if (input.getType().equals("password") && !this.session.userCredentialManager().isConfiguredLocally(realm, user, "password")) {
            return this.validPassword(realm, user, ((UserCredentialModel)input).getValue());
        }
        return false;
    }

    public CredentialValidationOutput authenticate(RealmModel realm, CredentialInput cred) {
        UserCredentialModel credential;
        if (!(cred instanceof UserCredentialModel)) {
            CredentialValidationOutput.failed();
        }
        if ((credential = (UserCredentialModel)cred).getType().equals("kerberos") && this.kerberosConfig.isAllowKerberosAuthentication()) {
            String spnegoToken = credential.getValue();
            SPNEGOAuthenticator spnegoAuthenticator = this.factory.createSPNEGOAuthenticator(spnegoToken, this.kerberosConfig);
            spnegoAuthenticator.authenticate();
            HashMap<String, String> state = new HashMap<String, String>();
            if (spnegoAuthenticator.isAuthenticated()) {
                String username = spnegoAuthenticator.getAuthenticatedUsername();
                UserModel user = this.findOrCreateAuthenticatedUser(realm, username);
                if (user == null) {
                    logger.warnf("Kerberos/SPNEGO authentication succeeded with username [%s], but couldn't find or create user with federation provider [%s]", (Object)username, (Object)this.model.getName());
                    return CredentialValidationOutput.failed();
                }
                String delegationCredential = spnegoAuthenticator.getSerializedDelegationCredential();
                if (delegationCredential != null) {
                    state.put("gss_delegation_credential", delegationCredential);
                }
                return new CredentialValidationOutput(user, CredentialValidationOutput.Status.AUTHENTICATED, state);
            }
            state.put("SpnegoResponseToken", spnegoAuthenticator.getResponseToken());
            return new CredentialValidationOutput(null, CredentialValidationOutput.Status.CONTINUE, state);
        }
        return CredentialValidationOutput.failed();
    }

    public void close() {
    }

    protected UserModel findOrCreateAuthenticatedUser(RealmModel realm, String username) {
        UserModel user = this.session.userLocalStorage().getUserByUsername(username, realm);
        if (user != null) {
            logger.debugf("Kerberos authenticated user [%s] found in Keycloak storage", (Object)username);
            if (!this.model.getId().equals(user.getFederationLink())) {
                logger.warnf("User with username [%s] already exists, but is not linked to provider [%s]", (Object)username, (Object)this.model.getName());
                return null;
            }
            LDAPObject ldapObject = this.loadAndValidateUser(realm, user);
            if (ldapObject != null) {
                return this.proxy(realm, user, ldapObject);
            }
            logger.warnf("User with username [%s] aready exists and is linked to provider [%s] but is not valid. Stale LDAP_ID on local user is: %s", (Object)username, (Object)this.model.getName(), (Object)user.getFirstAttribute("LDAP_ID"));
            logger.warn((Object)"Will re-create user");
            this.session.userCache().evict(realm, user);
            new UserManager(this.session).removeUser(realm, user, this.session.userLocalStorage());
        }
        logger.debugf("Kerberos authenticated user [%s] not in Keycloak storage. Creating him", (Object)username);
        return this.getUserByUsername(username, realm);
    }

    public LDAPObject loadLDAPUserByUsername(RealmModel realm, String username) {
        LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);
        LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
        String usernameMappedAttribute = this.ldapIdentityStore.getConfig().getUsernameLdapAttribute();
        Condition usernameCondition = conditionsBuilder.equal(usernameMappedAttribute, username, EscapeStrategy.DEFAULT);
        ldapQuery.addWhereCondition(usernameCondition);
        LDAPObject ldapUser = ldapQuery.getFirstResult();
        if (ldapUser == null) {
            return null;
        }
        return ldapUser;
    }

    public LDAPStorageMapper getMapper(ComponentModel mapperModel) {
        LDAPStorageMapper ldapMapper = (LDAPStorageMapper)this.getSession().getProvider(LDAPStorageMapper.class, mapperModel);
        if (ldapMapper == null) {
            throw new ModelException("Can't find mapper type with ID: " + mapperModel.getProviderId());
        }
        return ldapMapper;
    }

    public List<ComponentModel> sortMappersAsc(Collection<ComponentModel> mappers) {
        return LDAPMappersComparator.sortAsc(this.getLdapIdentityStore().getConfig(), mappers);
    }

    protected List<ComponentModel> sortMappersDesc(Collection<ComponentModel> mappers) {
        return LDAPMappersComparator.sortDesc(this.getLdapIdentityStore().getConfig(), mappers);
    }
}

