/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.membership.group;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class GroupTreeResolver {
    public List<GroupTreeEntry> resolveGroupTree(List<Group> groups) throws GroupTreeResolveException {
        Map<String, List<String>> parentsTree = this.getParentsTree(groups);
        LinkedList rootGroups = new LinkedList();
        for (Map.Entry<String, List<String>> group : parentsTree.entrySet()) {
            int parentCount = group.getValue().size();
            if (parentCount == 0) {
                rootGroups.add(group.getKey());
                continue;
            }
            if (parentCount <= 1) continue;
            throw new GroupTreeResolveException("Group '" + (String)group.getKey() + "' detected to have multiple parents. This is not allowed in Keycloak. Parents are: " + group.getValue());
        }
        TreeMap<String, Group> asMap = new TreeMap<String, Group>();
        for (Group group : groups) {
            asMap.put(group.getGroupName(), group);
        }
        LinkedList<GroupTreeEntry> finalResult = new LinkedList<GroupTreeEntry>();
        TreeSet<String> visitedGroups = new TreeSet<String>();
        for (String string : rootGroups) {
            LinkedList<String> subtree = new LinkedList<String>();
            subtree.add(string);
            GroupTreeEntry groupTree = this.resolveGroupTree(string, asMap, visitedGroups, subtree);
            finalResult.add(groupTree);
        }
        if (visitedGroups.size() != asMap.size()) {
            for (Map.Entry entry : asMap.entrySet()) {
                String groupName = (String)entry.getKey();
                if (visitedGroups.contains(groupName)) continue;
                LinkedList<String> subtree = new LinkedList<String>();
                subtree.add(groupName);
                TreeSet<String> newVisitedGroups = new TreeSet<String>();
                this.resolveGroupTree(groupName, asMap, newVisitedGroups, subtree);
                visitedGroups.addAll(newVisitedGroups);
            }
            throw new GroupTreeResolveException("Illegal state: Recursion detected, but wasn't able to find it");
        }
        return finalResult;
    }

    private Map<String, List<String>> getParentsTree(List<Group> groups) throws GroupTreeResolveException {
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>();
        for (Group group : groups) {
            result.put(group.getGroupName(), new LinkedList());
        }
        for (Group group : groups) {
            for (String child : group.getChildrenNames()) {
                List list = (List)result.get(child);
                if (list == null) {
                    throw new GroupTreeResolveException("Group '" + child + "' referenced as member of group '" + group.getGroupName() + "' doesn't exists");
                }
                list.add(group.getGroupName());
            }
        }
        return result;
    }

    private GroupTreeEntry resolveGroupTree(String groupName, Map<String, Group> asMap, Set<String> visitedGroups, List<String> currentSubtree) throws GroupTreeResolveException {
        if (visitedGroups.contains(groupName)) {
            throw new GroupTreeResolveException("Recursion detected when trying to resolve group '" + groupName + "'. Whole recursion path: " + currentSubtree);
        }
        visitedGroups.add(groupName);
        Group group = asMap.get(groupName);
        LinkedList<GroupTreeEntry> children = new LinkedList<GroupTreeEntry>();
        GroupTreeEntry result = new GroupTreeEntry(group.getGroupName(), children);
        for (String childrenName : group.getChildrenNames()) {
            LinkedList<String> subtreeCopy = new LinkedList<String>(currentSubtree);
            subtreeCopy.add(childrenName);
            GroupTreeEntry childEntry = this.resolveGroupTree(childrenName, asMap, visitedGroups, subtreeCopy);
            children.add(childEntry);
        }
        return result;
    }

    public static class GroupTreeEntry {
        private final String groupName;
        private final List<GroupTreeEntry> children;

        public GroupTreeEntry(String groupName, List<GroupTreeEntry> children) {
            this.groupName = groupName;
            this.children = children;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public List<GroupTreeEntry> getChildren() {
            return this.children;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("{ " + this.groupName + " -> [ ");
            for (GroupTreeEntry child : this.children) {
                builder.append(child.toString());
            }
            builder.append(" ]}");
            return builder.toString();
        }
    }

    public static class Group {
        private final String groupName;
        private final List<String> childrenNames;

        public Group(String groupName, String ... childrenNames) {
            this(groupName, Arrays.asList(childrenNames));
        }

        public Group(String groupName, Collection<String> childrenNames) {
            this.groupName = groupName;
            this.childrenNames = new LinkedList<String>(childrenNames);
        }

        public String getGroupName() {
            return this.groupName;
        }

        public List<String> getChildrenNames() {
            return this.childrenNames;
        }
    }

    public static class GroupTreeResolveException
    extends Exception {
        public GroupTreeResolveException(String message) {
            super(message);
        }
    }
}

