/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeMapperModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;

public interface RealmModel
extends RoleContainerModel,
RoleMapperModel,
ScopeMapperModel {
    public String getId();

    public String getName();

    public void setName(String var1);

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public boolean isSslNotRequired();

    public void setSslNotRequired(boolean var1);

    public boolean isRegistrationAllowed();

    public void setRegistrationAllowed(boolean var1);

    public boolean isRememberMe();

    public void setRememberMe(boolean var1);

    public boolean isVerifyEmail();

    public void setVerifyEmail(boolean var1);

    public boolean isResetPasswordAllowed();

    public void setResetPasswordAllowed(boolean var1);

    public int getCentralLoginLifespan();

    public void setCentralLoginLifespan(int var1);

    public int getAccessTokenLifespan();

    public void setAccessTokenLifespan(int var1);

    public int getRefreshTokenLifespan();

    public void setRefreshTokenLifespan(int var1);

    public int getAccessCodeLifespan();

    public void setAccessCodeLifespan(int var1);

    public int getAccessCodeLifespanUserAction();

    public void setAccessCodeLifespanUserAction(int var1);

    public String getPublicKeyPem();

    public void setPublicKeyPem(String var1);

    public String getPrivateKeyPem();

    public void setPrivateKeyPem(String var1);

    public PublicKey getPublicKey();

    public void setPublicKey(PublicKey var1);

    public PrivateKey getPrivateKey();

    public void setPrivateKey(PrivateKey var1);

    public List<RequiredCredentialModel> getRequiredCredentials();

    public void addRequiredCredential(String var1);

    public PasswordPolicy getPasswordPolicy();

    public void setPasswordPolicy(PasswordPolicy var1);

    public boolean validatePassword(UserModel var1, String var2);

    public boolean validateTOTP(UserModel var1, String var2, String var3);

    public void updateCredential(UserModel var1, UserCredentialModel var2);

    public UserModel getUser(String var1);

    public UserModel getUserByEmail(String var1);

    public UserModel getUserById(String var1);

    public UserModel addUser(String var1);

    public boolean removeUser(String var1);

    public RoleModel getRoleById(String var1);

    public List<String> getDefaultRoles();

    public void addDefaultRole(String var1);

    public void updateDefaultRoles(String[] var1);

    public ClientModel findClient(String var1);

    public Map<String, ApplicationModel> getApplicationNameMap();

    public List<ApplicationModel> getApplications();

    public ApplicationModel addApplication(String var1);

    public boolean removeApplication(String var1);

    public ApplicationModel getApplicationById(String var1);

    public ApplicationModel getApplicationByName(String var1);

    public void updateRequiredCredentials(Set<String> var1);

    public UserModel getUserBySocialLink(SocialLinkModel var1);

    public Set<SocialLinkModel> getSocialLinks(UserModel var1);

    public SocialLinkModel getSocialLink(UserModel var1, String var2);

    public void addSocialLink(UserModel var1, SocialLinkModel var2);

    public boolean removeSocialLink(UserModel var1, String var2);

    public boolean isSocial();

    public void setSocial(boolean var1);

    public boolean isUpdateProfileOnInitialSocialLogin();

    public void setUpdateProfileOnInitialSocialLogin(boolean var1);

    public List<UserModel> getUsers();

    public List<UserModel> searchForUser(String var1);

    public List<UserModel> searchForUserByAttributes(Map<String, String> var1);

    public OAuthClientModel addOAuthClient(String var1);

    public OAuthClientModel getOAuthClient(String var1);

    public OAuthClientModel getOAuthClientById(String var1);

    public boolean removeOAuthClient(String var1);

    public List<OAuthClientModel> getOAuthClients();

    public Map<String, String> getSmtpConfig();

    public void setSmtpConfig(Map<String, String> var1);

    public Map<String, String> getSocialConfig();

    public void setSocialConfig(Map<String, String> var1);

    public Set<RoleModel> getRealmRoleMappings(UserModel var1);

    public Set<RoleModel> getRealmScopeMappings(ClientModel var1);

    public String getLoginTheme();

    public void setLoginTheme(String var1);

    public String getAccountTheme();

    public void setAccountTheme(String var1);

    public boolean hasScope(ClientModel var1, RoleModel var2);

    public int getNotBefore();

    public void setNotBefore(int var1);

    public boolean removeRoleById(String var1);
}

