/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.ServiceLoader;
import org.keycloak.models.Config;
import org.keycloak.models.ModelProvider;

public class ModelProviderUtils {
    public static final String DEFAULT_MODEL_PROVIDER = "jpa";

    public static Iterable<ModelProvider> getRegisteredProviders() {
        return ServiceLoader.load(ModelProvider.class);
    }

    public static ModelProvider getConfiguredModelProvider(Iterable<ModelProvider> providers) {
        String configuredProvider = Config.getModelProvider();
        ModelProvider provider = null;
        if (configuredProvider != null) {
            for (ModelProvider p : providers) {
                if (!p.getId().equals(configuredProvider)) continue;
                provider = p;
            }
        } else {
            for (ModelProvider p : providers) {
                if (provider == null) {
                    provider = p;
                }
                if (!p.getId().equals(DEFAULT_MODEL_PROVIDER)) continue;
                provider = p;
                break;
            }
        }
        return provider;
    }

    public static ModelProvider getConfiguredModelProvider() {
        return ModelProviderUtils.getConfiguredModelProvider(ModelProviderUtils.getRegisteredProviders());
    }
}

