/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.AuthenticationLinkModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;

public interface UserModel {
    public static final String LOGIN_NAME = "username";
    public static final String LAST_NAME = "lastName";
    public static final String FIRST_NAME = "firstName";
    public static final String EMAIL = "email";

    public String getId();

    public String getLoginName();

    public void setLoginName(String var1);

    public boolean isEnabled();

    public boolean isTotp();

    public void setEnabled(boolean var1);

    public void setAttribute(String var1, String var2);

    public void removeAttribute(String var1);

    public String getAttribute(String var1);

    public Map<String, String> getAttributes();

    public Set<RequiredAction> getRequiredActions();

    public void addRequiredAction(RequiredAction var1);

    public void removeRequiredAction(RequiredAction var1);

    public String getFirstName();

    public void setFirstName(String var1);

    public String getLastName();

    public void setLastName(String var1);

    public String getEmail();

    public void setEmail(String var1);

    public boolean isEmailVerified();

    public void setEmailVerified(boolean var1);

    public void setTotp(boolean var1);

    public int getNotBefore();

    public void setNotBefore(int var1);

    public void updateCredential(UserCredentialModel var1);

    public List<UserCredentialValueModel> getCredentialsDirectly();

    public void updateCredentialDirectly(UserCredentialValueModel var1);

    public AuthenticationLinkModel getAuthenticationLink();

    public void setAuthenticationLink(AuthenticationLinkModel var1);

    public Set<RoleModel> getRealmRoleMappings();

    public Set<RoleModel> getApplicationRoleMappings(ApplicationModel var1);

    public boolean hasRole(RoleModel var1);

    public void grantRole(RoleModel var1);

    public Set<RoleModel> getRoleMappings();

    public void deleteRoleMapping(RoleModel var1);

    public static enum RequiredAction {
        VERIFY_EMAIL,
        UPDATE_PROFILE,
        CONFIGURE_TOTP,
        UPDATE_PASSWORD;

    }
}

