/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.keycloak.common.util.Base64;

public class Pbkdf2PasswordEncoder {
    public static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final String RNG_ALGORITHM = "SHA1PRNG";
    private static final int DERIVED_KEY_SIZE = 512;
    private static final int ITERATIONS = 1;
    private final int iterations;
    private byte[] salt;

    public Pbkdf2PasswordEncoder(byte[] salt, int iterations) {
        this.salt = salt;
        this.iterations = iterations;
    }

    public Pbkdf2PasswordEncoder(byte[] salt) {
        this(salt, 1);
    }

    public String encode(String rawPassword, int iterations) {
        String encodedPassword;
        PBEKeySpec spec = new PBEKeySpec(rawPassword.toCharArray(), this.salt, iterations, 512);
        try {
            byte[] key = Pbkdf2PasswordEncoder.getSecretKeyFactory().generateSecret(spec).getEncoded();
            encodedPassword = Base64.encodeBytes((byte[])key);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Credential could not be encoded");
        }
        return encodedPassword;
    }

    public String encode(String rawPassword) {
        return this.encode(rawPassword, this.iterations);
    }

    public boolean verify(String rawPassword, String encodedPassword) {
        return this.encode(rawPassword).equals(encodedPassword);
    }

    public boolean verify(String rawPassword, String encodedPassword, int iterations) {
        return this.encode(rawPassword, iterations).equals(encodedPassword);
    }

    public static byte[] getSalt() {
        byte[] buffer = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(buffer);
        return buffer;
    }

    private static SecretKeyFactory getSecretKeyFactory() {
        try {
            return SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("PBKDF2 algorithm not found");
        }
    }
}

