/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.keycloak.models.map.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Specifies the default implementation with a no-args constructor for
 * a container property (e.g. a {@code} List} or a {@code Map}).
 * <p>
 * Applicable to a setter of a single key from the map (e.g. {@code setAttribute}) or an adder to
 * a collection (e.g. {@code addWebOrigin}). This is used to override default type generated by the
 * generator in case the entry does not exist yet and a new container needs to be instantiated.
 *
 * Example:
 * <pre>
 *  @GeneratedFieldType(HashSet) void addWebOrigin() { ... }
 * </pre>
 * 
 * @author hmlnarik
 */
@Retention(RetentionPolicy.SOURCE)
@Target(ElementType.METHOD)
public @interface GeneratedFieldType {
    Class<?> value() default Void.class;
}
