/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.RealmCacheSession;
import org.keycloak.models.cache.infinispan.entities.CachedClientRole;
import org.keycloak.models.cache.infinispan.entities.CachedRealmRole;
import org.keycloak.models.cache.infinispan.entities.CachedRole;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RoleAdapter
implements RoleModel {
    protected RoleModel updated;
    protected CachedRole cached;
    protected RealmCacheSession cacheSession;
    protected RealmModel realm;
    protected boolean invalidated;

    public RoleAdapter(CachedRole cached, RealmCacheSession session, RealmModel realm) {
        this.cached = cached;
        this.cacheSession = session;
        this.realm = realm;
    }

    protected void getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerRoleInvalidation(this.cached.getId());
            this.updated = this.cacheSession.getDelegate().getRoleById(this.cached.getId(), this.realm);
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
    }

    public void invalidate() {
        this.invalidated = true;
    }

    protected boolean isUpdated() {
        if (this.updated != null) {
            return true;
        }
        if (!this.invalidated) {
            return false;
        }
        this.updated = this.cacheSession.getDelegate().getRoleById(this.cached.getId(), this.realm);
        if (this.updated == null) {
            throw new IllegalStateException("Not found in database");
        }
        return true;
    }

    public String getName() {
        if (this.isUpdated()) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public String getDescription() {
        if (this.isUpdated()) {
            return this.updated.getDescription();
        }
        return this.cached.getDescription();
    }

    public void setDescription(String description) {
        this.getDelegateForUpdate();
        this.updated.setDescription(description);
    }

    public boolean isScopeParamRequired() {
        if (this.isUpdated()) {
            return this.updated.isScopeParamRequired();
        }
        return this.cached.isScopeParamRequired();
    }

    public void setScopeParamRequired(boolean scopeParamRequired) {
        this.getDelegateForUpdate();
        this.updated.setScopeParamRequired(scopeParamRequired);
    }

    public String getId() {
        if (this.isUpdated()) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.updated.setName(name);
    }

    public boolean isComposite() {
        if (this.isUpdated()) {
            return this.updated.isComposite();
        }
        return this.cached.isComposite();
    }

    public void addCompositeRole(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.addCompositeRole(role);
    }

    public void removeCompositeRole(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.removeCompositeRole(role);
    }

    public Set<RoleModel> getComposites() {
        if (this.isUpdated()) {
            return this.updated.getComposites();
        }
        HashSet<RoleModel> set = new HashSet<RoleModel>();
        for (String id : this.cached.getComposites()) {
            RoleModel role = this.realm.getRoleById(id);
            if (role == null) {
                throw new IllegalStateException("Could not find composite in role " + this.getName() + ": " + id);
            }
            set.add(role);
        }
        return set;
    }

    public boolean isClientRole() {
        return this.cached instanceof CachedClientRole;
    }

    public String getContainerId() {
        if (this.isClientRole()) {
            CachedClientRole appRole = (CachedClientRole)this.cached;
            return appRole.getClientId();
        }
        return this.realm.getId();
    }

    public RoleContainerModel getContainer() {
        if (this.cached instanceof CachedRealmRole) {
            return this.realm;
        }
        CachedClientRole appRole = (CachedClientRole)this.cached;
        return this.realm.getClientById(appRole.getClientId());
    }

    public boolean hasRole(RoleModel role) {
        if (this.equals(role)) {
            return true;
        }
        if (!this.isComposite()) {
            return false;
        }
        HashSet visited = new HashSet();
        return KeycloakModelUtils.searchFor((RoleModel)role, (RoleModel)this, visited);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RoleModel)) {
            return false;
        }
        RoleModel that = (RoleModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

