/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;

public class OfflineUserSessionLoader
implements SessionLoader {
    private static final Logger log = Logger.getLogger(OfflineUserSessionLoader.class);

    @Override
    public void init(KeycloakSession session) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
        int clusterStartupTime = ((ClusterProvider)session.getProvider(ClusterProvider.class)).getClusterStartupTime();
        log.debugf("Clearing detached sessions from persistent storage and updating timestamps to %d", clusterStartupTime);
        persister.clearDetachedUserSessions();
        persister.updateAllTimestamps(clusterStartupTime);
    }

    @Override
    public int getSessionsCount(KeycloakSession session) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
        return persister.getUserSessionsCount(true);
    }

    @Override
    public boolean loadSessions(KeycloakSession session, int first, int max) {
        if (log.isTraceEnabled()) {
            log.tracef("Loading sessions - first: %d, max: %d", first, max);
        }
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
        List sessions = persister.loadUserSessions(first, max, true);
        for (UserSessionModel persistentSession : sessions) {
            UserSessionModel offlineUserSession = session.sessions().importUserSession(persistentSession, true);
            for (ClientSessionModel persistentClientSession : persistentSession.getClientSessions()) {
                ClientSessionModel offlineClientSession = session.sessions().importClientSession(persistentClientSession, true);
                offlineClientSession.setUserSession(offlineUserSession);
            }
        }
        return true;
    }
}

