/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.InRealm;

public class CachedClient
extends AbstractRevisioned
implements InRealm {
    protected String clientId;
    protected String name;
    protected String description;
    protected String realm;
    protected Set<String> redirectUris = new HashSet<String>();
    protected boolean enabled;
    protected boolean alwaysDisplayInConsole;
    protected String clientAuthenticatorType;
    protected String secret;
    protected String registrationToken;
    protected String protocol;
    protected Map<String, String> attributes = new HashMap<String, String>();
    protected Map<String, String> authFlowBindings = new HashMap<String, String>();
    protected boolean publicClient;
    protected boolean fullScopeAllowed;
    protected boolean frontchannelLogout;
    protected int notBefore;
    protected Set<String> scope = new HashSet<String>();
    protected Set<String> webOrigins = new HashSet<String>();
    protected Set<ProtocolMapperModel> protocolMappers = new HashSet<ProtocolMapperModel>();
    protected boolean surrogateAuthRequired;
    protected String managementUrl;
    protected String rootUrl;
    protected String baseUrl;
    protected List<String> defaultRoles = new LinkedList<String>();
    protected boolean bearerOnly;
    protected boolean consentRequired;
    protected boolean standardFlowEnabled;
    protected boolean implicitFlowEnabled;
    protected boolean directAccessGrantsEnabled;
    protected boolean serviceAccountsEnabled;
    protected int nodeReRegistrationTimeout;
    protected Map<String, Integer> registeredNodes;
    protected List<String> defaultClientScopesIds;
    protected List<String> optionalClientScopesIds;

    public CachedClient(Long revision, RealmModel realm, ClientModel model) {
        super(revision, model.getId());
        this.clientAuthenticatorType = model.getClientAuthenticatorType();
        this.secret = model.getSecret();
        this.registrationToken = model.getRegistrationToken();
        this.clientId = model.getClientId();
        this.name = model.getName();
        this.description = model.getDescription();
        this.realm = realm.getId();
        this.enabled = model.isEnabled();
        this.alwaysDisplayInConsole = model.isAlwaysDisplayInConsole();
        this.protocol = model.getProtocol();
        this.attributes.putAll(model.getAttributes());
        this.authFlowBindings.putAll(model.getAuthenticationFlowBindingOverrides());
        this.notBefore = model.getNotBefore();
        this.frontchannelLogout = model.isFrontchannelLogout();
        this.publicClient = model.isPublicClient();
        this.fullScopeAllowed = model.isFullScopeAllowed();
        this.redirectUris.addAll(model.getRedirectUris());
        this.webOrigins.addAll(model.getWebOrigins());
        this.scope.addAll(model.getScopeMappingsStream().map(RoleModel::getId).collect(Collectors.toSet()));
        this.protocolMappers.addAll(model.getProtocolMappersStream().collect(Collectors.toSet()));
        this.surrogateAuthRequired = model.isSurrogateAuthRequired();
        this.managementUrl = model.getManagementUrl();
        this.rootUrl = model.getRootUrl();
        this.baseUrl = model.getBaseUrl();
        this.defaultRoles.addAll(model.getDefaultRolesStream().collect(Collectors.toList()));
        this.bearerOnly = model.isBearerOnly();
        this.consentRequired = model.isConsentRequired();
        this.standardFlowEnabled = model.isStandardFlowEnabled();
        this.implicitFlowEnabled = model.isImplicitFlowEnabled();
        this.directAccessGrantsEnabled = model.isDirectAccessGrantsEnabled();
        this.serviceAccountsEnabled = model.isServiceAccountsEnabled();
        this.nodeReRegistrationTimeout = model.getNodeReRegistrationTimeout();
        this.registeredNodes = new TreeMap<String, Integer>(model.getRegisteredNodes());
        this.defaultClientScopesIds = new LinkedList<String>();
        for (ClientScopeModel clientScope : model.getClientScopes(true, false).values()) {
            this.defaultClientScopesIds.add(clientScope.getId());
        }
        this.optionalClientScopesIds = new LinkedList<String>();
        for (ClientScopeModel clientScope : model.getClientScopes(false, false).values()) {
            this.optionalClientScopesIds.add(clientScope.getId());
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public Set<String> getRedirectUris() {
        return this.redirectUris;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAlwaysDisplayInConsole() {
        return this.alwaysDisplayInConsole;
    }

    public String getClientAuthenticatorType() {
        return this.clientAuthenticatorType;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getRegistrationToken() {
        return this.registrationToken;
    }

    public boolean isPublicClient() {
        return this.publicClient;
    }

    public int getNotBefore() {
        return this.notBefore;
    }

    public Set<String> getScope() {
        return this.scope;
    }

    public Set<String> getWebOrigins() {
        return this.webOrigins;
    }

    public boolean isFullScopeAllowed() {
        return this.fullScopeAllowed;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isFrontchannelLogout() {
        return this.frontchannelLogout;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        return this.protocolMappers;
    }

    public boolean isSurrogateAuthRequired() {
        return this.surrogateAuthRequired;
    }

    public String getManagementUrl() {
        return this.managementUrl;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public List<String> getDefaultRoles() {
        return this.defaultRoles;
    }

    public boolean isBearerOnly() {
        return this.bearerOnly;
    }

    public boolean isConsentRequired() {
        return this.consentRequired;
    }

    public boolean isStandardFlowEnabled() {
        return this.standardFlowEnabled;
    }

    public boolean isImplicitFlowEnabled() {
        return this.implicitFlowEnabled;
    }

    public boolean isDirectAccessGrantsEnabled() {
        return this.directAccessGrantsEnabled;
    }

    public boolean isServiceAccountsEnabled() {
        return this.serviceAccountsEnabled;
    }

    public int getNodeReRegistrationTimeout() {
        return this.nodeReRegistrationTimeout;
    }

    public Map<String, Integer> getRegisteredNodes() {
        return this.registeredNodes;
    }

    public List<String> getDefaultClientScopesIds() {
        return this.defaultClientScopesIds;
    }

    public List<String> getOptionalClientScopesIds() {
        return this.optionalClientScopesIds;
    }

    public Map<String, String> getAuthFlowBindings() {
        return this.authFlowBindings;
    }
}

