/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.context.Flag;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Retry;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.initializer.BaseCacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.OfflinePersistentLoaderContext;
import org.keycloak.models.sessions.infinispan.initializer.OfflinePersistentWorkerContext;
import org.keycloak.models.sessions.infinispan.initializer.OfflinePersistentWorkerResult;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;

public class OfflinePersistentUserSessionLoader
implements SessionLoader<OfflinePersistentLoaderContext, OfflinePersistentWorkerContext, OfflinePersistentWorkerResult>,
Serializable {
    private static final String FIRST_SESSION_ID = "000";
    private static final Logger log = Logger.getLogger(OfflinePersistentUserSessionLoader.class);
    public static final String PERSISTENT_SESSIONS_LOADED = "PERSISTENT_SESSIONS_LOADED";
    public static final String PERSISTENT_SESSIONS_LOADED_IN_CURRENT_DC = "PERSISTENT_SESSIONS_LOADED_IN_CURRENT_DC";
    private final int sessionsPerSegment;

    public OfflinePersistentUserSessionLoader(int sessionsPerSegment) {
        this.sessionsPerSegment = sessionsPerSegment;
    }

    @Override
    public void init(KeycloakSession session) {
    }

    @Override
    public OfflinePersistentLoaderContext computeLoaderContext(KeycloakSession session) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
        int sessionsCount = persister.getUserSessionsCount(true);
        return new OfflinePersistentLoaderContext(sessionsCount, this.sessionsPerSegment);
    }

    @Override
    public OfflinePersistentWorkerContext computeWorkerContext(OfflinePersistentLoaderContext loaderCtx, int segment, int workerId, OfflinePersistentWorkerResult previousResult) {
        String lastSessionId;
        int lastCreatedOn;
        if (previousResult == null) {
            lastCreatedOn = 0;
            lastSessionId = FIRST_SESSION_ID;
        } else {
            lastCreatedOn = previousResult.getLastCreatedOn();
            lastSessionId = previousResult.getLastSessionId();
        }
        return new OfflinePersistentWorkerContext(segment, workerId, lastCreatedOn, lastSessionId);
    }

    @Override
    public OfflinePersistentWorkerResult createFailedWorkerResult(OfflinePersistentLoaderContext loaderContext, OfflinePersistentWorkerContext workerContext) {
        return new OfflinePersistentWorkerResult(false, workerContext.getSegment(), workerContext.getWorkerId(), -1, FIRST_SESSION_ID);
    }

    @Override
    public OfflinePersistentWorkerResult loadSessions(KeycloakSession session, OfflinePersistentLoaderContext loaderContext, OfflinePersistentWorkerContext ctx) {
        int first = ctx.getWorkerId() * this.sessionsPerSegment;
        log.tracef("Loading sessions for segment=%d createdOn=%d lastSessionId=%s", ctx.getSegment(), ctx.getLastCreatedOn(), (Object)ctx.getLastSessionId());
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
        List sessions = persister.loadUserSessionsStream(Integer.valueOf(first), Integer.valueOf(this.sessionsPerSegment), true, Integer.valueOf(ctx.getLastCreatedOn()), ctx.getLastSessionId()).collect(Collectors.toList());
        log.tracef("Sessions loaded from DB - segment=%d createdOn=%d lastSessionId=%s", ctx.getSegment(), ctx.getLastCreatedOn(), (Object)ctx.getLastSessionId());
        UserSessionModel lastSession = null;
        if (!sessions.isEmpty()) {
            lastSession = (UserSessionModel)sessions.get(sessions.size() - 1);
            session.sessions().importUserSessions(sessions, true);
        }
        int lastCreatedOn = lastSession == null ? Time.currentTime() + 100000 : lastSession.getStarted();
        String lastSessionId = lastSession == null ? FIRST_SESSION_ID : lastSession.getId();
        log.tracef("Sessions imported to infinispan - segment: %d, lastCreatedOn: %d, lastSessionId: %s", ctx.getSegment(), lastCreatedOn, (Object)lastSessionId);
        return new OfflinePersistentWorkerResult(true, ctx.getSegment(), ctx.getWorkerId(), lastCreatedOn, lastSessionId);
    }

    @Override
    public boolean isFinished(BaseCacheInitializer initializer) {
        Cache<String, Serializable> workCache = initializer.getWorkCache();
        Boolean sessionsLoaded = (Boolean)workCache.get((Object)PERSISTENT_SESSIONS_LOADED);
        if (sessionsLoaded != null && sessionsLoaded.booleanValue()) {
            log.debugf("Persistent sessions loaded already.", new Object[0]);
            return true;
        }
        log.debugf("Persistent sessions not yet loaded.", new Object[0]);
        return false;
    }

    @Override
    public void afterAllSessionsLoaded(BaseCacheInitializer initializer) {
        Cache<String, Serializable> workCache = initializer.getWorkCache();
        Retry.executeWithBackoff(iteration -> {
            try {
                workCache.getAdvancedCache().withFlags(Flag.SKIP_REMOTE_LOOKUP).put((Object)PERSISTENT_SESSIONS_LOADED, (Object)true);
            }
            catch (HotRodClientException re) {
                log.warnf((Throwable)re, "Failed to write flag PERSISTENT_SESSIONS_LOADED in iteration '%d' . Retrying", (Object)iteration);
                throw re;
            }
        }, (int)10, (int)10);
        workCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_CACHE_LOAD, Flag.SKIP_CACHE_STORE}).put((Object)PERSISTENT_SESSIONS_LOADED_IN_CURRENT_DC, (Object)true);
        log.debugf("Persistent sessions loaded successfully!", new Object[0]);
    }

    public String toString() {
        return "OfflinePersistentUserSessionLoader [ " + "sessionsPerSegment: " + this.sessionsPerSegment + " ]";
    }
}

