/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.Serializable;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.initializer.BaseCacheInitializer;

public interface SessionLoader<LOADER_CONTEXT extends LoaderContext, WORKER_CONTEXT extends WorkerContext, WORKER_RESULT extends WorkerResult>
extends Serializable {
    public void init(KeycloakSession var1);

    public LOADER_CONTEXT computeLoaderContext(KeycloakSession var1);

    public WORKER_CONTEXT computeWorkerContext(LOADER_CONTEXT var1, int var2, int var3, WORKER_RESULT var4);

    public WORKER_RESULT loadSessions(KeycloakSession var1, LOADER_CONTEXT var2, WORKER_CONTEXT var3);

    public WORKER_RESULT createFailedWorkerResult(LOADER_CONTEXT var1, WORKER_CONTEXT var2);

    public boolean isFinished(BaseCacheInitializer var1);

    public void afterAllSessionsLoaded(BaseCacheInitializer var1);

    public static class WorkerResult
    implements Serializable {
        private final boolean success;
        private final int segment;
        private final int workerId;

        public WorkerResult(boolean success, int segment, int workerId) {
            this.success = success;
            this.segment = segment;
            this.workerId = workerId;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public int getSegment() {
            return this.segment;
        }

        public int getWorkerId() {
            return this.workerId;
        }
    }

    public static class WorkerContext
    implements Serializable {
        private final int segment;
        private final int workerId;

        public WorkerContext(int segment, int workerId) {
            this.segment = segment;
            this.workerId = workerId;
        }

        public int getSegment() {
            return this.segment;
        }

        public int getWorkerId() {
            return this.workerId;
        }
    }

    public static class LoaderContext
    implements Serializable {
        private final int segmentsCount;

        public LoaderContext(int segmentsCount) {
            this.segmentsCount = segmentsCount;
        }

        public int getSegmentsCount() {
            return this.segmentsCount;
        }
    }
}

