/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.UUID;
import java.util.function.Supplier;
import org.infinispan.commons.api.BasicCache;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.CodeToTokenStoreProvider;
import org.keycloak.models.CodeToTokenStoreProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.sessions.infinispan.InfinispanCodeToTokenStoreProvider;
import org.keycloak.models.sessions.infinispan.InfinispanSingleUseTokenStoreProviderFactory;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;

public class InfinispanCodeToTokenStoreProviderFactory
implements CodeToTokenStoreProviderFactory {
    private static final Logger LOG = Logger.getLogger(InfinispanCodeToTokenStoreProviderFactory.class);
    private volatile Supplier<BasicCache<UUID, ActionTokenValueEntity>> codeCache;

    public CodeToTokenStoreProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new InfinispanCodeToTokenStoreProvider(session, this.codeCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.codeCache == null) {
            InfinispanCodeToTokenStoreProviderFactory infinispanCodeToTokenStoreProviderFactory = this;
            synchronized (infinispanCodeToTokenStoreProviderFactory) {
                if (this.codeCache == null) {
                    this.codeCache = InfinispanSingleUseTokenStoreProviderFactory.getActionTokenCache(session);
                }
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }

    public int order() {
        return 1;
    }
}

