/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.cluster.ClusterEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class WrapperClusterEvent
implements ClusterEvent {
    private String eventKey;
    private String sender;
    private String senderSite;
    private boolean ignoreSender;
    private boolean ignoreSenderSite;
    private ClusterEvent delegateEvent;

    public String getEventKey() {
        return this.eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getSenderSite() {
        return this.senderSite;
    }

    public void setSenderSite(String senderSite) {
        this.senderSite = senderSite;
    }

    public boolean isIgnoreSender() {
        return this.ignoreSender;
    }

    public void setIgnoreSender(boolean ignoreSender) {
        this.ignoreSender = ignoreSender;
    }

    public boolean isIgnoreSenderSite() {
        return this.ignoreSenderSite;
    }

    public void setIgnoreSenderSite(boolean ignoreSenderSite) {
        this.ignoreSenderSite = ignoreSenderSite;
    }

    public ClusterEvent getDelegateEvent() {
        return this.delegateEvent;
    }

    public void setDelegateEvent(ClusterEvent delegateEvent) {
        this.delegateEvent = delegateEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WrapperClusterEvent that = (WrapperClusterEvent)o;
        return this.ignoreSender == that.ignoreSender && this.ignoreSenderSite == that.ignoreSenderSite && Objects.equals(this.eventKey, that.eventKey) && Objects.equals(this.sender, that.sender) && Objects.equals(this.senderSite, that.senderSite) && Objects.equals(this.delegateEvent, that.delegateEvent);
    }

    public int hashCode() {
        return Objects.hash(this.eventKey, this.sender, this.senderSite, this.ignoreSender, this.ignoreSenderSite, this.delegateEvent);
    }

    public String toString() {
        return String.format("WrapperClusterEvent [ eventKey=%s, sender=%s, senderSite=%s, delegateEvent=%s ]", this.eventKey, this.sender, this.senderSite, this.delegateEvent.toString());
    }

    public static class ExternalizerImpl
    implements Externalizer<WrapperClusterEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, WrapperClusterEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.eventKey, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.sender, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.senderSite, (ObjectOutput)output);
            output.writeBoolean(obj.ignoreSender);
            output.writeBoolean(obj.ignoreSenderSite);
            output.writeObject(obj.delegateEvent);
        }

        public WrapperClusterEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public WrapperClusterEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            WrapperClusterEvent res = new WrapperClusterEvent();
            res.eventKey = MarshallUtil.unmarshallString((ObjectInput)input);
            res.sender = MarshallUtil.unmarshallString((ObjectInput)input);
            res.senderSite = MarshallUtil.unmarshallString((ObjectInput)input);
            res.ignoreSender = input.readBoolean();
            res.ignoreSenderSite = input.readBoolean();
            res.delegateEvent = (ClusterEvent)input.readObject();
            return res;
        }
    }
}

