/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.UUID;
import java.util.function.Supplier;
import org.infinispan.commons.api.BasicCache;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.PushedAuthzRequestStoreProvider;
import org.keycloak.models.PushedAuthzRequestStoreProviderFactory;
import org.keycloak.models.sessions.infinispan.InfinispanPushedAuthzRequestStoreProvider;
import org.keycloak.models.sessions.infinispan.InfinispanSingleUseTokenStoreProviderFactory;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class InfinispanPushedAuthzRequestStoreProviderFactory
implements PushedAuthzRequestStoreProviderFactory,
EnvironmentDependentProviderFactory {
    private volatile Supplier<BasicCache<UUID, ActionTokenValueEntity>> codeCache;

    public PushedAuthzRequestStoreProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new InfinispanPushedAuthzRequestStoreProvider(session, this.codeCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.codeCache == null) {
            InfinispanPushedAuthzRequestStoreProviderFactory infinispanPushedAuthzRequestStoreProviderFactory = this;
            synchronized (infinispanPushedAuthzRequestStoreProviderFactory) {
                if (this.codeCache == null) {
                    this.codeCache = InfinispanSingleUseTokenStoreProviderFactory.getActionTokenCache(session);
                }
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PAR);
    }
}

