/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.authorization.infinispan;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.authorization.infinispan.CachedPolicyStore;
import org.keycloak.models.authorization.infinispan.CachedResourceServerStore;
import org.keycloak.models.authorization.infinispan.CachedResourceStore;
import org.keycloak.models.authorization.infinispan.CachedScopeStore;
import org.keycloak.models.cache.authorization.CachedStoreFactoryProvider;

public class InfinispanStoreFactoryProvider
implements CachedStoreFactoryProvider {
    private final KeycloakSession session;
    private final CacheTransaction transaction;

    InfinispanStoreFactoryProvider(KeycloakSession delegate) {
        this.session = delegate;
        this.transaction = new CacheTransaction();
        this.session.getTransaction().enlistAfterCompletion((KeycloakTransaction)this.transaction);
    }

    public ResourceStore getResourceStore() {
        return new CachedResourceStore(this.session, this.transaction);
    }

    public ResourceServerStore getResourceServerStore() {
        return new CachedResourceServerStore(this.session, this.transaction);
    }

    public ScopeStore getScopeStore() {
        return new CachedScopeStore(this.session, this.transaction);
    }

    public PolicyStore getPolicyStore() {
        return new CachedPolicyStore(this.session, this.transaction);
    }

    public void close() {
    }

    static class CacheTransaction
    implements KeycloakTransaction {
        private List<Runnable> completeTasks = new ArrayList<Runnable>();

        CacheTransaction() {
        }

        public void begin() {
        }

        public void commit() {
            this.completeTasks.forEach(task -> task.run());
        }

        public void rollback() {
            this.completeTasks.forEach(task -> task.run());
        }

        public void setRollbackOnly() {
        }

        public boolean getRollbackOnly() {
            return false;
        }

        public boolean isActive() {
            return false;
        }

        protected void whenComplete(Runnable task) {
            this.completeTasks.add(task);
        }
    }
}

