/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.authorization.infinispan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.authorization.infinispan.InfinispanStoreFactoryProvider;
import org.keycloak.models.authorization.infinispan.entities.CachedResourceServer;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;

public class CachedResourceServerStore
implements ResourceServerStore {
    private static final String RS_ID_CACHE_PREFIX = "rs-id-";
    private final KeycloakSession session;
    private final InfinispanStoreFactoryProvider.CacheTransaction transaction;
    private StoreFactory storeFactory;
    private ResourceServerStore delegate;
    private final Cache<String, List> cache;

    public CachedResourceServerStore(KeycloakSession session, InfinispanStoreFactoryProvider.CacheTransaction transaction) {
        this.session = session;
        this.transaction = transaction;
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        this.cache = provider.getCache("authorization");
    }

    public ResourceServer create(String clientId) {
        ResourceServer resourceServer = this.getDelegate().create(clientId);
        this.transaction.whenRollback(() -> {
            List cfr_ignored_0 = (List)this.cache.remove((Object)this.getCacheKeyForResourceServer(resourceServer.getId()));
        });
        return this.createAdapter(new CachedResourceServer(resourceServer));
    }

    public void delete(String id) {
        this.getDelegate().delete(id);
        this.transaction.whenCommit(() -> {
            List cfr_ignored_0 = (List)this.cache.remove((Object)this.getCacheKeyForResourceServer(id));
        });
    }

    public ResourceServer findById(String id) {
        String cacheKeyForResourceServer = this.getCacheKeyForResourceServer(id);
        List cached = (List)this.cache.get((Object)cacheKeyForResourceServer);
        if (cached == null) {
            ResourceServer resourceServer = this.getDelegate().findById(id);
            if (resourceServer != null) {
                return this.createAdapter(this.updateResourceServerCache(resourceServer));
            }
            return null;
        }
        return this.createAdapter((ResourceServer)cached.get(0));
    }

    public ResourceServer findByClient(String id) {
        for (Map.Entry entry : this.cache.entrySet()) {
            List cache;
            ResourceServer resourceServer;
            String cacheKey = (String)entry.getKey();
            if (!cacheKey.startsWith(RS_ID_CACHE_PREFIX) || !(resourceServer = (ResourceServer)(cache = (List)entry.getValue()).get(0)).getClientId().equals(id)) continue;
            return this.findById(resourceServer.getId());
        }
        ResourceServer resourceServer = this.getDelegate().findByClient(id);
        if (resourceServer != null) {
            return this.findById(this.updateResourceServerCache(resourceServer).getId());
        }
        return null;
    }

    private String getCacheKeyForResourceServer(String id) {
        return RS_ID_CACHE_PREFIX + id;
    }

    private ResourceServerStore getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.getStoreFactory().getResourceServerStore();
        }
        return this.delegate;
    }

    private StoreFactory getStoreFactory() {
        if (this.storeFactory == null) {
            this.storeFactory = (StoreFactory)this.session.getProvider(StoreFactory.class);
        }
        return this.storeFactory;
    }

    private ResourceServer createAdapter(final ResourceServer cached) {
        return new ResourceServer(){
            private ResourceServer updated;

            public String getId() {
                return cached.getId();
            }

            public String getClientId() {
                return cached.getClientId();
            }

            public boolean isAllowRemoteResourceManagement() {
                return cached.isAllowRemoteResourceManagement();
            }

            public void setAllowRemoteResourceManagement(boolean allowRemoteResourceManagement) {
                this.getDelegateForUpdate().setAllowRemoteResourceManagement(allowRemoteResourceManagement);
                cached.setAllowRemoteResourceManagement(allowRemoteResourceManagement);
            }

            public PolicyEnforcementMode getPolicyEnforcementMode() {
                return cached.getPolicyEnforcementMode();
            }

            public void setPolicyEnforcementMode(PolicyEnforcementMode enforcementMode) {
                this.getDelegateForUpdate().setPolicyEnforcementMode(enforcementMode);
                cached.setPolicyEnforcementMode(enforcementMode);
            }

            private ResourceServer getDelegateForUpdate() {
                if (this.updated == null) {
                    this.updated = CachedResourceServerStore.this.getDelegate().findById(this.getId());
                    if (this.updated == null) {
                        throw new IllegalStateException("Not found in database");
                    }
                    CachedResourceServerStore.this.transaction.whenCommit(() -> {
                        List cfr_ignored_0 = (List)CachedResourceServerStore.this.cache.remove((Object)CachedResourceServerStore.this.getCacheKeyForResourceServer(this.getId()));
                    });
                }
                return this.updated;
            }
        };
    }

    private CachedResourceServer updateResourceServerCache(ResourceServer resourceServer) {
        CachedResourceServer cached = new CachedResourceServer(resourceServer);
        ArrayList<CachedResourceServer> cache = new ArrayList<CachedResourceServer>();
        cache.add(cached);
        this.cache.put((Object)this.getCacheKeyForResourceServer(resourceServer.getId()), cache);
        return cached;
    }
}

