/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.authorization.infinispan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.authorization.infinispan.InfinispanStoreFactoryProvider;
import org.keycloak.models.authorization.infinispan.entities.CachedResource;

public class CachedResourceStore
implements ResourceStore {
    private static final String RESOURCE_ID_CACHE_PREFIX = "rsc-id-";
    private static final String RESOURCE_OWNER_CACHE_PREFIX = "rsc-owner-";
    private final KeycloakSession session;
    private final InfinispanStoreFactoryProvider.CacheTransaction transaction;
    private StoreFactory storeFactory;
    private ResourceStore delegate;
    private final Cache<String, List> cache;

    public CachedResourceStore(KeycloakSession session, InfinispanStoreFactoryProvider.CacheTransaction transaction) {
        this.session = session;
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        this.cache = provider.getCache("authorization");
        this.transaction = transaction;
    }

    public Resource create(String name, ResourceServer resourceServer, String owner) {
        Resource resource = this.getDelegate().create(name, this.getStoreFactory().getResourceServerStore().findById(resourceServer.getId()), owner);
        this.transaction.whenRollback(() -> {
            List cfr_ignored_0 = (List)this.cache.remove((Object)this.getCacheKeyForResource(resource.getId()));
        });
        return this.createAdapter(new CachedResource(resource));
    }

    public void delete(String id) {
        CachedResource cachedResource;
        List byOwner;
        List removed = (List)this.cache.remove((Object)this.getCacheKeyForResource(id));
        if (removed != null && (byOwner = (List)this.cache.get((Object)this.getResourceOwnerCacheKey((cachedResource = (CachedResource)removed.get(0)).getOwner()))) != null) {
            byOwner.remove(id);
            if (byOwner.isEmpty()) {
                this.cache.remove((Object)this.getResourceOwnerCacheKey(cachedResource.getOwner()));
            }
        }
        this.getDelegate().delete(id);
    }

    public Resource findById(String id) {
        String cacheKeyForResource = this.getCacheKeyForResource(id);
        List cached = (List)this.cache.get((Object)cacheKeyForResource);
        if (cached == null) {
            Resource resource = this.getDelegate().findById(id);
            if (resource != null) {
                this.updateCachedIds(this.getResourceOwnerCacheKey(resource.getOwner()), resource, false);
                return this.createAdapter(this.updateResourceCache(resource));
            }
            return null;
        }
        return this.createAdapter((CachedResource)cached.get(0));
    }

    public List<Resource> findByOwner(String ownerId) {
        List cachedIds = (List)this.cache.get((Object)this.getResourceOwnerCacheKey(ownerId));
        if (cachedIds == null) {
            for (Resource resource2 : this.getDelegate().findByOwner(ownerId)) {
                this.updateCachedIds(this.getResourceOwnerCacheKey(ownerId), resource2, true);
            }
            cachedIds = (List)this.cache.getOrDefault((Object)this.getResourceOwnerCacheKey(ownerId), Collections.emptyList());
        }
        return ((List)this.cache.getOrDefault((Object)this.getResourceOwnerCacheKey(ownerId), Collections.emptyList())).stream().map(this::findById).filter(resource -> resource != null).collect(Collectors.toList());
    }

    public List<Resource> findByResourceServer(String resourceServerId) {
        return this.getDelegate().findByResourceServer(resourceServerId).stream().map(resource -> this.findById(resource.getId())).collect(Collectors.toList());
    }

    public List<Resource> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        return this.getDelegate().findByResourceServer(attributes, resourceServerId, firstResult, maxResult);
    }

    public List<Resource> findByScope(String ... id) {
        return this.getDelegate().findByScope(id).stream().map(resource -> this.findById(resource.getId())).collect(Collectors.toList());
    }

    public Resource findByName(String name, String resourceServerId) {
        for (Map.Entry entry : this.cache.entrySet()) {
            List value;
            CachedResource resource;
            String cacheKey = (String)entry.getKey();
            if (!cacheKey.startsWith(RESOURCE_ID_CACHE_PREFIX) || !(resource = (CachedResource)(value = (List)entry.getValue()).get(0)).getResourceServerId().equals(resourceServerId) || !resource.getName().equals(name)) continue;
            return this.findById(resource.getId());
        }
        Resource resource = this.getDelegate().findByName(name, resourceServerId);
        if (resource != null) {
            return this.findById(this.updateResourceCache(resource).getId());
        }
        return null;
    }

    public List<Resource> findByType(String type) {
        return this.getDelegate().findByType(type).stream().map(resource -> this.findById(resource.getId())).collect(Collectors.toList());
    }

    private String getCacheKeyForResource(String id) {
        return RESOURCE_ID_CACHE_PREFIX + id;
    }

    private ResourceStore getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.getStoreFactory().getResourceStore();
        }
        return this.delegate;
    }

    private StoreFactory getStoreFactory() {
        if (this.storeFactory == null) {
            this.storeFactory = (StoreFactory)this.session.getProvider(StoreFactory.class);
        }
        return this.storeFactory;
    }

    private Resource createAdapter(final CachedResource cached) {
        return new Resource(){
            private List<Scope> scopes;
            private Resource updated;

            public String getId() {
                return cached.getId();
            }

            public String getName() {
                return cached.getName();
            }

            public void setName(String name) {
                this.getDelegateForUpdate().setName(name);
                cached.setName(name);
            }

            public String getUri() {
                return cached.getUri();
            }

            public void setUri(String uri) {
                this.getDelegateForUpdate().setUri(uri);
                cached.setUri(uri);
            }

            public String getType() {
                return cached.getType();
            }

            public void setType(String type) {
                this.getDelegateForUpdate().setType(type);
                cached.setType(type);
            }

            public List<Scope> getScopes() {
                ArrayList<Scope> scopes = new ArrayList<Scope>();
                for (String id : cached.getScopesIds()) {
                    Scope cached2 = CachedResourceStore.this.getStoreFactory().getScopeStore().findById(id);
                    if (cached2 == null) continue;
                    scopes.add(cached2);
                }
                return scopes;
            }

            public String getIconUri() {
                return cached.getIconUri();
            }

            public void setIconUri(String iconUri) {
                this.getDelegateForUpdate().setIconUri(iconUri);
                cached.setIconUri(iconUri);
            }

            public ResourceServer getResourceServer() {
                return CachedResourceStore.this.getStoreFactory().getResourceServerStore().findById(cached.getResourceServerId());
            }

            public String getOwner() {
                return cached.getOwner();
            }

            public void updateScopes(Set<Scope> scopes) {
                this.getDelegateForUpdate().updateScopes(scopes.stream().map(scope -> CachedResourceStore.this.getStoreFactory().getScopeStore().findById(scope.getId())).collect(Collectors.toSet()));
                cached.updateScopes(scopes);
            }

            private Resource getDelegateForUpdate() {
                if (this.updated == null) {
                    this.updated = CachedResourceStore.this.getDelegate().findById(this.getId());
                    if (this.updated == null) {
                        throw new IllegalStateException("Not found in database");
                    }
                    CachedResourceStore.this.transaction.whenCommit(() -> {
                        List cfr_ignored_0 = (List)CachedResourceStore.this.cache.remove((Object)CachedResourceStore.this.getCacheKeyForResource(this.getId()));
                    });
                }
                return this.updated;
            }
        };
    }

    private CachedResource updateResourceCache(Resource resource) {
        CachedResource cached = new CachedResource(resource);
        ArrayList<CachedResource> cache = new ArrayList<CachedResource>();
        cache.add(cached);
        this.cache.put((Object)this.getCacheKeyForResource(resource.getId()), cache);
        return cached;
    }

    private void updateCachedIds(String cacheKey, Resource resource, boolean create) {
        ArrayList<String> cached = (ArrayList<String>)this.cache.get((Object)cacheKey);
        if (cached == null) {
            if (!create) {
                return;
            }
            cached = new ArrayList<String>();
            this.cache.put((Object)cacheKey, cached);
        }
        if (cached != null && !cached.contains(resource.getId())) {
            cached.add(resource.getId());
        }
    }

    private String getResourceOwnerCacheKey(String ownerId) {
        return RESOURCE_OWNER_CACHE_PREFIX + ownerId;
    }
}

