/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.InRealm;

public class CachedGroup
extends AbstractRevisioned
implements InRealm {
    private String realm;
    private String name;
    private String parentId;
    private MultivaluedHashMap<String, String> attributes = new MultivaluedHashMap();
    private Set<String> roleMappings = new HashSet<String>();
    private Set<String> subGroups = new HashSet<String>();

    public CachedGroup(Long revision, RealmModel realm, GroupModel group) {
        super(revision, group.getId());
        this.realm = realm.getId();
        this.name = group.getName();
        this.parentId = group.getParentId();
        this.attributes.putAll(group.getAttributes());
        for (RoleModel role : group.getRoleMappings()) {
            this.roleMappings.add(role.getId());
        }
        Set subGroups1 = group.getSubGroups();
        if (subGroups1 != null) {
            for (GroupModel subGroup : subGroups1) {
                this.subGroups.add(subGroup.getId());
            }
        }
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public MultivaluedHashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public Set<String> getRoleMappings() {
        return this.roleMappings;
    }

    public String getName() {
        return this.name;
    }

    public String getParentId() {
        return this.parentId;
    }

    public Set<String> getSubGroups() {
        return this.subGroups;
    }
}

