/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.InClient;
import org.keycloak.models.cache.infinispan.entities.RoleQuery;

public class RoleListQuery
extends AbstractRevisioned
implements RoleQuery,
InClient {
    private final Set<String> roles;
    private final String realm;
    private final String realmName;
    private String client;

    public RoleListQuery(Long revisioned, String id, RealmModel realm, Set<String> roles) {
        super(revisioned, id);
        this.realm = realm.getId();
        this.realmName = realm.getName();
        this.roles = roles;
    }

    public RoleListQuery(Long revisioned, String id, RealmModel realm, String role) {
        super(revisioned, id);
        this.realm = realm.getId();
        this.realmName = realm.getName();
        this.roles = new HashSet<String>();
        this.roles.add(role);
    }

    public RoleListQuery(Long revision, String id, RealmModel realm, Set<String> roles, String client) {
        this(revision, id, realm, roles);
        this.client = client;
    }

    public RoleListQuery(Long revision, String id, RealmModel realm, String role, String client) {
        this(revision, id, realm, role);
        this.client = client;
    }

    @Override
    public Set<String> getRoles() {
        return this.roles;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    @Override
    public String getClientId() {
        return this.client;
    }

    public String toString() {
        return "RoleListQuery{id='" + this.getId() + "'realmName='" + this.realmName + '\'' + '}';
    }
}

