/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.remoting.transport.Transport;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ExecutionResult;
import org.keycloak.cluster.infinispan.InfinispanClusterProviderFactory;
import org.keycloak.cluster.infinispan.LockEntry;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;

public class InfinispanClusterProvider
implements ClusterProvider {
    protected static final Logger logger = Logger.getLogger(InfinispanClusterProvider.class);
    public static final String CLUSTER_STARTUP_TIME_KEY = "cluster-start-time";
    private static final String TASK_KEY_PREFIX = "task::";
    private final InfinispanClusterProviderFactory factory;
    private final KeycloakSession session;
    private final Cache<String, Serializable> cache;

    public InfinispanClusterProvider(InfinispanClusterProviderFactory factory, KeycloakSession session, Cache<String, Serializable> cache) {
        this.factory = factory;
        this.session = session;
        this.cache = cache;
    }

    public int getClusterStartupTime() {
        Integer existingClusterStartTime = (Integer)this.cache.get((Object)CLUSTER_STARTUP_TIME_KEY);
        if (existingClusterStartTime != null) {
            return existingClusterStartTime;
        }
        int serverStartTime = (int)(this.session.getKeycloakSessionFactory().getServerStartupTimestamp() / 1000L);
        existingClusterStartTime = (Integer)this.cache.putIfAbsent((Object)CLUSTER_STARTUP_TIME_KEY, (Object)serverStartTime);
        if (existingClusterStartTime == null) {
            logger.debugf("Initialized cluster startup time to %s", (Object)Time.toDate((int)serverStartTime).toString());
            return serverStartTime;
        }
        return existingClusterStartTime;
    }

    public void close() {
    }

    public <T> ExecutionResult<T> executeIfNotExecuted(String taskKey, int taskTimeoutInSeconds, Callable<T> task) {
        String cacheKey = TASK_KEY_PREFIX + taskKey;
        boolean locked = this.tryLock(cacheKey, taskTimeoutInSeconds);
        if (locked) {
            try {
                T result = task.call();
                ExecutionResult executionResult = ExecutionResult.executed(result);
                return executionResult;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected exception when executed task " + taskKey, e);
            }
            finally {
                this.removeFromCache(cacheKey);
            }
        }
        return ExecutionResult.notExecuted();
    }

    public void registerListener(String taskKey, ClusterListener task) {
        this.factory.registerListener(taskKey, task);
    }

    public void notify(String taskKey, ClusterEvent event) {
        this.cache.put((Object)taskKey, (Object)event);
    }

    private String getCurrentNode(Cache<String, Serializable> cache) {
        Transport transport = cache.getCacheManager().getTransport();
        return transport == null ? "local" : transport.getAddress().toString();
    }

    private LockEntry createLockEntry(Cache<String, Serializable> cache) {
        LockEntry lock = new LockEntry();
        lock.setNode(this.getCurrentNode(cache));
        lock.setTimestamp(Time.currentTime());
        return lock;
    }

    private boolean tryLock(String cacheKey, int taskTimeoutInSeconds) {
        LockEntry myLock = this.createLockEntry(this.cache);
        LockEntry existingLock = (LockEntry)this.cache.putIfAbsent((Object)cacheKey, (Object)myLock);
        if (existingLock != null) {
            int currentTime;
            int thatTime = existingLock.getTimestamp();
            if (thatTime + taskTimeoutInSeconds < (currentTime = Time.currentTime())) {
                boolean replaced;
                if (logger.isTraceEnabled()) {
                    logger.tracef("Task %s outdated when in progress by node %s. Will try to replace task with our node %s", (Object)cacheKey, (Object)existingLock.getNode(), (Object)myLock.getNode());
                }
                if (!(replaced = this.cache.replace((Object)cacheKey, (Object)existingLock, (Object)myLock)) && logger.isTraceEnabled()) {
                    logger.tracef("Failed to replace the task %s. Other thread replaced in the meantime. Ignoring task.", (Object)cacheKey);
                }
                return replaced;
            }
            if (logger.isTraceEnabled()) {
                logger.tracef("Task %s in progress already by node %s. Ignoring task.", (Object)cacheKey, (Object)existingLock.getNode());
            }
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.tracef("Successfully acquired lock for task %s. Our node is %s", (Object)cacheKey, (Object)myLock.getNode());
        }
        return true;
    }

    private void removeFromCache(String cacheKey) {
        int retry = 3;
        while (true) {
            try {
                this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.FORCE_SYNCHRONOUS}).remove((Object)cacheKey);
                if (logger.isTraceEnabled()) {
                    logger.tracef("Task %s removed from the cache", (Object)cacheKey);
                }
                return;
            }
            catch (RuntimeException e) {
                ComponentStatus status = this.cache.getStatus();
                if (!status.isStopping() && !status.isTerminated()) continue;
                logger.warnf("Failed to remove task %s from the cache. Cache is already terminating", (Object)cacheKey);
                logger.debug((Object)e.getMessage(), (Throwable)e);
                return;
                if (--retry != 0) continue;
                throw e;
            }
            break;
        }
    }
}

