/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.cache.UserCacheProviderFactory;
import org.keycloak.models.cache.infinispan.UserCacheManager;
import org.keycloak.models.cache.infinispan.UserCacheSession;

public class InfinispanUserCacheProviderFactory
implements UserCacheProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanUserCacheProviderFactory.class);
    protected volatile UserCacheManager userCache;

    public UserCache create(KeycloakSession session) {
        this.lazyInit(session);
        return new UserCacheSession(this.userCache, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.userCache == null) {
            InfinispanUserCacheProviderFactory infinispanUserCacheProviderFactory = this;
            synchronized (infinispanUserCacheProviderFactory) {
                if (this.userCache == null) {
                    Cache cache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("users");
                    Cache revisions = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("userRevisions");
                    this.userCache = new UserCacheManager(cache, revisions);
                }
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }
}

