/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.AuthenticatorConfigModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientTemplateModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.OTPPolicy;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserFederationMapperModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.cache.infinispan.RealmCache;
import org.keycloak.models.cache.infinispan.RealmCacheSession;
import org.keycloak.models.cache.infinispan.entities.CachedRealm;
import org.keycloak.models.utils.KeycloakModelUtils;

public class RealmAdapter
implements RealmModel {
    protected CachedRealm cached;
    protected RealmCacheSession cacheSession;
    protected RealmModel updated;
    protected RealmCache cache;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    protected volatile transient Key codeSecretKey;
    protected volatile transient X509Certificate certificate;
    protected boolean invalidated;

    public RealmAdapter(CachedRealm cached, RealmCacheSession cacheSession) {
        this.cached = cached;
        this.cacheSession = cacheSession;
    }

    protected void getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerRealmInvalidation(this.cached.getId());
            this.updated = this.cacheSession.getDelegate().getRealm(this.cached.getId());
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
    }

    public void invalidate() {
        this.invalidated = true;
    }

    protected boolean isUpdated() {
        if (this.updated != null) {
            return true;
        }
        if (!this.invalidated) {
            return false;
        }
        this.updated = this.cacheSession.getDelegate().getRealm(this.cached.getId());
        if (this.updated == null) {
            throw new IllegalStateException("Not found in database");
        }
        return true;
    }

    public String getId() {
        if (this.isUpdated()) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public String getName() {
        if (this.isUpdated()) {
            return this.updated.getName();
        }
        return this.cached.getName();
    }

    public void setName(String name) {
        this.getDelegateForUpdate();
        this.updated.setName(name);
    }

    public String getDisplayName() {
        if (this.isUpdated()) {
            return this.updated.getDisplayName();
        }
        return this.cached.getDisplayName();
    }

    public void setDisplayName(String displayName) {
        this.getDelegateForUpdate();
        this.updated.setDisplayName(displayName);
    }

    public String getDisplayNameHtml() {
        if (this.isUpdated()) {
            return this.updated.getDisplayNameHtml();
        }
        return this.cached.getDisplayNameHtml();
    }

    public void setDisplayNameHtml(String displayNameHtml) {
        this.getDelegateForUpdate();
        this.updated.setDisplayNameHtml(displayNameHtml);
    }

    public boolean isEnabled() {
        if (this.isUpdated()) {
            return this.updated.isEnabled();
        }
        return this.cached.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setEnabled(enabled);
    }

    public SslRequired getSslRequired() {
        if (this.isUpdated()) {
            return this.updated.getSslRequired();
        }
        return this.cached.getSslRequired();
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.getDelegateForUpdate();
        this.updated.setSslRequired(sslRequired);
    }

    public boolean isRegistrationAllowed() {
        if (this.isUpdated()) {
            return this.updated.isRegistrationAllowed();
        }
        return this.cached.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.getDelegateForUpdate();
        this.updated.setRegistrationAllowed(registrationAllowed);
    }

    public boolean isRegistrationEmailAsUsername() {
        if (this.isUpdated()) {
            return this.updated.isRegistrationEmailAsUsername();
        }
        return this.cached.isRegistrationEmailAsUsername();
    }

    public void setRegistrationEmailAsUsername(boolean registrationEmailAsUsername) {
        this.getDelegateForUpdate();
        this.updated.setRegistrationEmailAsUsername(registrationEmailAsUsername);
    }

    public boolean isRememberMe() {
        if (this.isUpdated()) {
            return this.updated.isRememberMe();
        }
        return this.cached.isRememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.getDelegateForUpdate();
        this.updated.setRememberMe(rememberMe);
    }

    public boolean isBruteForceProtected() {
        if (this.isUpdated()) {
            return this.updated.isBruteForceProtected();
        }
        return this.cached.isBruteForceProtected();
    }

    public void setBruteForceProtected(boolean value) {
        this.getDelegateForUpdate();
        this.updated.setBruteForceProtected(value);
    }

    public int getMaxFailureWaitSeconds() {
        if (this.isUpdated()) {
            return this.updated.getMaxFailureWaitSeconds();
        }
        return this.cached.getMaxFailureWaitSeconds();
    }

    public void setMaxFailureWaitSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setMaxFailureWaitSeconds(val);
    }

    public int getWaitIncrementSeconds() {
        if (this.isUpdated()) {
            return this.updated.getWaitIncrementSeconds();
        }
        return this.cached.getWaitIncrementSeconds();
    }

    public void setWaitIncrementSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setWaitIncrementSeconds(val);
    }

    public int getMinimumQuickLoginWaitSeconds() {
        if (this.isUpdated()) {
            return this.updated.getMinimumQuickLoginWaitSeconds();
        }
        return this.cached.getMinimumQuickLoginWaitSeconds();
    }

    public void setMinimumQuickLoginWaitSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setMinimumQuickLoginWaitSeconds(val);
    }

    public long getQuickLoginCheckMilliSeconds() {
        if (this.isUpdated()) {
            return this.updated.getQuickLoginCheckMilliSeconds();
        }
        return this.cached.getQuickLoginCheckMilliSeconds();
    }

    public void setQuickLoginCheckMilliSeconds(long val) {
        this.getDelegateForUpdate();
        this.updated.setQuickLoginCheckMilliSeconds(val);
    }

    public int getMaxDeltaTimeSeconds() {
        if (this.isUpdated()) {
            return this.updated.getMaxDeltaTimeSeconds();
        }
        return this.cached.getMaxDeltaTimeSeconds();
    }

    public void setMaxDeltaTimeSeconds(int val) {
        this.getDelegateForUpdate();
        this.updated.setMaxDeltaTimeSeconds(val);
    }

    public int getFailureFactor() {
        if (this.isUpdated()) {
            return this.updated.getFailureFactor();
        }
        return this.cached.getFailureFactor();
    }

    public void setFailureFactor(int failureFactor) {
        this.getDelegateForUpdate();
        this.updated.setFailureFactor(failureFactor);
    }

    public boolean isVerifyEmail() {
        if (this.isUpdated()) {
            return this.updated.isVerifyEmail();
        }
        return this.cached.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.getDelegateForUpdate();
        this.updated.setVerifyEmail(verifyEmail);
    }

    public boolean isResetPasswordAllowed() {
        if (this.isUpdated()) {
            return this.updated.isResetPasswordAllowed();
        }
        return this.cached.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        this.getDelegateForUpdate();
        this.updated.setResetPasswordAllowed(resetPasswordAllowed);
    }

    public boolean isEditUsernameAllowed() {
        if (this.isUpdated()) {
            return this.updated.isEditUsernameAllowed();
        }
        return this.cached.isEditUsernameAllowed();
    }

    public void setEditUsernameAllowed(boolean editUsernameAllowed) {
        this.getDelegateForUpdate();
        this.updated.setEditUsernameAllowed(editUsernameAllowed);
    }

    public boolean isRevokeRefreshToken() {
        if (this.isUpdated()) {
            return this.updated.isRevokeRefreshToken();
        }
        return this.cached.isRevokeRefreshToken();
    }

    public void setRevokeRefreshToken(boolean revokeRefreshToken) {
        this.getDelegateForUpdate();
        this.updated.setRevokeRefreshToken(revokeRefreshToken);
    }

    public int getSsoSessionIdleTimeout() {
        if (this.isUpdated()) {
            return this.updated.getSsoSessionIdleTimeout();
        }
        return this.cached.getSsoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setSsoSessionIdleTimeout(seconds);
    }

    public int getSsoSessionMaxLifespan() {
        if (this.isUpdated()) {
            return this.updated.getSsoSessionMaxLifespan();
        }
        return this.cached.getSsoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setSsoSessionMaxLifespan(seconds);
    }

    public int getOfflineSessionIdleTimeout() {
        if (this.isUpdated()) {
            return this.updated.getOfflineSessionIdleTimeout();
        }
        return this.cached.getOfflineSessionIdleTimeout();
    }

    public void setOfflineSessionIdleTimeout(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setOfflineSessionIdleTimeout(seconds);
    }

    public int getAccessTokenLifespan() {
        if (this.isUpdated()) {
            return this.updated.getAccessTokenLifespan();
        }
        return this.cached.getAccessTokenLifespan();
    }

    public void setAccessTokenLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessTokenLifespan(seconds);
    }

    public int getAccessTokenLifespanForImplicitFlow() {
        if (this.isUpdated()) {
            return this.updated.getAccessTokenLifespanForImplicitFlow();
        }
        return this.cached.getAccessTokenLifespanForImplicitFlow();
    }

    public void setAccessTokenLifespanForImplicitFlow(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessTokenLifespanForImplicitFlow(seconds);
    }

    public int getAccessCodeLifespan() {
        if (this.isUpdated()) {
            return this.updated.getAccessCodeLifespan();
        }
        return this.cached.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessCodeLifespan(seconds);
    }

    public int getAccessCodeLifespanUserAction() {
        if (this.isUpdated()) {
            return this.updated.getAccessCodeLifespanUserAction();
        }
        return this.cached.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessCodeLifespanUserAction(seconds);
    }

    public int getAccessCodeLifespanLogin() {
        if (this.isUpdated()) {
            return this.updated.getAccessCodeLifespanLogin();
        }
        return this.cached.getAccessCodeLifespanLogin();
    }

    public void setAccessCodeLifespanLogin(int seconds) {
        this.getDelegateForUpdate();
        this.updated.setAccessCodeLifespanLogin(seconds);
    }

    public String getKeyId() {
        if (this.isUpdated()) {
            return this.updated.getKeyId();
        }
        return this.cached.getKeyId();
    }

    public String getPublicKeyPem() {
        if (this.isUpdated()) {
            return this.updated.getPublicKeyPem();
        }
        return this.cached.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.getDelegateForUpdate();
        this.updated.setPublicKeyPem(publicKeyPem);
    }

    public String getPrivateKeyPem() {
        if (this.isUpdated()) {
            return this.updated.getPrivateKeyPem();
        }
        return this.cached.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.getDelegateForUpdate();
        this.updated.setPrivateKeyPem(privateKeyPem);
    }

    public PublicKey getPublicKey() {
        if (this.isUpdated()) {
            return this.updated.getPublicKey();
        }
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = this.cached.getPublicKey();
        if (this.publicKey != null) {
            return this.publicKey;
        }
        this.publicKey = KeycloakModelUtils.getPublicKey((String)this.getPublicKeyPem());
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        String publicKeyPem = KeycloakModelUtils.getPemFromKey((Key)publicKey);
        this.setPublicKeyPem(publicKeyPem);
    }

    public X509Certificate getCertificate() {
        if (this.isUpdated()) {
            return this.updated.getCertificate();
        }
        if (this.certificate != null) {
            return this.certificate;
        }
        this.certificate = this.cached.getCertificate();
        if (this.certificate != null) {
            return this.certificate;
        }
        this.certificate = KeycloakModelUtils.getCertificate((String)this.getCertificatePem());
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
        String certPem = KeycloakModelUtils.getPemFromCertificate((X509Certificate)certificate);
        this.setCertificatePem(certPem);
    }

    public String getCertificatePem() {
        if (this.isUpdated()) {
            return this.updated.getCertificatePem();
        }
        return this.cached.getCertificatePem();
    }

    public void setCertificatePem(String certificate) {
        this.getDelegateForUpdate();
        this.updated.setCertificatePem(certificate);
    }

    public PrivateKey getPrivateKey() {
        if (this.isUpdated()) {
            return this.updated.getPrivateKey();
        }
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = this.cached.getPrivateKey();
        if (this.privateKey != null) {
            return this.privateKey;
        }
        this.privateKey = KeycloakModelUtils.getPrivateKey((String)this.getPrivateKeyPem());
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        String privateKeyPem = KeycloakModelUtils.getPemFromKey((Key)privateKey);
        this.setPrivateKeyPem(privateKeyPem);
    }

    public String getCodeSecret() {
        return this.isUpdated() ? this.updated.getCodeSecret() : this.cached.getCodeSecret();
    }

    public Key getCodeSecretKey() {
        if (this.codeSecretKey == null) {
            this.codeSecretKey = KeycloakModelUtils.getSecretKey((String)this.getCodeSecret());
        }
        return this.codeSecretKey;
    }

    public void setCodeSecret(String codeSecret) {
        this.getDelegateForUpdate();
        this.updated.setCodeSecret(codeSecret);
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        if (this.isUpdated()) {
            return this.updated.getRequiredCredentials();
        }
        return this.cached.getRequiredCredentials();
    }

    public void addRequiredCredential(String cred) {
        this.getDelegateForUpdate();
        this.updated.addRequiredCredential(cred);
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.isUpdated()) {
            return this.updated.getPasswordPolicy();
        }
        return this.cached.getPasswordPolicy();
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.getDelegateForUpdate();
        this.updated.setPasswordPolicy(policy);
    }

    public OTPPolicy getOTPPolicy() {
        if (this.isUpdated()) {
            return this.updated.getOTPPolicy();
        }
        return this.cached.getOtpPolicy();
    }

    public void setOTPPolicy(OTPPolicy policy) {
        this.getDelegateForUpdate();
        this.updated.setOTPPolicy(policy);
    }

    public RoleModel getRoleById(String id) {
        if (this.isUpdated()) {
            return this.updated.getRoleById(id);
        }
        return this.cacheSession.getRoleById(id, this);
    }

    public List<GroupModel> getDefaultGroups() {
        if (this.isUpdated()) {
            return this.updated.getDefaultGroups();
        }
        LinkedList<GroupModel> defaultGroups = new LinkedList<GroupModel>();
        for (String id : this.cached.getDefaultGroups()) {
            defaultGroups.add(this.cacheSession.getGroupById(id, this));
        }
        return Collections.unmodifiableList(defaultGroups);
    }

    public void addDefaultGroup(GroupModel group) {
        this.getDelegateForUpdate();
        this.updated.addDefaultGroup(group);
    }

    public void removeDefaultGroup(GroupModel group) {
        this.getDelegateForUpdate();
        this.updated.removeDefaultGroup(group);
    }

    public List<String> getDefaultRoles() {
        if (this.isUpdated()) {
            return this.updated.getDefaultRoles();
        }
        return this.cached.getDefaultRoles();
    }

    public void addDefaultRole(String name) {
        this.getDelegateForUpdate();
        this.updated.addDefaultRole(name);
    }

    public void updateDefaultRoles(String ... defaultRoles) {
        this.getDelegateForUpdate();
        this.updated.updateDefaultRoles(defaultRoles);
    }

    public void removeDefaultRoles(String ... defaultRoles) {
        this.getDelegateForUpdate();
        this.updated.removeDefaultRoles(defaultRoles);
    }

    public List<ClientModel> getClients() {
        return this.cacheSession.getClients(this);
    }

    public ClientModel addClient(String name) {
        return this.cacheSession.addClient(this, name);
    }

    public ClientModel addClient(String id, String clientId) {
        return this.cacheSession.addClient(this, id, clientId);
    }

    public boolean removeClient(String id) {
        return this.cacheSession.removeClient(id, this);
    }

    public ClientModel getClientById(String id) {
        if (this.isUpdated()) {
            return this.updated.getClientById(id);
        }
        return this.cacheSession.getClientById(id, this);
    }

    public ClientModel getClientByClientId(String clientId) {
        return this.cacheSession.getClientByClientId(clientId, this);
    }

    public void updateRequiredCredentials(Set<String> creds) {
        this.getDelegateForUpdate();
        this.updated.updateRequiredCredentials(creds);
    }

    public Map<String, String> getBrowserSecurityHeaders() {
        if (this.isUpdated()) {
            return this.updated.getBrowserSecurityHeaders();
        }
        return this.cached.getBrowserSecurityHeaders();
    }

    public void setBrowserSecurityHeaders(Map<String, String> headers) {
        this.getDelegateForUpdate();
        this.updated.setBrowserSecurityHeaders(headers);
    }

    public Map<String, String> getSmtpConfig() {
        if (this.isUpdated()) {
            return this.updated.getSmtpConfig();
        }
        return this.cached.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.getDelegateForUpdate();
        this.updated.setSmtpConfig(smtpConfig);
    }

    public List<IdentityProviderModel> getIdentityProviders() {
        if (this.isUpdated()) {
            return this.updated.getIdentityProviders();
        }
        return this.cached.getIdentityProviders();
    }

    public IdentityProviderModel getIdentityProviderByAlias(String alias) {
        if (this.isUpdated()) {
            return this.updated.getIdentityProviderByAlias(alias);
        }
        for (IdentityProviderModel identityProviderModel : this.getIdentityProviders()) {
            if (!identityProviderModel.getAlias().equals(alias)) continue;
            return identityProviderModel;
        }
        return null;
    }

    public void addIdentityProvider(IdentityProviderModel identityProvider) {
        this.getDelegateForUpdate();
        this.updated.addIdentityProvider(identityProvider);
    }

    public void updateIdentityProvider(IdentityProviderModel identityProvider) {
        this.getDelegateForUpdate();
        this.updated.updateIdentityProvider(identityProvider);
    }

    public void removeIdentityProviderByAlias(String alias) {
        this.getDelegateForUpdate();
        this.updated.removeIdentityProviderByAlias(alias);
    }

    public List<UserFederationProviderModel> getUserFederationProviders() {
        if (this.isUpdated()) {
            return this.updated.getUserFederationProviders();
        }
        return this.cached.getUserFederationProviders();
    }

    public void setUserFederationProviders(List<UserFederationProviderModel> providers) {
        this.getDelegateForUpdate();
        this.updated.setUserFederationProviders(providers);
    }

    public UserFederationProviderModel addUserFederationProvider(String providerName, Map<String, String> config, int priority, String displayName, int fullSyncPeriod, int changedSyncPeriod, int lastSync) {
        this.getDelegateForUpdate();
        return this.updated.addUserFederationProvider(providerName, config, priority, displayName, fullSyncPeriod, changedSyncPeriod, lastSync);
    }

    public void removeUserFederationProvider(UserFederationProviderModel provider) {
        this.getDelegateForUpdate();
        this.updated.removeUserFederationProvider(provider);
    }

    public void updateUserFederationProvider(UserFederationProviderModel provider) {
        this.getDelegateForUpdate();
        this.updated.updateUserFederationProvider(provider);
    }

    public String getLoginTheme() {
        if (this.isUpdated()) {
            return this.updated.getLoginTheme();
        }
        return this.cached.getLoginTheme();
    }

    public void setLoginTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setLoginTheme(name);
    }

    public String getAccountTheme() {
        if (this.isUpdated()) {
            return this.updated.getAccountTheme();
        }
        return this.cached.getAccountTheme();
    }

    public void setAccountTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setAccountTheme(name);
    }

    public String getAdminTheme() {
        if (this.isUpdated()) {
            return this.updated.getAdminTheme();
        }
        return this.cached.getAdminTheme();
    }

    public void setAdminTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setAdminTheme(name);
    }

    public String getEmailTheme() {
        if (this.isUpdated()) {
            return this.updated.getEmailTheme();
        }
        return this.cached.getEmailTheme();
    }

    public void setEmailTheme(String name) {
        this.getDelegateForUpdate();
        this.updated.setEmailTheme(name);
    }

    public int getNotBefore() {
        if (this.isUpdated()) {
            return this.updated.getNotBefore();
        }
        return this.cached.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.getDelegateForUpdate();
        this.updated.setNotBefore(notBefore);
    }

    public boolean removeRoleById(String id) {
        this.cacheSession.registerRoleInvalidation(id);
        this.getDelegateForUpdate();
        return this.updated.removeRoleById(id);
    }

    public boolean isEventsEnabled() {
        if (this.isUpdated()) {
            return this.updated.isEventsEnabled();
        }
        return this.cached.isEventsEnabled();
    }

    public void setEventsEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setEventsEnabled(enabled);
    }

    public long getEventsExpiration() {
        if (this.isUpdated()) {
            return this.updated.getEventsExpiration();
        }
        return this.cached.getEventsExpiration();
    }

    public void setEventsExpiration(long expiration) {
        this.getDelegateForUpdate();
        this.updated.setEventsExpiration(expiration);
    }

    public Set<String> getEventsListeners() {
        if (this.isUpdated()) {
            return this.updated.getEventsListeners();
        }
        return this.cached.getEventsListeners();
    }

    public void setEventsListeners(Set<String> listeners) {
        this.getDelegateForUpdate();
        this.updated.setEventsListeners(listeners);
    }

    public Set<String> getEnabledEventTypes() {
        if (this.isUpdated()) {
            return this.updated.getEnabledEventTypes();
        }
        return this.cached.getEnabledEventTypes();
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        this.getDelegateForUpdate();
        this.updated.setEnabledEventTypes(enabledEventTypes);
    }

    public boolean isAdminEventsEnabled() {
        if (this.isUpdated()) {
            return this.updated.isAdminEventsEnabled();
        }
        return this.cached.isAdminEventsEnabled();
    }

    public void setAdminEventsEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setAdminEventsEnabled(enabled);
    }

    public boolean isAdminEventsDetailsEnabled() {
        if (this.isUpdated()) {
            return this.updated.isAdminEventsDetailsEnabled();
        }
        return this.cached.isAdminEventsDetailsEnabled();
    }

    public void setAdminEventsDetailsEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setAdminEventsDetailsEnabled(enabled);
    }

    public ClientModel getMasterAdminClient() {
        return this.cached.getMasterAdminClient() == null ? null : this.cacheSession.getRealm(Config.getAdminRealm()).getClientById(this.cached.getMasterAdminClient());
    }

    public void setMasterAdminClient(ClientModel client) {
        this.getDelegateForUpdate();
        this.updated.setMasterAdminClient(client);
    }

    public RoleModel getRole(String name) {
        for (RoleModel role : this.getRoles()) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public Set<RoleModel> getRoles() {
        return this.cacheSession.getRealmRoles(this);
    }

    public RoleModel addRole(String name) {
        this.getDelegateForUpdate();
        RoleModel role = this.updated.addRole(name);
        this.cacheSession.registerRoleInvalidation(role.getId());
        return role;
    }

    public RoleModel addRole(String id, String name) {
        this.getDelegateForUpdate();
        RoleModel role = this.updated.addRole(id, name);
        this.cacheSession.registerRoleInvalidation(role.getId());
        return role;
    }

    public boolean removeRole(RoleModel role) {
        return this.cacheSession.removeRole(this, role);
    }

    public boolean isIdentityFederationEnabled() {
        if (this.isUpdated()) {
            return this.updated.isIdentityFederationEnabled();
        }
        return this.cached.isIdentityFederationEnabled();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof RealmModel)) {
            return false;
        }
        RealmModel that = (RealmModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean isInternationalizationEnabled() {
        if (this.isUpdated()) {
            return this.updated.isInternationalizationEnabled();
        }
        return this.cached.isInternationalizationEnabled();
    }

    public void setInternationalizationEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setInternationalizationEnabled(enabled);
    }

    public Set<String> getSupportedLocales() {
        if (this.isUpdated()) {
            return this.updated.getSupportedLocales();
        }
        return this.cached.getSupportedLocales();
    }

    public void setSupportedLocales(Set<String> locales) {
        this.getDelegateForUpdate();
        this.updated.setSupportedLocales(locales);
    }

    public String getDefaultLocale() {
        if (this.isUpdated()) {
            return this.updated.getDefaultLocale();
        }
        return this.cached.getDefaultLocale();
    }

    public void setDefaultLocale(String locale) {
        this.updated.setDefaultLocale(locale);
    }

    public Set<IdentityProviderMapperModel> getIdentityProviderMappers() {
        if (this.isUpdated()) {
            return this.updated.getIdentityProviderMappers();
        }
        return this.cached.getIdentityProviderMapperSet();
    }

    public Set<IdentityProviderMapperModel> getIdentityProviderMappersByAlias(String brokerAlias) {
        if (this.isUpdated()) {
            return this.updated.getIdentityProviderMappersByAlias(brokerAlias);
        }
        HashSet<IdentityProviderMapperModel> mappings = new HashSet<IdentityProviderMapperModel>();
        List list = this.cached.getIdentityProviderMappers().getList((Object)brokerAlias);
        for (IdentityProviderMapperModel entity : list) {
            mappings.add(entity);
        }
        return Collections.unmodifiableSet(mappings);
    }

    public IdentityProviderMapperModel addIdentityProviderMapper(IdentityProviderMapperModel model) {
        this.getDelegateForUpdate();
        return this.updated.addIdentityProviderMapper(model);
    }

    public void removeIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        this.getDelegateForUpdate();
        this.updated.removeIdentityProviderMapper(mapping);
    }

    public void updateIdentityProviderMapper(IdentityProviderMapperModel mapping) {
        this.getDelegateForUpdate();
        this.updated.updateIdentityProviderMapper(mapping);
    }

    public IdentityProviderMapperModel getIdentityProviderMapperById(String id) {
        if (this.isUpdated()) {
            return this.updated.getIdentityProviderMapperById(id);
        }
        for (List models : this.cached.getIdentityProviderMappers().values()) {
            for (IdentityProviderMapperModel model : models) {
                if (!model.getId().equals(id)) continue;
                return model;
            }
        }
        return null;
    }

    public IdentityProviderMapperModel getIdentityProviderMapperByName(String alias, String name) {
        if (this.isUpdated()) {
            return this.updated.getIdentityProviderMapperByName(alias, name);
        }
        List models = this.cached.getIdentityProviderMappers().getList((Object)alias);
        if (models == null) {
            return null;
        }
        for (IdentityProviderMapperModel model : models) {
            if (!model.getName().equals(name)) continue;
            return model;
        }
        return null;
    }

    public Set<UserFederationMapperModel> getUserFederationMappers() {
        if (this.isUpdated()) {
            return this.updated.getUserFederationMappers();
        }
        return this.cached.getUserFederationMapperSet();
    }

    public Set<UserFederationMapperModel> getUserFederationMappersByFederationProvider(String federationProviderId) {
        if (this.isUpdated()) {
            return this.updated.getUserFederationMappersByFederationProvider(federationProviderId);
        }
        HashSet<UserFederationMapperModel> mappers = new HashSet<UserFederationMapperModel>();
        List list = this.cached.getUserFederationMappers().getList((Object)federationProviderId);
        for (UserFederationMapperModel entity : list) {
            mappers.add(entity);
        }
        return Collections.unmodifiableSet(mappers);
    }

    public UserFederationMapperModel addUserFederationMapper(UserFederationMapperModel mapper) {
        this.getDelegateForUpdate();
        return this.updated.addUserFederationMapper(mapper);
    }

    public void removeUserFederationMapper(UserFederationMapperModel mapper) {
        this.getDelegateForUpdate();
        this.updated.removeUserFederationMapper(mapper);
    }

    public void updateUserFederationMapper(UserFederationMapperModel mapper) {
        this.getDelegateForUpdate();
        this.updated.updateUserFederationMapper(mapper);
    }

    public UserFederationMapperModel getUserFederationMapperById(String id) {
        if (this.isUpdated()) {
            return this.updated.getUserFederationMapperById(id);
        }
        for (List models : this.cached.getUserFederationMappers().values()) {
            for (UserFederationMapperModel model : models) {
                if (!model.getId().equals(id)) continue;
                return model;
            }
        }
        return null;
    }

    public UserFederationMapperModel getUserFederationMapperByName(String federationProviderId, String name) {
        if (this.isUpdated()) {
            return this.updated.getUserFederationMapperByName(federationProviderId, name);
        }
        List models = this.cached.getUserFederationMappers().getList((Object)federationProviderId);
        if (models == null) {
            return null;
        }
        for (UserFederationMapperModel model : models) {
            if (!model.getName().equals(name)) continue;
            return model;
        }
        return null;
    }

    public AuthenticationFlowModel getBrowserFlow() {
        if (this.isUpdated()) {
            return this.updated.getBrowserFlow();
        }
        return this.cached.getBrowserFlow();
    }

    public void setBrowserFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setBrowserFlow(flow);
    }

    public AuthenticationFlowModel getRegistrationFlow() {
        if (this.isUpdated()) {
            return this.updated.getRegistrationFlow();
        }
        return this.cached.getRegistrationFlow();
    }

    public void setRegistrationFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setRegistrationFlow(flow);
    }

    public AuthenticationFlowModel getDirectGrantFlow() {
        if (this.isUpdated()) {
            return this.updated.getDirectGrantFlow();
        }
        return this.cached.getDirectGrantFlow();
    }

    public void setDirectGrantFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setDirectGrantFlow(flow);
    }

    public AuthenticationFlowModel getResetCredentialsFlow() {
        if (this.isUpdated()) {
            return this.updated.getResetCredentialsFlow();
        }
        return this.cached.getResetCredentialsFlow();
    }

    public void setResetCredentialsFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setResetCredentialsFlow(flow);
    }

    public AuthenticationFlowModel getClientAuthenticationFlow() {
        if (this.isUpdated()) {
            return this.updated.getClientAuthenticationFlow();
        }
        return this.cached.getClientAuthenticationFlow();
    }

    public void setClientAuthenticationFlow(AuthenticationFlowModel flow) {
        this.getDelegateForUpdate();
        this.updated.setClientAuthenticationFlow(flow);
    }

    public List<AuthenticationFlowModel> getAuthenticationFlows() {
        if (this.isUpdated()) {
            return this.updated.getAuthenticationFlows();
        }
        return this.cached.getAuthenticationFlowList();
    }

    public AuthenticationFlowModel getFlowByAlias(String alias) {
        for (AuthenticationFlowModel flow : this.getAuthenticationFlows()) {
            if (!flow.getAlias().equals(alias)) continue;
            return flow;
        }
        return null;
    }

    public AuthenticatorConfigModel getAuthenticatorConfigByAlias(String alias) {
        for (AuthenticatorConfigModel config : this.getAuthenticatorConfigs()) {
            if (!config.getAlias().equals(alias)) continue;
            return config;
        }
        return null;
    }

    public AuthenticationFlowModel addAuthenticationFlow(AuthenticationFlowModel model) {
        this.getDelegateForUpdate();
        return this.updated.addAuthenticationFlow(model);
    }

    public AuthenticationFlowModel getAuthenticationFlowById(String id) {
        if (this.isUpdated()) {
            return this.updated.getAuthenticationFlowById(id);
        }
        return this.cached.getAuthenticationFlows().get(id);
    }

    public void removeAuthenticationFlow(AuthenticationFlowModel model) {
        this.getDelegateForUpdate();
        this.updated.removeAuthenticationFlow(model);
    }

    public void updateAuthenticationFlow(AuthenticationFlowModel model) {
        this.getDelegateForUpdate();
        this.updated.updateAuthenticationFlow(model);
    }

    public List<AuthenticationExecutionModel> getAuthenticationExecutions(String flowId) {
        if (this.isUpdated()) {
            return this.updated.getAuthenticationExecutions(flowId);
        }
        return (List)this.cached.getAuthenticationExecutions().get((Object)flowId);
    }

    public AuthenticationExecutionModel getAuthenticationExecutionById(String id) {
        if (this.isUpdated()) {
            return this.updated.getAuthenticationExecutionById(id);
        }
        return this.cached.getExecutionsById().get(id);
    }

    public AuthenticationExecutionModel addAuthenticatorExecution(AuthenticationExecutionModel model) {
        this.getDelegateForUpdate();
        return this.updated.addAuthenticatorExecution(model);
    }

    public void updateAuthenticatorExecution(AuthenticationExecutionModel model) {
        this.getDelegateForUpdate();
        this.updated.updateAuthenticatorExecution(model);
    }

    public void removeAuthenticatorExecution(AuthenticationExecutionModel model) {
        this.getDelegateForUpdate();
        this.updated.removeAuthenticatorExecution(model);
    }

    public List<AuthenticatorConfigModel> getAuthenticatorConfigs() {
        if (this.isUpdated()) {
            return this.updated.getAuthenticatorConfigs();
        }
        ArrayList<AuthenticatorConfigModel> models = new ArrayList<AuthenticatorConfigModel>();
        models.addAll(this.cached.getAuthenticatorConfigs().values());
        return Collections.unmodifiableList(models);
    }

    public AuthenticatorConfigModel addAuthenticatorConfig(AuthenticatorConfigModel model) {
        this.getDelegateForUpdate();
        return this.updated.addAuthenticatorConfig(model);
    }

    public void updateAuthenticatorConfig(AuthenticatorConfigModel model) {
        this.getDelegateForUpdate();
        this.updated.updateAuthenticatorConfig(model);
    }

    public void removeAuthenticatorConfig(AuthenticatorConfigModel model) {
        this.getDelegateForUpdate();
        this.updated.removeAuthenticatorConfig(model);
    }

    public AuthenticatorConfigModel getAuthenticatorConfigById(String id) {
        if (this.isUpdated()) {
            return this.updated.getAuthenticatorConfigById(id);
        }
        return this.cached.getAuthenticatorConfigs().get(id);
    }

    public List<RequiredActionProviderModel> getRequiredActionProviders() {
        if (this.isUpdated()) {
            return this.updated.getRequiredActionProviders();
        }
        return this.cached.getRequiredActionProviderList();
    }

    public RequiredActionProviderModel addRequiredActionProvider(RequiredActionProviderModel model) {
        this.getDelegateForUpdate();
        return this.updated.addRequiredActionProvider(model);
    }

    public void updateRequiredActionProvider(RequiredActionProviderModel model) {
        this.getDelegateForUpdate();
        this.updated.updateRequiredActionProvider(model);
    }

    public void removeRequiredActionProvider(RequiredActionProviderModel model) {
        this.getDelegateForUpdate();
        this.updated.removeRequiredActionProvider(model);
    }

    public RequiredActionProviderModel getRequiredActionProviderById(String id) {
        if (this.isUpdated()) {
            return this.updated.getRequiredActionProviderById(id);
        }
        return this.cached.getRequiredActionProviders().get(id);
    }

    public RequiredActionProviderModel getRequiredActionProviderByAlias(String alias) {
        if (this.isUpdated()) {
            return this.updated.getRequiredActionProviderByAlias(alias);
        }
        return this.cached.getRequiredActionProvidersByAlias().get(alias);
    }

    public GroupModel createGroup(String name) {
        return this.cacheSession.createGroup(this, name);
    }

    public GroupModel createGroup(String id, String name) {
        return this.cacheSession.createGroup(this, id, name);
    }

    public void addTopLevelGroup(GroupModel subGroup) {
        this.cacheSession.addTopLevelGroup(this, subGroup);
    }

    public void moveGroup(GroupModel group, GroupModel toParent) {
        this.cacheSession.moveGroup(this, group, toParent);
    }

    public GroupModel getGroupById(String id) {
        return this.cacheSession.getGroupById(id, this);
    }

    public List<GroupModel> getGroups() {
        return this.cacheSession.getGroups(this);
    }

    public List<GroupModel> getTopLevelGroups() {
        return this.cacheSession.getTopLevelGroups(this);
    }

    public boolean removeGroup(GroupModel group) {
        return this.cacheSession.removeGroup(this, group);
    }

    public List<ClientTemplateModel> getClientTemplates() {
        if (this.isUpdated()) {
            return this.updated.getClientTemplates();
        }
        List<String> clientTemplates = this.cached.getClientTemplates();
        if (clientTemplates.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<ClientTemplateModel> apps = new LinkedList<ClientTemplateModel>();
        for (String id : clientTemplates) {
            ClientTemplateModel model = this.cacheSession.getClientTemplateById(id, this);
            if (model == null) {
                throw new IllegalStateException("Cached clientemplate not found: " + id);
            }
            apps.add(model);
        }
        return Collections.unmodifiableList(apps);
    }

    public ClientTemplateModel addClientTemplate(String name) {
        this.getDelegateForUpdate();
        ClientTemplateModel app = this.updated.addClientTemplate(name);
        this.cacheSession.registerClientTemplateInvalidation(app.getId());
        return app;
    }

    public ClientTemplateModel addClientTemplate(String id, String name) {
        this.getDelegateForUpdate();
        ClientTemplateModel app = this.updated.addClientTemplate(id, name);
        this.cacheSession.registerClientTemplateInvalidation(app.getId());
        return app;
    }

    public boolean removeClientTemplate(String id) {
        this.cacheSession.registerClientTemplateInvalidation(id);
        this.getDelegateForUpdate();
        return this.updated.removeClientTemplate(id);
    }

    public ClientTemplateModel getClientTemplateById(String id) {
        if (this.isUpdated()) {
            return this.updated.getClientTemplateById(id);
        }
        return this.cacheSession.getClientTemplateById(id, this);
    }

    public ComponentModel addComponentModel(ComponentModel model) {
        this.getDelegateForUpdate();
        return this.updated.addComponentModel(model);
    }

    public void updateComponent(ComponentModel component) {
        this.getDelegateForUpdate();
        this.updated.updateComponent(component);
    }

    public void removeComponent(ComponentModel component) {
        this.getDelegateForUpdate();
        this.updated.removeComponent(component);
    }

    public void removeComponents(String parentId) {
        this.getDelegateForUpdate();
        this.updated.removeComponents(parentId);
    }

    public List<ComponentModel> getComponents(String parentId, String providerType) {
        if (this.isUpdated()) {
            return this.updated.getComponents(parentId, providerType);
        }
        List components = this.cached.getComponentsByParentAndType().getList((Object)(parentId + providerType));
        if (components == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(components);
    }

    public List<ComponentModel> getComponents(String parentId) {
        if (this.isUpdated()) {
            return this.updated.getComponents(parentId);
        }
        List components = this.cached.getComponentsByParent().getList((Object)parentId);
        if (components == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(components);
    }

    public List<ComponentModel> getComponents() {
        if (this.isUpdated()) {
            return this.updated.getComponents();
        }
        LinkedList<ComponentModel> results = new LinkedList<ComponentModel>();
        results.addAll(this.cached.getComponents().values());
        return Collections.unmodifiableList(results);
    }

    public ComponentModel getComponent(String id) {
        if (this.isUpdated()) {
            return this.updated.getComponent(id);
        }
        return this.cached.getComponents().get(id);
    }

    public void setAttribute(String name, String value) {
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, value);
    }

    public void setAttribute(String name, Boolean value) {
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, value);
    }

    public void setAttribute(String name, Integer value) {
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, value);
    }

    public void setAttribute(String name, Long value) {
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.getDelegateForUpdate();
        this.updated.removeAttribute(name);
    }

    public String getAttribute(String name) {
        if (this.isUpdated()) {
            return this.updated.getAttribute(name);
        }
        return this.cached.getAttribute(name);
    }

    public Integer getAttribute(String name, Integer defaultValue) {
        if (this.isUpdated()) {
            return this.updated.getAttribute(name, defaultValue);
        }
        return this.cached.getAttribute(name, defaultValue);
    }

    public Long getAttribute(String name, Long defaultValue) {
        if (this.isUpdated()) {
            return this.updated.getAttribute(name, defaultValue);
        }
        return this.cached.getAttribute(name, defaultValue);
    }

    public Boolean getAttribute(String name, Boolean defaultValue) {
        if (this.isUpdated()) {
            return this.updated.getAttribute(name, defaultValue);
        }
        return this.cached.getAttribute(name, defaultValue);
    }

    public Map<String, String> getAttributes() {
        if (this.isUpdated()) {
            return this.updated.getAttributes();
        }
        return this.cached.getAttributes();
    }
}

