/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import org.infinispan.Cache;
import org.keycloak.models.ClientRegistrationTrustedHostModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.entities.ClientRegistrationTrustedHostEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class ClientRegistrationTrustedHostAdapter
implements ClientRegistrationTrustedHostModel {
    private final KeycloakSession session;
    private final InfinispanUserSessionProvider provider;
    private final Cache<String, SessionEntity> cache;
    private final RealmModel realm;
    private final ClientRegistrationTrustedHostEntity entity;

    public ClientRegistrationTrustedHostAdapter(KeycloakSession session, InfinispanUserSessionProvider provider, Cache<String, SessionEntity> cache, RealmModel realm, ClientRegistrationTrustedHostEntity entity) {
        this.session = session;
        this.provider = provider;
        this.cache = cache;
        this.realm = realm;
        this.entity = entity;
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getHostName() {
        return this.entity.getHostName();
    }

    public int getCount() {
        return this.entity.getCount();
    }

    public void setCount(int count) {
        this.entity.setCount(count);
        this.update();
    }

    public int getRemainingCount() {
        return this.entity.getRemainingCount();
    }

    public void setRemainingCount(int remainingCount) {
        this.entity.setRemainingCount(remainingCount);
        this.update();
    }

    public void decreaseRemainingCount() {
        this.entity.setRemainingCount(this.entity.getRemainingCount() - 1);
        this.update();
    }

    void update() {
        this.provider.getTx().replace(this.cache, this.entity.getId(), this.entity);
    }
}

