/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientRegistrationTrustedHostModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.ClientInitialAccessAdapter;
import org.keycloak.models.sessions.infinispan.ClientRegistrationTrustedHostAdapter;
import org.keycloak.models.sessions.infinispan.ClientSessionAdapter;
import org.keycloak.models.sessions.infinispan.UserLoginFailureAdapter;
import org.keycloak.models.sessions.infinispan.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.UserSessionTimestamp;
import org.keycloak.models.sessions.infinispan.entities.ClientInitialAccessEntity;
import org.keycloak.models.sessions.infinispan.entities.ClientRegistrationTrustedHostEntity;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.stream.ClientInitialAccessPredicate;
import org.keycloak.models.sessions.infinispan.stream.ClientRegistrationTrustedHostPredicate;
import org.keycloak.models.sessions.infinispan.stream.ClientSessionPredicate;
import org.keycloak.models.sessions.infinispan.stream.Comparators;
import org.keycloak.models.sessions.infinispan.stream.Mappers;
import org.keycloak.models.sessions.infinispan.stream.SessionPredicate;
import org.keycloak.models.sessions.infinispan.stream.UserLoginFailurePredicate;
import org.keycloak.models.sessions.infinispan.stream.UserSessionPredicate;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RealmInfoUtil;

public class InfinispanUserSessionProvider
implements UserSessionProvider {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProvider.class);
    protected final KeycloakSession session;
    protected final Cache<String, SessionEntity> sessionCache;
    protected final Cache<String, SessionEntity> offlineSessionCache;
    protected final Cache<LoginFailureKey, LoginFailureEntity> loginFailureCache;
    protected final InfinispanKeycloakTransaction tx;
    private static final String CLIENT_REG_TRUSTED_HOST_ID_PREFIX = "reg:::";

    public InfinispanUserSessionProvider(KeycloakSession session, Cache<String, SessionEntity> sessionCache, Cache<String, SessionEntity> offlineSessionCache, Cache<LoginFailureKey, LoginFailureEntity> loginFailureCache) {
        this.session = session;
        this.sessionCache = sessionCache;
        this.offlineSessionCache = offlineSessionCache;
        this.loginFailureCache = loginFailureCache;
        this.tx = new InfinispanKeycloakTransaction();
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.tx);
    }

    protected Cache<String, SessionEntity> getCache(boolean offline) {
        return offline ? this.offlineSessionCache : this.sessionCache;
    }

    public ClientSessionModel createClientSession(RealmModel realm, ClientModel client) {
        String id = KeycloakModelUtils.generateId();
        ClientSessionEntity entity = new ClientSessionEntity();
        entity.setId(id);
        entity.setRealm(realm.getId());
        entity.setTimestamp(Time.currentTime());
        entity.setClient(client.getId());
        this.tx.put(this.sessionCache, id, entity);
        ClientSessionAdapter wrap = this.wrap(realm, entity, false);
        wrap.setNote("action_key", KeycloakModelUtils.generateCodeSecret());
        return wrap;
    }

    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        String id = KeycloakModelUtils.generateId();
        UserSessionEntity entity = new UserSessionEntity();
        entity.setId(id);
        entity.setRealm(realm.getId());
        entity.setUser(user.getId());
        entity.setLoginUsername(loginUsername);
        entity.setIpAddress(ipAddress);
        entity.setAuthMethod(authMethod);
        entity.setRememberMe(rememberMe);
        entity.setBrokerSessionId(brokerSessionId);
        entity.setBrokerUserId(brokerUserId);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
        this.tx.put(this.sessionCache, id, entity);
        return this.wrap(realm, entity, false);
    }

    public ClientSessionModel getClientSession(RealmModel realm, String id) {
        return this.getClientSession(realm, id, false);
    }

    protected ClientSessionModel getClientSession(RealmModel realm, String id, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        ClientSessionEntity entity = (ClientSessionEntity)cache.get((Object)id);
        if (entity == null) {
            entity = (ClientSessionEntity)this.tx.get(cache, id);
        }
        return this.wrap(realm, entity, offline);
    }

    public ClientSessionModel getClientSession(String id) {
        ClientSessionEntity entity = (ClientSessionEntity)this.sessionCache.get((Object)id);
        if (entity == null) {
            entity = (ClientSessionEntity)this.tx.get(this.sessionCache, id);
        }
        if (entity != null) {
            RealmModel realm = this.session.realms().getRealm(entity.getRealm());
            return this.wrap(realm, entity, false);
        }
        return null;
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        return this.getUserSession(realm, id, false);
    }

    protected UserSessionAdapter getUserSession(RealmModel realm, String id, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        UserSessionEntity entity = (UserSessionEntity)cache.get((Object)id);
        if (entity == null) {
            entity = (UserSessionEntity)this.tx.get(cache, id);
        }
        return this.wrap(realm, entity, offline);
    }

    protected List<UserSessionModel> getUserSessions(RealmModel realm, Predicate<Map.Entry<String, SessionEntity>> predicate, boolean offline) {
        CacheStream cacheStream = this.getCache(offline).entrySet().stream();
        Iterator itr = cacheStream.filter(predicate).iterator();
        LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        while (itr.hasNext()) {
            UserSessionEntity e = (UserSessionEntity)((Map.Entry)itr.next()).getValue();
            sessions.add(this.wrap(realm, e, offline));
        }
        return sessions;
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, UserModel user) {
        return this.getUserSessions(realm, UserSessionPredicate.create(realm.getId()).user(user.getId()), false);
    }

    public List<UserSessionModel> getUserSessionByBrokerUserId(RealmModel realm, String brokerUserId) {
        return this.getUserSessions(realm, UserSessionPredicate.create(realm.getId()).brokerUserId(brokerUserId), false);
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        List<UserSessionModel> userSessions = this.getUserSessions(realm, UserSessionPredicate.create(realm.getId()).brokerSessionId(brokerSessionId), false);
        return userSessions.isEmpty() ? null : userSessions.get(0);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessions(realm, client, -1, -1);
    }

    public List<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client, int firstResult, int maxResults) {
        return this.getUserSessions(realm, client, firstResult, maxResults, false);
    }

    protected List<UserSessionModel> getUserSessions(final RealmModel realm, ClientModel client, int firstResult, int maxResults, final boolean offline) {
        final Cache<String, SessionEntity> cache = this.getCache(offline);
        Iterator itr = cache.entrySet().stream().filter((Predicate)ClientSessionPredicate.create(realm.getId()).client(client.getId()).requireUserSession()).map(Mappers.clientSessionToUserSessionTimestamp()).iterator();
        HashMap<String, UserSessionTimestamp> m = new HashMap<String, UserSessionTimestamp>();
        while (itr.hasNext()) {
            UserSessionTimestamp next = (UserSessionTimestamp)itr.next();
            if (m.containsKey(next.getUserSessionId()) && ((UserSessionTimestamp)m.get(next.getUserSessionId())).getClientSessionTimestamp() >= next.getClientSessionTimestamp()) continue;
            m.put(next.getUserSessionId(), next);
        }
        Stream<UserSessionTimestamp> stream = new LinkedList(m.values()).stream().sorted(Comparators.userSessionTimestamp());
        if (firstResult > 0) {
            stream = stream.skip(firstResult);
        }
        if (maxResults > 0) {
            stream = stream.limit(maxResults);
        }
        final LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        stream.forEach(new Consumer<UserSessionTimestamp>(){

            @Override
            public void accept(UserSessionTimestamp userSessionTimestamp) {
                SessionEntity entity = (SessionEntity)cache.get((Object)userSessionTimestamp.getUserSessionId());
                if (entity != null) {
                    sessions.add(InfinispanUserSessionProvider.this.wrap(realm, (UserSessionEntity)entity, offline));
                }
            }
        });
        return sessions;
    }

    public long getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, false);
    }

    protected long getUserSessionsCount(RealmModel realm, ClientModel client, boolean offline) {
        return this.getCache(offline).entrySet().stream().filter((Predicate)ClientSessionPredicate.create(realm.getId()).client(client.getId()).requireUserSession()).map(Mappers.clientSessionToUserSessionId()).distinct().count();
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        UserSessionEntity entity = this.getUserSessionEntity(session, false);
        if (entity != null) {
            this.removeUserSession(realm, entity, false);
        }
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, false);
    }

    protected void removeUserSessions(RealmModel realm, UserModel user, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Iterator itr = cache.entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).user(user.getId())).map(Mappers.sessionEntity()).iterator();
        while (itr.hasNext()) {
            UserSessionEntity userSessionEntity = (UserSessionEntity)itr.next();
            this.removeUserSession(realm, userSessionEntity, offline);
        }
    }

    public void removeExpired(RealmModel realm) {
        this.removeExpiredUserSessions(realm);
        this.removeExpiredClientSessions(realm);
        this.removeExpiredOfflineUserSessions(realm);
        this.removeExpiredOfflineClientSessions(realm);
        this.removeExpiredClientInitialAccess(realm);
    }

    private void removeExpiredUserSessions(RealmModel realm) {
        int expired = Time.currentTime() - realm.getSsoSessionMaxLifespan();
        int expiredRefresh = Time.currentTime() - realm.getSsoSessionIdleTimeout();
        Iterator itr = this.sessionCache.entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).expired(expired, expiredRefresh)).iterator();
        while (itr.hasNext()) {
            UserSessionEntity entity = (UserSessionEntity)((Map.Entry)itr.next()).getValue();
            this.tx.remove(this.sessionCache, entity.getId());
            if (entity.getClientSessions() == null) continue;
            for (String clientSessionId : entity.getClientSessions()) {
                this.tx.remove(this.sessionCache, clientSessionId);
            }
        }
    }

    private void removeExpiredClientSessions(RealmModel realm) {
        int expiredDettachedClientSession = Time.currentTime() - RealmInfoUtil.getDettachedClientSessionLifespan((RealmModel)realm);
        Iterator itr = this.sessionCache.entrySet().stream().filter((Predicate)ClientSessionPredicate.create(realm.getId()).expiredRefresh(expiredDettachedClientSession).requireNullUserSession()).iterator();
        while (itr.hasNext()) {
            this.tx.remove(this.sessionCache, ((Map.Entry)itr.next()).getKey());
        }
    }

    private void removeExpiredOfflineUserSessions(RealmModel realm) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        int expiredOffline = Time.currentTime() - realm.getOfflineSessionIdleTimeout();
        Iterator itr = this.offlineSessionCache.entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).expired(null, expiredOffline)).iterator();
        while (itr.hasNext()) {
            UserSessionEntity entity = (UserSessionEntity)((Map.Entry)itr.next()).getValue();
            this.tx.remove(this.offlineSessionCache, entity.getId());
            persister.removeUserSession(entity.getId(), true);
            for (String clientSessionId : entity.getClientSessions()) {
                this.tx.remove(this.offlineSessionCache, clientSessionId);
            }
        }
    }

    private void removeExpiredOfflineClientSessions(RealmModel realm) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        int expiredOffline = Time.currentTime() - realm.getOfflineSessionIdleTimeout();
        Iterator itr = this.offlineSessionCache.entrySet().stream().filter((Predicate)ClientSessionPredicate.create(realm.getId()).expiredRefresh(expiredOffline)).map(Mappers.sessionId()).iterator();
        while (itr.hasNext()) {
            String sessionId = (String)itr.next();
            this.tx.remove(this.offlineSessionCache, sessionId);
            persister.removeClientSession(sessionId, true);
        }
    }

    private void removeExpiredClientInitialAccess(RealmModel realm) {
        Iterator itr = this.sessionCache.entrySet().stream().filter((Predicate)ClientInitialAccessPredicate.create(realm.getId()).expired(Time.currentTime())).map(Mappers.sessionId()).iterator();
        while (itr.hasNext()) {
            this.tx.remove(this.sessionCache, itr.next());
        }
    }

    public void removeUserSessions(RealmModel realm) {
        this.removeUserSessions(realm, false);
    }

    protected void removeUserSessions(RealmModel realm, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Iterator itr = cache.entrySet().stream().filter((Predicate)SessionPredicate.create(realm.getId())).map(Mappers.sessionId()).iterator();
        while (itr.hasNext()) {
            cache.remove(itr.next());
        }
    }

    public UserLoginFailureModel getUserLoginFailure(RealmModel realm, String userId) {
        LoginFailureKey key = new LoginFailureKey(realm.getId(), userId);
        return this.wrap(key, (LoginFailureEntity)this.loginFailureCache.get((Object)key));
    }

    public UserLoginFailureModel addUserLoginFailure(RealmModel realm, String userId) {
        LoginFailureKey key = new LoginFailureKey(realm.getId(), userId);
        LoginFailureEntity entity = new LoginFailureEntity();
        entity.setRealm(realm.getId());
        entity.setUserId(userId);
        this.tx.put(this.loginFailureCache, key, entity);
        return this.wrap(key, entity);
    }

    public void removeUserLoginFailure(RealmModel realm, String userId) {
        this.tx.remove(this.loginFailureCache, new LoginFailureKey(realm.getId(), userId));
    }

    public void removeAllUserLoginFailures(RealmModel realm) {
        Iterator itr = this.loginFailureCache.entrySet().stream().filter((Predicate)UserLoginFailurePredicate.create(realm.getId())).map(Mappers.loginFailureId()).iterator();
        while (itr.hasNext()) {
            LoginFailureKey key = (LoginFailureKey)itr.next();
            this.tx.remove(this.loginFailureCache, key);
        }
    }

    public void onRealmRemoved(RealmModel realm) {
        this.removeUserSessions(realm, true);
        this.removeUserSessions(realm, false);
        this.removeAllUserLoginFailures(realm);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        this.onClientRemoved(realm, client, true);
        this.onClientRemoved(realm, client, false);
    }

    private void onClientRemoved(RealmModel realm, ClientModel client, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        Iterator itr = cache.entrySet().stream().filter((Predicate)ClientSessionPredicate.create(realm.getId()).client(client.getId())).iterator();
        while (itr.hasNext()) {
            ClientSessionEntity entity = (ClientSessionEntity)((Map.Entry)itr.next()).getValue();
            ClientSessionAdapter adapter = this.wrap(realm, entity, offline);
            adapter.setUserSession(null);
            this.tx.remove(cache, entity.getId());
        }
    }

    public void onUserRemoved(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, true);
        this.removeUserSessions(realm, user, false);
        this.loginFailureCache.remove((Object)new LoginFailureKey(realm.getId(), user.getUsername()));
        this.loginFailureCache.remove((Object)new LoginFailureKey(realm.getId(), user.getEmail()));
    }

    public void close() {
    }

    void attachSession(UserSessionAdapter userSession, ClientSessionModel clientSession) {
        UserSessionEntity entity = userSession.getEntity();
        String clientSessionId = clientSession.getId();
        if (entity.getClientSessions() == null) {
            entity.setClientSessions(new HashSet<String>());
        }
        if (!entity.getClientSessions().contains(clientSessionId)) {
            entity.getClientSessions().add(clientSessionId);
            userSession.update();
        }
    }

    public void removeClientSession(RealmModel realm, ClientSessionModel clientSession) {
        this.removeClientSession(realm, clientSession, false);
    }

    protected void removeClientSession(RealmModel realm, ClientSessionModel clientSession, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        UserSessionModel userSession = clientSession.getUserSession();
        if (userSession != null) {
            UserSessionEntity entity = ((UserSessionAdapter)userSession).getEntity();
            if (entity.getClientSessions() != null) {
                entity.getClientSessions().remove(clientSession.getId());
            }
            this.tx.replace(cache, entity.getId(), entity);
        }
        this.tx.remove(cache, clientSession.getId());
    }

    void dettachSession(UserSessionAdapter userSession, ClientSessionModel clientSession) {
        UserSessionEntity entity = userSession.getEntity();
        String clientSessionId = clientSession.getId();
        if (entity.getClientSessions() != null && entity.getClientSessions().contains(clientSessionId)) {
            entity.getClientSessions().remove(clientSessionId);
            if (entity.getClientSessions().isEmpty()) {
                entity.setClientSessions(null);
            }
            userSession.update();
        }
    }

    protected void removeUserSession(RealmModel realm, UserSessionEntity sessionEntity, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        this.tx.remove(cache, sessionEntity.getId());
        if (sessionEntity.getClientSessions() != null) {
            for (String clientSessionId : sessionEntity.getClientSessions()) {
                this.tx.remove(cache, clientSessionId);
            }
        }
    }

    InfinispanKeycloakTransaction getTx() {
        return this.tx;
    }

    UserSessionAdapter wrap(RealmModel realm, UserSessionEntity entity, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        return entity != null ? new UserSessionAdapter(this.session, this, cache, realm, entity, offline) : null;
    }

    List<UserSessionModel> wrapUserSessions(RealmModel realm, Collection<UserSessionEntity> entities, boolean offline) {
        LinkedList<UserSessionModel> models = new LinkedList<UserSessionModel>();
        for (UserSessionEntity e : entities) {
            models.add(this.wrap(realm, e, offline));
        }
        return models;
    }

    List<ClientInitialAccessModel> wrapClientInitialAccess(RealmModel realm, Collection<ClientInitialAccessEntity> entities) {
        LinkedList<ClientInitialAccessModel> models = new LinkedList<ClientInitialAccessModel>();
        for (ClientInitialAccessEntity e : entities) {
            models.add(this.wrap(realm, e));
        }
        return models;
    }

    ClientSessionAdapter wrap(RealmModel realm, ClientSessionEntity entity, boolean offline) {
        Cache<String, SessionEntity> cache = this.getCache(offline);
        return entity != null ? new ClientSessionAdapter(this.session, this, cache, realm, entity, offline) : null;
    }

    ClientInitialAccessAdapter wrap(RealmModel realm, ClientInitialAccessEntity entity) {
        Cache<String, SessionEntity> cache = this.getCache(false);
        return entity != null ? new ClientInitialAccessAdapter(this.session, this, cache, realm, entity) : null;
    }

    ClientRegistrationTrustedHostAdapter wrap(RealmModel realm, ClientRegistrationTrustedHostEntity entity) {
        Cache<String, SessionEntity> cache = this.getCache(false);
        return entity != null ? new ClientRegistrationTrustedHostAdapter(this.session, this, cache, realm, entity) : null;
    }

    UserLoginFailureModel wrap(LoginFailureKey key, LoginFailureEntity entity) {
        return entity != null ? new UserLoginFailureAdapter(this, this.loginFailureCache, key, entity) : null;
    }

    List<ClientSessionModel> wrapClientSessions(RealmModel realm, Collection<ClientSessionEntity> entities, boolean offline) {
        LinkedList<ClientSessionModel> models = new LinkedList<ClientSessionModel>();
        for (ClientSessionEntity e : entities) {
            models.add(this.wrap(realm, e, offline));
        }
        return models;
    }

    UserSessionEntity getUserSessionEntity(UserSessionModel userSession, boolean offline) {
        if (userSession instanceof UserSessionAdapter) {
            return ((UserSessionAdapter)userSession).getEntity();
        }
        Cache<String, SessionEntity> cache = this.getCache(offline);
        return cache != null ? (UserSessionEntity)cache.get((Object)userSession.getId()) : null;
    }

    public UserSessionModel createOfflineUserSession(UserSessionModel userSession) {
        UserSessionAdapter offlineUserSession = this.importUserSession(userSession, true);
        int currentTime = Time.currentTime();
        offlineUserSession.getEntity().setStarted(currentTime);
        offlineUserSession.setLastSessionRefresh(currentTime);
        return offlineUserSession;
    }

    public UserSessionModel getOfflineUserSession(RealmModel realm, String userSessionId) {
        return this.getUserSession(realm, userSessionId, true);
    }

    public void removeOfflineUserSession(RealmModel realm, UserSessionModel userSession) {
        UserSessionEntity userSessionEntity = this.getUserSessionEntity(userSession, true);
        if (userSessionEntity != null) {
            this.removeUserSession(realm, userSessionEntity, true);
        }
    }

    public ClientSessionModel createOfflineClientSession(ClientSessionModel clientSession) {
        ClientSessionAdapter offlineClientSession = this.importClientSession(clientSession, true);
        offlineClientSession.setTimestamp(Time.currentTime());
        return offlineClientSession;
    }

    public ClientSessionModel getOfflineClientSession(RealmModel realm, String clientSessionId) {
        return this.getClientSession(realm, clientSessionId, true);
    }

    public List<ClientSessionModel> getOfflineClientSessions(RealmModel realm, UserModel user) {
        Iterator itr = this.offlineSessionCache.entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).user(user.getId())).iterator();
        LinkedList<ClientSessionModel> clientSessions = new LinkedList<ClientSessionModel>();
        while (itr.hasNext()) {
            UserSessionEntity entity = (UserSessionEntity)((Map.Entry)itr.next()).getValue();
            Set<String> currClientSessions = entity.getClientSessions();
            for (String clientSessionId : currClientSessions) {
                ClientSessionEntity cls = (ClientSessionEntity)this.offlineSessionCache.get((Object)clientSessionId);
                if (cls == null) continue;
                clientSessions.add(this.wrap(realm, cls, true));
            }
        }
        return clientSessions;
    }

    public void removeOfflineClientSession(RealmModel realm, String clientSessionId) {
        ClientSessionModel clientSession = this.getOfflineClientSession(realm, clientSessionId);
        this.removeClientSession(realm, clientSession, true);
    }

    public long getOfflineSessionsCount(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, true);
    }

    public List<UserSessionModel> getOfflineUserSessions(RealmModel realm, ClientModel client, int first, int max) {
        return this.getUserSessions(realm, client, first, max, true);
    }

    public UserSessionAdapter importUserSession(UserSessionModel userSession, boolean offline) {
        UserSessionEntity entity = new UserSessionEntity();
        entity.setId(userSession.getId());
        entity.setRealm(userSession.getRealm().getId());
        entity.setAuthMethod(userSession.getAuthMethod());
        entity.setBrokerSessionId(userSession.getBrokerSessionId());
        entity.setBrokerUserId(userSession.getBrokerUserId());
        entity.setIpAddress(userSession.getIpAddress());
        entity.setLoginUsername(userSession.getLoginUsername());
        entity.setNotes(userSession.getNotes());
        entity.setRememberMe(userSession.isRememberMe());
        entity.setState(userSession.getState());
        entity.setUser(userSession.getUser().getId());
        entity.setStarted(userSession.getStarted());
        entity.setLastSessionRefresh(userSession.getLastSessionRefresh());
        Cache<String, SessionEntity> cache = this.getCache(offline);
        this.tx.put(cache, userSession.getId(), entity);
        return this.wrap(userSession.getRealm(), entity, offline);
    }

    public ClientSessionAdapter importClientSession(ClientSessionModel clientSession, boolean offline) {
        ClientSessionEntity entity = new ClientSessionEntity();
        entity.setId(clientSession.getId());
        entity.setRealm(clientSession.getRealm().getId());
        entity.setAction(clientSession.getAction());
        entity.setAuthenticatorStatus(clientSession.getExecutionStatus());
        entity.setAuthMethod(clientSession.getAuthMethod());
        if (clientSession.getAuthenticatedUser() != null) {
            entity.setAuthUserId(clientSession.getAuthenticatedUser().getId());
        }
        entity.setClient(clientSession.getClient().getId());
        entity.setNotes(clientSession.getNotes());
        entity.setProtocolMappers(clientSession.getProtocolMappers());
        entity.setRedirectUri(clientSession.getRedirectUri());
        entity.setRoles(clientSession.getRoles());
        entity.setTimestamp(clientSession.getTimestamp());
        entity.setUserSessionNotes(clientSession.getUserSessionNotes());
        Cache<String, SessionEntity> cache = this.getCache(offline);
        this.tx.put(cache, clientSession.getId(), entity);
        return this.wrap(clientSession.getRealm(), entity, offline);
    }

    public ClientInitialAccessModel createClientInitialAccessModel(RealmModel realm, int expiration, int count) {
        String id = KeycloakModelUtils.generateId();
        ClientInitialAccessEntity entity = new ClientInitialAccessEntity();
        entity.setId(id);
        entity.setRealm(realm.getId());
        entity.setTimestamp(Time.currentTime());
        entity.setExpiration(expiration);
        entity.setCount(count);
        entity.setRemainingCount(count);
        this.tx.put(this.sessionCache, id, entity);
        return this.wrap(realm, entity);
    }

    public ClientInitialAccessModel getClientInitialAccessModel(RealmModel realm, String id) {
        Cache<String, SessionEntity> cache = this.getCache(false);
        ClientInitialAccessEntity entity = (ClientInitialAccessEntity)cache.get((Object)id);
        if (entity == null) {
            entity = (ClientInitialAccessEntity)this.tx.get(cache, id);
        }
        return this.wrap(realm, entity);
    }

    public void removeClientInitialAccessModel(RealmModel realm, String id) {
        this.tx.remove(this.getCache(false), id);
    }

    public List<ClientInitialAccessModel> listClientInitialAccess(RealmModel realm) {
        Iterator itr = this.sessionCache.entrySet().stream().filter((Predicate)ClientInitialAccessPredicate.create(realm.getId())).iterator();
        LinkedList<ClientInitialAccessModel> list = new LinkedList<ClientInitialAccessModel>();
        while (itr.hasNext()) {
            list.add(this.wrap(realm, (ClientInitialAccessEntity)((Map.Entry)itr.next()).getValue()));
        }
        return list;
    }

    public ClientRegistrationTrustedHostModel createClientRegistrationTrustedHostModel(RealmModel realm, String hostName, int count) {
        if (this.getClientRegistrationTrustedHostModel(realm, hostName) != null) {
            throw new ModelDuplicateException("Client registration already exists for this realm and hostName");
        }
        String id = this.computeClientRegistrationTrustedHostEntityId(realm, hostName);
        ClientRegistrationTrustedHostEntity entity = new ClientRegistrationTrustedHostEntity();
        entity.setId(id);
        entity.setHostName(hostName);
        entity.setRealm(realm.getId());
        entity.setCount(count);
        entity.setRemainingCount(count);
        this.tx.put(this.sessionCache, id, entity);
        return this.wrap(realm, entity);
    }

    public ClientRegistrationTrustedHostModel getClientRegistrationTrustedHostModel(RealmModel realm, String hostName) {
        String id = this.computeClientRegistrationTrustedHostEntityId(realm, hostName);
        Cache<String, SessionEntity> cache = this.getCache(false);
        ClientRegistrationTrustedHostEntity entity = (ClientRegistrationTrustedHostEntity)cache.get((Object)id);
        if (entity == null) {
            entity = (ClientRegistrationTrustedHostEntity)this.tx.get(cache, id);
        }
        return this.wrap(realm, entity);
    }

    public void removeClientRegistrationTrustedHostModel(RealmModel realm, String hostName) {
        String id = this.computeClientRegistrationTrustedHostEntityId(realm, hostName);
        this.tx.remove(this.getCache(false), id);
    }

    public List<ClientRegistrationTrustedHostModel> listClientRegistrationTrustedHosts(RealmModel realm) {
        Iterator itr = this.sessionCache.entrySet().stream().filter((Predicate)ClientRegistrationTrustedHostPredicate.create(realm.getId())).iterator();
        LinkedList<ClientRegistrationTrustedHostModel> list = new LinkedList<ClientRegistrationTrustedHostModel>();
        while (itr.hasNext()) {
            list.add(this.wrap(realm, (ClientRegistrationTrustedHostEntity)((Map.Entry)itr.next()).getValue()));
        }
        return list;
    }

    private String computeClientRegistrationTrustedHostEntityId(RealmModel realm, String hostName) {
        return CLIENT_REG_TRUSTED_HOST_ID_PREFIX + realm.getId() + ":::" + hostName;
    }

    public static enum CacheOperation {
        ADD,
        REMOVE,
        REPLACE;

    }

    class InfinispanKeycloakTransaction
    implements KeycloakTransaction {
        private boolean active;
        private boolean rollback;
        private Map<Object, CacheTask> tasks = new HashMap<Object, CacheTask>();

        InfinispanKeycloakTransaction() {
        }

        public void begin() {
            this.active = true;
        }

        public void commit() {
            if (this.rollback) {
                throw new RuntimeException("Rollback only!");
            }
            for (CacheTask task : this.tasks.values()) {
                task.execute();
            }
        }

        public void rollback() {
            this.tasks.clear();
        }

        public void setRollbackOnly() {
            this.rollback = true;
        }

        public boolean getRollbackOnly() {
            return this.rollback;
        }

        public boolean isActive() {
            return this.active;
        }

        public void put(Cache cache, Object key, Object value) {
            log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.ADD, key);
            Object taskKey = this.getTaskKey(cache, key);
            if (this.tasks.containsKey(taskKey)) {
                throw new IllegalStateException("Can't add session: task in progress for session");
            }
            this.tasks.put(taskKey, new CacheTask(cache, CacheOperation.ADD, key, value));
        }

        public void replace(Cache cache, Object key, Object value) {
            log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.REPLACE, key);
            Object taskKey = this.getTaskKey(cache, key);
            CacheTask current = this.tasks.get(taskKey);
            if (current != null) {
                switch (current.operation) {
                    case ADD: 
                    case REPLACE: {
                        current.value = value;
                        return;
                    }
                    case REMOVE: {
                        return;
                    }
                }
            } else {
                this.tasks.put(taskKey, new CacheTask(cache, CacheOperation.REPLACE, key, value));
            }
        }

        public void remove(Cache cache, Object key) {
            log.tracev("Adding cache operation: {0} on {1}", (Object)CacheOperation.REMOVE, key);
            Object taskKey = this.getTaskKey(cache, key);
            this.tasks.put(taskKey, new CacheTask(cache, CacheOperation.REMOVE, key, null));
        }

        public Object get(Cache cache, Object key) {
            Object taskKey = this.getTaskKey(cache, key);
            CacheTask current = this.tasks.get(taskKey);
            if (current != null) {
                switch (current.operation) {
                    case ADD: 
                    case REPLACE: {
                        return current.value;
                    }
                }
            }
            return null;
        }

        private Object getTaskKey(Cache cache, Object key) {
            if (key instanceof String) {
                return cache.getName() + "::" + key.toString();
            }
            return key;
        }

        public class CacheTask {
            private Cache cache;
            private CacheOperation operation;
            private Object key;
            private Object value;

            public CacheTask(Cache cache, CacheOperation operation, Object key, Object value) {
                this.cache = cache;
                this.operation = operation;
                this.key = key;
                this.value = value;
            }

            public void execute() {
                log.tracev("Executing cache operation: {0} on {1}", (Object)this.operation, this.key);
                switch (this.operation) {
                    case ADD: {
                        this.cache.put(this.key, this.value);
                        break;
                    }
                    case REMOVE: {
                        this.cache.remove(this.key);
                        break;
                    }
                    case REPLACE: {
                        this.cache.replace(this.key, this.value);
                    }
                }
            }
        }
    }
}

