/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys.infinispan;

import java.security.PublicKey;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.keys.PublicKeyStorageProvider;
import org.keycloak.keys.infinispan.PublicKeysEntry;

public class InfinispanPublicKeyStorageProvider
implements PublicKeyStorageProvider {
    private static final Logger log = Logger.getLogger(InfinispanPublicKeyStorageProvider.class);
    private final Cache<String, PublicKeysEntry> keys;
    private final Map<String, FutureTask<PublicKeysEntry>> tasksInProgress;
    private final int minTimeBetweenRequests;

    public InfinispanPublicKeyStorageProvider(Cache<String, PublicKeysEntry> keys, Map<String, FutureTask<PublicKeysEntry>> tasksInProgress, int minTimeBetweenRequests) {
        this.keys = keys;
        this.tasksInProgress = tasksInProgress;
        this.minTimeBetweenRequests = minTimeBetweenRequests;
    }

    public PublicKey getPublicKey(String modelKey, String kid, PublicKeyLoader loader) {
        PublicKeysEntry entry;
        block12: {
            PublicKey publicKey;
            entry = (PublicKeysEntry)this.keys.get((Object)modelKey);
            if (entry != null && (publicKey = this.getPublicKey(entry.getCurrentKeys(), kid)) != null) {
                return publicKey;
            }
            int lastRequestTime = entry == null ? 0 : entry.getLastRequestTime();
            int currentTime = Time.currentTime();
            if (currentTime > lastRequestTime + this.minTimeBetweenRequests) {
                WrapperCallable wrapperCallable = new WrapperCallable(modelKey, loader);
                FutureTask<PublicKeysEntry> task = new FutureTask<PublicKeysEntry>(wrapperCallable);
                FutureTask<PublicKeysEntry> existing = this.tasksInProgress.putIfAbsent(modelKey, task);
                if (existing == null) {
                    task.run();
                } else {
                    task = existing;
                }
                try {
                    entry = task.get();
                    PublicKey publicKey2 = this.getPublicKey(entry.getCurrentKeys(), kid);
                    if (publicKey2 != null) {
                        PublicKey publicKey3 = publicKey2;
                        return publicKey3;
                    }
                    break block12;
                }
                catch (ExecutionException ee) {
                    throw new RuntimeException("Error when loading public keys", ee);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException("Error. Interrupted when loading public keys", ie);
                }
                finally {
                    if (existing == null) {
                        this.tasksInProgress.remove(modelKey);
                    }
                }
            }
            log.warnf("Won't load the keys for model '%s' . Last request time was %d", (Object)modelKey, (Object)lastRequestTime);
        }
        Set availableKids = entry == null ? Collections.emptySet() : entry.getCurrentKeys().keySet();
        log.warnf("PublicKey wasn't found in the storage. Requested kid: '%s' . Available kids: '%s'", (Object)kid, availableKids);
        return null;
    }

    private PublicKey getPublicKey(Map<String, PublicKey> publicKeys, String kid) {
        if (kid == null && !publicKeys.isEmpty()) {
            return publicKeys.values().iterator().next();
        }
        return publicKeys.get(kid);
    }

    public void close() {
    }

    private class WrapperCallable
    implements Callable<PublicKeysEntry> {
        private final String modelKey;
        private final PublicKeyLoader delegate;

        public WrapperCallable(String modelKey, PublicKeyLoader delegate) {
            this.modelKey = modelKey;
            this.delegate = delegate;
        }

        @Override
        public PublicKeysEntry call() throws Exception {
            PublicKeysEntry entry = (PublicKeysEntry)InfinispanPublicKeyStorageProvider.this.keys.get((Object)this.modelKey);
            int lastRequestTime = entry == null ? 0 : entry.getLastRequestTime();
            int currentTime = Time.currentTime();
            if (currentTime > lastRequestTime + InfinispanPublicKeyStorageProvider.this.minTimeBetweenRequests) {
                Map publicKeys = this.delegate.loadKeys();
                if (log.isDebugEnabled()) {
                    log.debugf("Public keys retrieved successfully for model %s. New kids: %s", (Object)this.modelKey, (Object)publicKeys.keySet().toString());
                }
                entry = new PublicKeysEntry(currentTime, publicKeys);
                InfinispanPublicKeyStorageProvider.this.keys.put((Object)this.modelKey, (Object)entry);
            }
            return entry;
        }
    }
}

