/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterEvent;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.cache.infinispan.ClearCacheEvent;
import org.keycloak.models.cache.infinispan.UserAdapter;
import org.keycloak.models.cache.infinispan.UserCacheManager;
import org.keycloak.models.cache.infinispan.entities.CachedFederatedIdentityLinks;
import org.keycloak.models.cache.infinispan.entities.CachedUser;
import org.keycloak.models.cache.infinispan.entities.CachedUserConsent;
import org.keycloak.models.cache.infinispan.entities.CachedUserConsents;
import org.keycloak.models.cache.infinispan.entities.UserListQuery;
import org.keycloak.storage.UserStorageProvider;

public class UserCacheSession
implements UserCache {
    protected static final Logger logger = Logger.getLogger(UserCacheSession.class);
    protected UserCacheManager cache;
    protected KeycloakSession session;
    protected UserProvider delegate;
    protected boolean transactionActive;
    protected boolean setRollbackOnly;
    protected final long startupRevision;
    protected Set<String> invalidations = new HashSet<String>();
    protected Set<String> realmInvalidations = new HashSet<String>();
    protected Map<String, UserModel> managedUsers = new HashMap<String, UserModel>();

    public UserCacheSession(UserCacheManager cache, KeycloakSession session) {
        this.cache = cache;
        this.session = session;
        this.startupRevision = cache.getCurrentCounter();
        session.getTransactionManager().enlistAfterCompletion(this.getTransaction());
    }

    public void clear() {
        this.cache.clear();
        ClusterProvider cluster = (ClusterProvider)this.session.getProvider(ClusterProvider.class);
        cluster.notify("USER_CLEAR_CACHE_EVENTS", (ClusterEvent)new ClearCacheEvent());
    }

    public UserProvider getDelegate() {
        if (!this.transactionActive) {
            throw new IllegalStateException("Cannot access delegate without a transaction");
        }
        if (this.delegate != null) {
            return this.delegate;
        }
        this.delegate = this.session.userStorageManager();
        return this.delegate;
    }

    public void registerUserInvalidation(RealmModel realm, CachedUser user) {
        this.invalidations.add(user.getId());
        if (user.getEmail() != null) {
            this.invalidations.add(this.getUserByEmailCacheKey(realm.getId(), user.getEmail()));
        }
        this.invalidations.add(this.getUserByUsernameCacheKey(realm.getId(), user.getUsername()));
        if (realm.isIdentityFederationEnabled()) {
            this.invalidations.add(this.getFederatedIdentityLinksCacheKey(user.getId()));
        }
    }

    public void evict(RealmModel realm, UserModel user) {
        if (user instanceof CachedUserModel) {
            ((CachedUserModel)user).invalidate();
        } else {
            this.invalidations.add(user.getId());
            if (user.getEmail() != null) {
                this.invalidations.add(this.getUserByEmailCacheKey(realm.getId(), user.getEmail()));
            }
            this.invalidations.add(this.getUserByUsernameCacheKey(realm.getId(), user.getUsername()));
            if (realm.isIdentityFederationEnabled()) {
                this.invalidations.add(this.getFederatedIdentityLinksCacheKey(user.getId()));
            }
        }
    }

    protected void runInvalidations() {
        for (String realmId : this.realmInvalidations) {
            this.cache.invalidateRealmUsers(realmId, this.invalidations);
        }
        for (String invalidation : this.invalidations) {
            this.cache.invalidateObject(invalidation);
        }
    }

    private KeycloakTransaction getTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                UserCacheSession.this.transactionActive = true;
            }

            public void commit() {
                if (UserCacheSession.this.delegate == null) {
                    return;
                }
                UserCacheSession.this.runInvalidations();
                UserCacheSession.this.transactionActive = false;
            }

            public void rollback() {
                UserCacheSession.this.setRollbackOnly = true;
                UserCacheSession.this.runInvalidations();
                UserCacheSession.this.transactionActive = false;
            }

            public void setRollbackOnly() {
                UserCacheSession.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return UserCacheSession.this.setRollbackOnly;
            }

            public boolean isActive() {
                return UserCacheSession.this.transactionActive;
            }
        };
    }

    private boolean isRegisteredForInvalidation(RealmModel realm, String userId) {
        return this.realmInvalidations.contains(realm.getId()) || this.invalidations.contains(userId);
    }

    public UserModel getUserById(String id, RealmModel realm) {
        boolean wasCached;
        logger.tracev("getuserById {0}", (Object)id);
        if (this.isRegisteredForInvalidation(realm, id)) {
            logger.trace((Object)"registered for invalidation return delegate");
            return this.getDelegate().getUserById(id, realm);
        }
        if (this.managedUsers.containsKey(id)) {
            logger.trace((Object)"return managedusers");
            return this.managedUsers.get(id);
        }
        CachedUser cached = this.cache.get(id, CachedUser.class);
        UserModel delegate = null;
        boolean bl = wasCached = cached != null;
        if (cached == null) {
            logger.trace((Object)"not cached");
            Long loaded = this.cache.getCurrentRevision(id);
            delegate = this.getDelegate().getUserById(id, realm);
            if (delegate == null) {
                logger.trace((Object)"delegate returning null");
                return null;
            }
            cached = new CachedUser(loaded, realm, delegate);
            this.cache.addRevisioned(cached, this.startupRevision);
        }
        logger.trace((Object)"returning new cache adapter");
        UserAdapter adapter = new UserAdapter(cached, this, this.session, realm);
        if (!wasCached) {
            this.onCache(realm, adapter, delegate);
        }
        this.managedUsers.put(id, (UserModel)adapter);
        return adapter;
    }

    public String getUserByUsernameCacheKey(String realmId, String username) {
        return realmId + ".username." + username;
    }

    public String getUserByEmailCacheKey(String realmId, String email) {
        return realmId + ".email." + email;
    }

    public String getUserByFederatedIdentityCacheKey(String realmId, FederatedIdentityModel socialLink) {
        return realmId + ".idp." + socialLink.getIdentityProvider() + "." + socialLink.getUserId();
    }

    public String getFederatedIdentityLinksCacheKey(String userId) {
        return userId + ".idplinks";
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        logger.tracev("getUserByUsername: {0}", (Object)username);
        username = username.toLowerCase();
        if (this.realmInvalidations.contains(realm.getId())) {
            logger.tracev("realmInvalidations", new Object[0]);
            return this.getDelegate().getUserByUsername(username, realm);
        }
        String cacheKey = this.getUserByUsernameCacheKey(realm.getId(), username);
        if (this.invalidations.contains(cacheKey)) {
            logger.tracev("invalidations", new Object[0]);
            return this.getDelegate().getUserByUsername(username, realm);
        }
        UserListQuery query = this.cache.get(cacheKey, UserListQuery.class);
        String userId = null;
        if (query == null) {
            logger.tracev("query null", new Object[0]);
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            UserModel model = this.getDelegate().getUserByUsername(username, realm);
            if (model == null) {
                logger.tracev("model from delegate null", new Object[0]);
                return null;
            }
            userId = model.getId();
            query = new UserListQuery(loaded, cacheKey, realm, model.getId());
            this.cache.addRevisioned(query, this.startupRevision);
            if (this.invalidations.contains(userId)) {
                return model;
            }
            if (this.managedUsers.containsKey(userId)) {
                logger.tracev("return managed user", new Object[0]);
                return this.managedUsers.get(userId);
            }
            UserAdapter adapter = this.getUserAdapter(realm, userId, loaded, model);
            this.managedUsers.put(userId, (UserModel)adapter);
            return adapter;
        }
        userId = query.getUsers().iterator().next();
        if (this.invalidations.contains(userId)) {
            logger.tracev("invalidated cache return delegate", new Object[0]);
            return this.getDelegate().getUserByUsername(username, realm);
        }
        logger.trace((Object)"return getUserById");
        return this.getUserById(userId, realm);
    }

    protected UserAdapter getUserAdapter(RealmModel realm, String userId, Long loaded, UserModel delegate) {
        boolean wasCached;
        CachedUser cached = this.cache.get(userId, CachedUser.class);
        boolean bl = wasCached = cached != null;
        if (cached == null) {
            cached = new CachedUser(loaded, realm, delegate);
            this.cache.addRevisioned(cached, this.startupRevision);
        }
        UserAdapter adapter = new UserAdapter(cached, this, this.session, realm);
        if (!wasCached) {
            this.onCache(realm, adapter, delegate);
        }
        return adapter;
    }

    private void onCache(RealmModel realm, UserAdapter adapter, UserModel delegate) {
        ((OnUserCache)this.getDelegate()).onCache(realm, (CachedUserModel)adapter, delegate);
        ((OnUserCache)this.session.userCredentialManager()).onCache(realm, (CachedUserModel)adapter, delegate);
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        if (email == null) {
            return null;
        }
        email = email.toLowerCase();
        if (this.realmInvalidations.contains(realm.getId())) {
            return this.getDelegate().getUserByEmail(email, realm);
        }
        String cacheKey = this.getUserByEmailCacheKey(realm.getId(), email);
        if (this.invalidations.contains(cacheKey)) {
            return this.getDelegate().getUserByEmail(email, realm);
        }
        UserListQuery query = this.cache.get(cacheKey, UserListQuery.class);
        String userId = null;
        if (query == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            UserModel model = this.getDelegate().getUserByEmail(email, realm);
            if (model == null) {
                return null;
            }
            userId = model.getId();
            query = new UserListQuery(loaded, cacheKey, realm, model.getId());
            this.cache.addRevisioned(query, this.startupRevision);
            if (this.invalidations.contains(userId)) {
                return model;
            }
            if (this.managedUsers.containsKey(userId)) {
                return this.managedUsers.get(userId);
            }
            UserAdapter adapter = this.getUserAdapter(realm, userId, loaded, model);
            this.managedUsers.put(userId, (UserModel)adapter);
            return adapter;
        }
        userId = query.getUsers().iterator().next();
        if (this.invalidations.contains(userId)) {
            return this.getDelegate().getUserByEmail(email, realm);
        }
        return this.getUserById(userId, realm);
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public UserModel getUserByFederatedIdentity(FederatedIdentityModel socialLink, RealmModel realm) {
        if (socialLink == null) {
            return null;
        }
        if (!realm.isIdentityFederationEnabled()) {
            return null;
        }
        if (this.realmInvalidations.contains(realm.getId())) {
            return this.getDelegate().getUserByFederatedIdentity(socialLink, realm);
        }
        String cacheKey = this.getUserByFederatedIdentityCacheKey(realm.getId(), socialLink);
        if (this.invalidations.contains(cacheKey)) {
            return this.getDelegate().getUserByFederatedIdentity(socialLink, realm);
        }
        UserListQuery query = this.cache.get(cacheKey, UserListQuery.class);
        String userId = null;
        if (query == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            UserModel model = this.getDelegate().getUserByFederatedIdentity(socialLink, realm);
            if (model == null) {
                return null;
            }
            userId = model.getId();
            query = new UserListQuery(loaded, cacheKey, realm, userId);
            this.cache.addRevisioned(query, this.startupRevision);
            if (this.invalidations.contains(userId)) {
                return model;
            }
            if (this.managedUsers.containsKey(userId)) {
                return this.managedUsers.get(userId);
            }
            UserAdapter adapter = this.getUserAdapter(realm, userId, loaded, model);
            this.managedUsers.put(userId, (UserModel)adapter);
            return adapter;
        }
        userId = query.getUsers().iterator().next();
        if (this.invalidations.contains(userId)) {
            this.invalidations.add(cacheKey);
            return this.getDelegate().getUserByFederatedIdentity(socialLink, realm);
        }
        return this.getUserById(userId, realm);
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
        return this.getDelegate().getGroupMembers(realm, group, firstResult, maxResults);
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
        return this.getDelegate().getGroupMembers(realm, group);
    }

    public UserModel getServiceAccount(ClientModel client) {
        String username = "service-account-" + client.getClientId();
        UserModel user = this.getUserByUsername(username, client.getRealm());
        if (user != null && user.getServiceAccountClientLink() != null && user.getServiceAccountClientLink().equals(client.getId())) {
            return user;
        }
        return this.getDelegate().getServiceAccount(client);
    }

    public List<UserModel> getUsers(RealmModel realm, boolean includeServiceAccounts) {
        return this.getDelegate().getUsers(realm, includeServiceAccounts);
    }

    public int getUsersCount(RealmModel realm) {
        return this.getDelegate().getUsersCount(realm);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults, boolean includeServiceAccounts) {
        return this.getDelegate().getUsers(realm, firstResult, maxResults, includeServiceAccounts);
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getUsers(realm, false);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        return this.getUsers(realm, firstResult, maxResults, false);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.getDelegate().searchForUser(search, realm);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        return this.getDelegate().searchForUser(search, realm, firstResult, maxResults);
    }

    public List<UserModel> searchForUser(Map<String, String> attributes, RealmModel realm) {
        return this.getDelegate().searchForUser(attributes, realm);
    }

    public List<UserModel> searchForUser(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        return this.getDelegate().searchForUser(attributes, realm, firstResult, maxResults);
    }

    public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
        return this.getDelegate().searchForUserByUserAttribute(attrName, attrValue, realm);
    }

    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel user, RealmModel realm) {
        logger.tracev("getFederatedIdentities: {0}", (Object)user.getUsername());
        String cacheKey = this.getFederatedIdentityLinksCacheKey(user.getId());
        if (this.realmInvalidations.contains(realm.getId()) || this.invalidations.contains(user.getId()) || this.invalidations.contains(cacheKey)) {
            return this.getDelegate().getFederatedIdentities(user, realm);
        }
        CachedFederatedIdentityLinks cachedLinks = this.cache.get(cacheKey, CachedFederatedIdentityLinks.class);
        if (cachedLinks == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            Set federatedIdentities = this.getDelegate().getFederatedIdentities(user, realm);
            cachedLinks = new CachedFederatedIdentityLinks(loaded, cacheKey, realm, federatedIdentities);
            this.cache.addRevisioned(cachedLinks, this.startupRevision);
            return federatedIdentities;
        }
        return new HashSet<FederatedIdentityModel>(cachedLinks.getFederatedIdentities());
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel user, String socialProvider, RealmModel realm) {
        logger.tracev("getFederatedIdentity: {0} {1}", (Object)user.getUsername(), (Object)socialProvider);
        String cacheKey = this.getFederatedIdentityLinksCacheKey(user.getId());
        if (this.realmInvalidations.contains(realm.getId()) || this.invalidations.contains(user.getId()) || this.invalidations.contains(cacheKey)) {
            return this.getDelegate().getFederatedIdentity(user, socialProvider, realm);
        }
        Set<FederatedIdentityModel> federatedIdentities = this.getFederatedIdentities(user, realm);
        for (FederatedIdentityModel socialLink : federatedIdentities) {
            if (!socialLink.getIdentityProvider().equals(socialProvider)) continue;
            return socialLink;
        }
        return null;
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        this.invalidations.add(this.getConsentCacheKey(userId));
        this.getDelegate().updateConsent(realm, userId, consent);
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientInternalId) {
        this.invalidations.add(this.getConsentCacheKey(userId));
        return this.getDelegate().revokeConsentForClient(realm, userId, clientInternalId);
    }

    public String getConsentCacheKey(String userId) {
        return userId + ".consents";
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        this.invalidations.add(this.getConsentCacheKey(userId));
        this.getDelegate().addConsent(realm, userId, consent);
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientId) {
        CachedUserConsent cachedConsent;
        logger.tracev("getConsentByClient: {0}", (Object)userId);
        String cacheKey = this.getConsentCacheKey(userId);
        if (this.realmInvalidations.contains(realm.getId()) || this.invalidations.contains(userId) || this.invalidations.contains(cacheKey)) {
            return this.getDelegate().getConsentByClient(realm, userId, clientId);
        }
        CachedUserConsents cached = this.cache.get(cacheKey, CachedUserConsents.class);
        if (cached == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            List consents = this.getDelegate().getConsents(realm, userId);
            cached = new CachedUserConsents(loaded, cacheKey, realm, consents);
            this.cache.addRevisioned(cached, this.startupRevision);
        }
        if ((cachedConsent = cached.getConsents().get(clientId)) == null) {
            return null;
        }
        return this.toConsentModel(realm, cachedConsent);
    }

    public List<UserConsentModel> getConsents(RealmModel realm, String userId) {
        logger.tracev("getConsents: {0}", (Object)userId);
        String cacheKey = this.getConsentCacheKey(userId);
        if (this.realmInvalidations.contains(realm.getId()) || this.invalidations.contains(userId) || this.invalidations.contains(cacheKey)) {
            return this.getDelegate().getConsents(realm, userId);
        }
        CachedUserConsents cached = this.cache.get(cacheKey, CachedUserConsents.class);
        if (cached == null) {
            Long loaded = this.cache.getCurrentRevision(cacheKey);
            List consents = this.getDelegate().getConsents(realm, userId);
            cached = new CachedUserConsents(loaded, cacheKey, realm, consents);
            this.cache.addRevisioned(cached, this.startupRevision);
            return consents;
        }
        LinkedList<UserConsentModel> result = new LinkedList<UserConsentModel>();
        for (CachedUserConsent cachedConsent : cached.getConsents().values()) {
            UserConsentModel consent = this.toConsentModel(realm, cachedConsent);
            if (consent == null) continue;
            result.add(consent);
        }
        return result;
    }

    private UserConsentModel toConsentModel(RealmModel realm, CachedUserConsent cachedConsent) {
        ClientModel client = this.session.realms().getClientById(cachedConsent.getClientDbId(), realm);
        if (client == null) {
            return null;
        }
        UserConsentModel consentModel = new UserConsentModel(client);
        consentModel.setCreatedDate(cachedConsent.getCreatedDate());
        consentModel.setLastUpdatedDate(cachedConsent.getLastUpdatedDate());
        for (String roleId : cachedConsent.getRoleIds()) {
            RoleModel role = this.session.realms().getRoleById(roleId, realm);
            if (role == null) continue;
            consentModel.addGrantedRole(role);
        }
        for (ProtocolMapperModel protocolMapper : cachedConsent.getProtocolMappers()) {
            consentModel.addGrantedProtocolMapper(protocolMapper);
        }
        return consentModel;
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        UserModel user = this.getDelegate().addUser(realm, id, username, addDefaultRoles, addDefaultRoles);
        this.invalidateUser(realm, user);
        this.managedUsers.put(user.getId(), user);
        return user;
    }

    public UserModel addUser(RealmModel realm, String username) {
        UserModel user = this.getDelegate().addUser(realm, username);
        this.invalidateUser(realm, user);
        this.managedUsers.put(user.getId(), user);
        return user;
    }

    protected void invalidateUser(RealmModel realm, UserModel user) {
        if (realm.isIdentityFederationEnabled()) {
            Set<FederatedIdentityModel> federatedIdentities = this.getFederatedIdentities(user, realm);
            for (FederatedIdentityModel socialLink : federatedIdentities) {
                String fedIdentityCacheKey = this.getUserByFederatedIdentityCacheKey(realm.getId(), socialLink);
                this.invalidations.add(fedIdentityCacheKey);
            }
            this.invalidations.add(this.getFederatedIdentityLinksCacheKey(user.getId()));
        }
        this.invalidations.add(user.getId());
        if (user.getEmail() != null) {
            this.invalidations.add(this.getUserByEmailCacheKey(realm.getId(), user.getEmail()));
        }
        this.invalidations.add(this.getUserByUsernameCacheKey(realm.getId(), user.getUsername()));
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        this.invalidateUser(realm, user);
        return this.getDelegate().removeUser(realm, user);
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel socialLink) {
        this.invalidations.add(this.getFederatedIdentityLinksCacheKey(user.getId()));
        this.getDelegate().addFederatedIdentity(realm, user, socialLink);
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        this.invalidations.add(this.getFederatedIdentityLinksCacheKey(federatedUser.getId()));
        this.getDelegate().updateFederatedIdentity(realm, federatedUser, federatedIdentityModel);
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String socialProvider) {
        FederatedIdentityModel socialLink = this.getFederatedIdentity(user, socialProvider, realm);
        this.invalidations.add(this.getFederatedIdentityLinksCacheKey(user.getId()));
        if (socialLink != null) {
            this.invalidations.add(this.getUserByFederatedIdentityCacheKey(realm.getId(), socialLink));
        }
        return this.getDelegate().removeFederatedIdentity(realm, user, socialProvider);
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        this.realmInvalidations.add(realm.getId());
        this.getDelegate().grantToAllUsers(realm, role);
    }

    public void preRemove(RealmModel realm) {
        this.realmInvalidations.add(realm.getId());
        this.getDelegate().preRemove(realm);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.realmInvalidations.add(realm.getId());
        this.getDelegate().preRemove(realm, role);
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        this.realmInvalidations.add(realm.getId());
        this.getDelegate().preRemove(realm, group);
    }

    public void preRemove(RealmModel realm, UserFederationProviderModel link) {
        this.realmInvalidations.add(realm.getId());
        this.getDelegate().preRemove(realm, link);
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        this.realmInvalidations.add(realm.getId());
        this.getDelegate().preRemove(realm, client);
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
        this.getDelegate().preRemove(protocolMapper);
    }

    public void preRemove(RealmModel realm, ComponentModel component) {
        if (!component.getProviderType().equals(UserStorageProvider.class.getName())) {
            return;
        }
        this.realmInvalidations.add(realm.getId());
        this.getDelegate().preRemove(realm, component);
    }
}

