/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.authorization.infinispan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.authorization.infinispan.InfinispanStoreFactoryProvider;
import org.keycloak.models.authorization.infinispan.entities.CachedPolicy;
import org.keycloak.models.cache.authorization.CachedStoreFactoryProvider;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

public class CachedPolicyStore
implements PolicyStore {
    private static final String POLICY_ID_CACHE_PREFIX = "policy-id-";
    private final Cache<String, Map<String, List<CachedPolicy>>> cache;
    private final KeycloakSession session;
    private final InfinispanStoreFactoryProvider.CacheTransaction transaction;
    private final List<String> cacheKeys;
    private StoreFactory storeFactory;
    private PolicyStore delegate;
    private CachedStoreFactoryProvider cachedStoreFactory;

    public CachedPolicyStore(KeycloakSession session, InfinispanStoreFactoryProvider.CacheTransaction transaction, StoreFactory storeFactory) {
        this.session = session;
        this.transaction = transaction;
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        this.cache = provider.getCache("authorization");
        this.cacheKeys = new ArrayList<String>();
        this.cacheKeys.add("findByResource");
        this.cacheKeys.add("findByResourceType");
        this.cacheKeys.add("findByScopeIds");
        this.cacheKeys.add("findByType");
        this.storeFactory = storeFactory;
    }

    public Policy create(String name, String type, ResourceServer resourceServer) {
        Policy policy = this.getDelegate().create(name, type, this.getStoreFactory().getResourceServerStore().findById(resourceServer.getId()));
        String id = policy.getId();
        this.transaction.whenRollback(() -> this.resolveResourceServerCache(resourceServer.getId()).remove(this.getCacheKeyForPolicy(id)));
        this.transaction.whenCommit(() -> this.invalidateCache(resourceServer.getId()));
        return this.createAdapter(new CachedPolicy(policy));
    }

    public void delete(String id) {
        Policy policy = this.getDelegate().findById(id, null);
        if (policy == null) {
            return;
        }
        ResourceServer resourceServer = policy.getResourceServer();
        this.getDelegate().delete(id);
        this.transaction.whenCommit(() -> this.invalidateCache(resourceServer.getId()));
    }

    public Policy findById(String id, String resourceServerId) {
        String cacheKeyForPolicy = this.getCacheKeyForPolicy(id);
        List<CachedPolicy> cached = this.resolveResourceServerCache(resourceServerId).get(cacheKeyForPolicy);
        if (cached == null) {
            Policy policy = this.getDelegate().findById(id, resourceServerId);
            if (policy != null) {
                CachedPolicy cachedPolicy = new CachedPolicy(policy);
                this.resolveResourceServerCache(resourceServerId).put(cacheKeyForPolicy, Arrays.asList(cachedPolicy));
                return this.createAdapter(cachedPolicy);
            }
            return null;
        }
        return this.createAdapter(cached.get(0));
    }

    public Policy findByName(String name, String resourceServerId) {
        return this.getDelegate().findByName(name, resourceServerId);
    }

    public List<Policy> findByResourceServer(String resourceServerId) {
        return this.getDelegate().findByResourceServer(resourceServerId);
    }

    public List<Policy> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        return this.getDelegate().findByResourceServer(attributes, resourceServerId, firstResult, maxResult);
    }

    public List<Policy> findByResource(String resourceId, String resourceServerId) {
        return this.cacheResult(resourceServerId, "findByResource" + resourceId, () -> this.getDelegate().findByResource(resourceId, resourceServerId));
    }

    public List<Policy> findByResourceType(String resourceType, String resourceServerId) {
        return this.cacheResult(resourceServerId, "findByResourceType" + resourceType, () -> this.getDelegate().findByResourceType(resourceType, resourceServerId));
    }

    public List<Policy> findByScopeIds(List<String> scopeIds, String resourceServerId) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        for (String scopeId : scopeIds) {
            policies.addAll(this.cacheResult(resourceServerId, "findByScopeIds" + scopeId, () -> this.getDelegate().findByScopeIds(Arrays.asList(scopeId), resourceServerId)));
        }
        return policies;
    }

    public List<Policy> findByType(String type, String resourceServerId) {
        return this.cacheResult(resourceServerId, "findByType" + type, () -> this.getDelegate().findByType(type, resourceServerId));
    }

    public List<Policy> findDependentPolicies(String id, String resourceServerId) {
        return this.getDelegate().findDependentPolicies(id, resourceServerId);
    }

    public void notifyChange(Object cached) {
        String resourceServerId;
        if (Resource.class.isInstance(cached)) {
            resourceServerId = ((Resource)cached).getResourceServer().getId();
        } else if (Scope.class.isInstance(cached)) {
            resourceServerId = ((Scope)cached).getResourceServer().getId();
        } else {
            throw new RuntimeException("Unexpected notification [" + cached + "]");
        }
        this.invalidateCache(resourceServerId);
    }

    private String getCacheKeyForPolicy(String policyId) {
        return POLICY_ID_CACHE_PREFIX + policyId;
    }

    private StoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    private PolicyStore getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.getStoreFactory().getPolicyStore();
        }
        return this.delegate;
    }

    private Policy createAdapter(final CachedPolicy cached) {
        return new Policy(){
            private Set<Scope> scopes;
            private Set<Resource> resources;
            private Set<Policy> associatedPolicies;
            private Policy updated;

            public String getId() {
                return cached.getId();
            }

            public String getType() {
                return cached.getType();
            }

            public DecisionStrategy getDecisionStrategy() {
                return cached.getDecisionStrategy();
            }

            public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
                this.getDelegateForUpdate().setDecisionStrategy(decisionStrategy);
                cached.setDecisionStrategy(decisionStrategy);
            }

            public Logic getLogic() {
                return cached.getLogic();
            }

            public void setLogic(Logic logic) {
                this.getDelegateForUpdate().setLogic(logic);
                cached.setLogic(logic);
            }

            public Map<String, String> getConfig() {
                return cached.getConfig();
            }

            public void setConfig(Map<String, String> config) {
                this.getDelegateForUpdate().setConfig(config);
                cached.setConfig(config);
            }

            public String getName() {
                return cached.getName();
            }

            public void setName(String name) {
                this.getDelegateForUpdate().setName(name);
                cached.setName(name);
            }

            public String getDescription() {
                return cached.getDescription();
            }

            public void setDescription(String description) {
                this.getDelegateForUpdate().setDescription(description);
                cached.setDescription(description);
            }

            public ResourceServer getResourceServer() {
                return CachedPolicyStore.this.getCachedStoreFactory().getResourceServerStore().findById(cached.getResourceServerId());
            }

            public void addScope(Scope scope) {
                this.getDelegateForUpdate().addScope(CachedPolicyStore.this.getStoreFactory().getScopeStore().findById(scope.getId(), cached.getResourceServerId()));
                cached.addScope(scope);
            }

            public void removeScope(Scope scope) {
                this.getDelegateForUpdate().removeScope(scope);
                cached.removeScope(scope);
            }

            public void addAssociatedPolicy(Policy associatedPolicy) {
                this.getDelegateForUpdate().addAssociatedPolicy(CachedPolicyStore.this.getStoreFactory().getPolicyStore().findById(associatedPolicy.getId(), cached.getResourceServerId()));
                cached.addAssociatedPolicy(associatedPolicy);
            }

            public void removeAssociatedPolicy(Policy associatedPolicy) {
                this.getDelegateForUpdate().removeAssociatedPolicy(CachedPolicyStore.this.getStoreFactory().getPolicyStore().findById(associatedPolicy.getId(), cached.getResourceServerId()));
                cached.removeAssociatedPolicy(associatedPolicy);
            }

            public void addResource(Resource resource) {
                this.getDelegateForUpdate().addResource(CachedPolicyStore.this.getStoreFactory().getResourceStore().findById(resource.getId(), cached.getResourceServerId()));
                cached.addResource(resource);
            }

            public void removeResource(Resource resource) {
                this.getDelegateForUpdate().removeResource(CachedPolicyStore.this.getStoreFactory().getResourceStore().findById(resource.getId(), cached.getResourceServerId()));
                cached.removeResource(resource);
            }

            public Set<Policy> getAssociatedPolicies() {
                if (this.associatedPolicies == null) {
                    this.associatedPolicies = new HashSet<Policy>();
                    for (String id : cached.getAssociatedPoliciesIds()) {
                        Policy policy = CachedPolicyStore.this.findById(id, cached.getResourceServerId());
                        if (policy == null) continue;
                        this.associatedPolicies.add(policy);
                    }
                }
                return this.associatedPolicies;
            }

            public Set<Resource> getResources() {
                if (this.resources == null) {
                    this.resources = new HashSet<Resource>();
                    for (String id : cached.getResourcesIds()) {
                        Resource resource = CachedPolicyStore.this.getCachedStoreFactory().getResourceStore().findById(id, cached.getResourceServerId());
                        if (resource == null) continue;
                        this.resources.add(resource);
                    }
                }
                return this.resources;
            }

            public Set<Scope> getScopes() {
                if (this.scopes == null) {
                    this.scopes = new HashSet<Scope>();
                    for (String id : cached.getScopesIds()) {
                        Scope scope = CachedPolicyStore.this.getCachedStoreFactory().getScopeStore().findById(id, cached.getResourceServerId());
                        if (scope == null) continue;
                        this.scopes.add(scope);
                    }
                }
                return this.scopes;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (this.getId() == null) {
                    return false;
                }
                if (!Policy.class.isInstance(o)) {
                    return false;
                }
                Policy that = (Policy)o;
                return this.getId().equals(that.getId());
            }

            public int hashCode() {
                return this.getId() != null ? this.getId().hashCode() : super.hashCode();
            }

            private Policy getDelegateForUpdate() {
                if (this.updated == null) {
                    this.updated = CachedPolicyStore.this.getDelegate().findById(this.getId(), cached.getResourceServerId());
                    if (this.updated == null) {
                        throw new IllegalStateException("Not found in database");
                    }
                    CachedPolicyStore.this.transaction.whenCommit(() -> CachedPolicyStore.this.invalidateCache(cached.getResourceServerId()));
                    CachedPolicyStore.this.transaction.whenRollback(() -> CachedPolicyStore.this.resolveResourceServerCache(cached.getResourceServerId()).remove(CachedPolicyStore.this.getCacheKeyForPolicy(this.getId())));
                }
                return this.updated;
            }
        };
    }

    private CachedStoreFactoryProvider getCachedStoreFactory() {
        if (this.cachedStoreFactory == null) {
            this.cachedStoreFactory = (CachedStoreFactoryProvider)this.session.getProvider(CachedStoreFactoryProvider.class);
        }
        return this.cachedStoreFactory;
    }

    private void invalidateCache(String resourceServerId) {
        this.cache.remove((Object)resourceServerId);
    }

    private List<Policy> cacheResult(String resourceServerId, String key, Supplier<List<Policy>> provider) {
        List cached = this.resolveResourceServerCache(resourceServerId).computeIfAbsent(key, o -> {
            List result = (List)provider.get();
            if (result.isEmpty()) {
                return Collections.emptyList();
            }
            return result.stream().map(policy -> new CachedPolicy((Policy)policy)).collect(Collectors.toList());
        });
        if (cached == null) {
            return Collections.emptyList();
        }
        return cached.stream().map(cachedPolicy -> this.createAdapter((CachedPolicy)cachedPolicy)).collect(Collectors.toList());
    }

    private Map<String, List<CachedPolicy>> resolveResourceServerCache(String id) {
        return (Map)this.cache.computeIfAbsent((Object)id, key -> new HashMap());
    }
}

