/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.Cache;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.InfinispanUserSessionProvider;
import org.keycloak.models.sessions.infinispan.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class AuthenticatedClientSessionAdapter
implements AuthenticatedClientSessionModel {
    private final AuthenticatedClientSessionEntity entity;
    private final ClientModel client;
    private final InfinispanUserSessionProvider provider;
    private final Cache<String, SessionEntity> cache;
    private UserSessionAdapter userSession;

    public AuthenticatedClientSessionAdapter(AuthenticatedClientSessionEntity entity, ClientModel client, UserSessionAdapter userSession, InfinispanUserSessionProvider provider, Cache<String, SessionEntity> cache) {
        this.provider = provider;
        this.entity = entity;
        this.client = client;
        this.cache = cache;
        this.userSession = userSession;
    }

    private void update() {
        this.provider.getTx().replace(this.cache, this.userSession.getEntity().getId(), this.userSession.getEntity());
    }

    public void setUserSession(UserSessionModel userSession) {
        String clientUUID = this.client.getId();
        UserSessionEntity sessionEntity = this.userSession.getEntity();
        if (userSession == null) {
            if (sessionEntity.getAuthenticatedClientSessions() != null) {
                sessionEntity.getAuthenticatedClientSessions().remove(clientUUID);
                this.update();
                this.userSession = null;
            }
        } else {
            this.userSession = (UserSessionAdapter)userSession;
            sessionEntity.getAuthenticatedClientSessions().put(clientUUID, this.entity);
            this.update();
        }
    }

    public UserSessionModel getUserSession() {
        return this.userSession;
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public void setRedirectUri(String uri) {
        this.entity.setRedirectUri(uri);
        this.update();
    }

    public String getId() {
        return null;
    }

    public RealmModel getRealm() {
        return this.userSession.getRealm();
    }

    public ClientModel getClient() {
        return this.client;
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public void setTimestamp(int timestamp) {
        this.entity.setTimestamp(timestamp);
        this.update();
    }

    public String getAction() {
        return this.entity.getAction();
    }

    public void setAction(String action) {
        this.entity.setAction(action);
        this.update();
    }

    public String getProtocol() {
        return this.entity.getAuthMethod();
    }

    public void setProtocol(String method) {
        this.entity.setAuthMethod(method);
        this.update();
    }

    public Set<String> getRoles() {
        return this.entity.getRoles();
    }

    public void setRoles(Set<String> roles) {
        this.entity.setRoles(roles);
        this.update();
    }

    public Set<String> getProtocolMappers() {
        return this.entity.getProtocolMappers();
    }

    public void setProtocolMappers(Set<String> protocolMappers) {
        this.entity.setProtocolMappers(protocolMappers);
        this.update();
    }

    public String getNote(String name) {
        return this.entity.getNotes() == null ? null : this.entity.getNotes().get(name);
    }

    public void setNote(String name, String value) {
        if (this.entity.getNotes() == null) {
            this.entity.setNotes(new HashMap<String, String>());
        }
        this.entity.getNotes().put(name, value);
        this.update();
    }

    public void removeNote(String name) {
        if (this.entity.getNotes() != null) {
            this.entity.getNotes().remove(name);
            this.update();
        }
    }

    public Map<String, String> getNotes() {
        if (this.entity.getNotes() == null || this.entity.getNotes().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.entity.getNotes());
        return copy;
    }
}

