/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.stream;

import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class UserSessionPredicate
implements Predicate<Map.Entry<String, SessionEntity>>,
Serializable {
    private String realm;
    private String user;
    private String client;
    private Integer expired;
    private Integer expiredRefresh;
    private String brokerSessionId;
    private String brokerUserId;

    private UserSessionPredicate(String realm) {
        this.realm = realm;
    }

    public static UserSessionPredicate create(String realm) {
        return new UserSessionPredicate(realm);
    }

    public UserSessionPredicate user(String user) {
        this.user = user;
        return this;
    }

    public UserSessionPredicate client(String clientUUID) {
        this.client = clientUUID;
        return this;
    }

    public UserSessionPredicate expired(Integer expired, Integer expiredRefresh) {
        this.expired = expired;
        this.expiredRefresh = expiredRefresh;
        return this;
    }

    public UserSessionPredicate brokerSessionId(String id) {
        this.brokerSessionId = id;
        return this;
    }

    public UserSessionPredicate brokerUserId(String id) {
        this.brokerUserId = id;
        return this;
    }

    @Override
    public boolean test(Map.Entry<String, SessionEntity> entry) {
        SessionEntity e = entry.getValue();
        if (!(e instanceof UserSessionEntity)) {
            return false;
        }
        UserSessionEntity entity = (UserSessionEntity)e;
        if (!this.realm.equals(entity.getRealm())) {
            return false;
        }
        if (this.user != null && !entity.getUser().equals(this.user)) {
            return false;
        }
        if (!(this.client == null || entity.getAuthenticatedClientSessions() != null && entity.getAuthenticatedClientSessions().containsKey(this.client))) {
            return false;
        }
        if (this.brokerSessionId != null && !this.brokerSessionId.equals(entity.getBrokerSessionId())) {
            return false;
        }
        if (this.brokerUserId != null && !this.brokerUserId.equals(entity.getBrokerUserId())) {
            return false;
        }
        if (this.expired != null && this.expiredRefresh != null && entity.getStarted() > this.expired && entity.getLastSessionRefresh() > this.expiredRefresh) {
            return false;
        }
        return this.expired != null || this.expiredRefresh == null || entity.getLastSessionRefresh() <= this.expiredRefresh;
    }
}

