/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ClusterProviderFactory;
import org.keycloak.cluster.infinispan.CrossDCAwareCacheFactory;
import org.keycloak.cluster.infinispan.InfinispanClusterProvider;
import org.keycloak.cluster.infinispan.InfinispanNotificationsManager;
import org.keycloak.cluster.infinispan.LockEntry;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.sessions.infinispan.util.InfinispanUtil;

public class InfinispanClusterProviderFactory
implements ClusterProviderFactory {
    public static final String PROVIDER_ID = "infinispan";
    protected static final Logger logger = Logger.getLogger(InfinispanClusterProviderFactory.class);
    private volatile Cache<String, Serializable> workCache;
    private CrossDCAwareCacheFactory crossDCAwareCacheFactory;
    private int clusterStartupTime;
    private InfinispanNotificationsManager notificationsManager;
    private ExecutorService localExecutor = Executors.newCachedThreadPool();

    public ClusterProvider create(KeycloakSession session) {
        this.lazyInit(session);
        String myAddress = InfinispanUtil.getMyAddress(session);
        return new InfinispanClusterProvider(this.clusterStartupTime, myAddress, this.crossDCAwareCacheFactory, this.notificationsManager, this.localExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.workCache == null) {
            InfinispanClusterProviderFactory infinispanClusterProviderFactory = this;
            synchronized (infinispanClusterProviderFactory) {
                if (this.workCache == null) {
                    InfinispanConnectionProvider ispnConnections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
                    this.workCache = ispnConnections.getCache("work");
                    this.workCache.getCacheManager().addListener((Object)new ViewChangeListener());
                    Set<RemoteStore> remoteStores = InfinispanUtil.getRemoteStores(this.workCache);
                    this.crossDCAwareCacheFactory = CrossDCAwareCacheFactory.getFactory(this.workCache, remoteStores);
                    this.clusterStartupTime = this.initClusterStartupTime(session);
                    String myAddress = InfinispanUtil.getMyAddress(session);
                    String mySite = InfinispanUtil.getMySite(session);
                    this.notificationsManager = InfinispanNotificationsManager.create(this.workCache, myAddress, mySite, remoteStores);
                }
            }
        }
    }

    protected int initClusterStartupTime(KeycloakSession session) {
        Integer existingClusterStartTime = (Integer)this.crossDCAwareCacheFactory.getCache().get((Object)"cluster-start-time");
        if (existingClusterStartTime != null) {
            logger.debugf("Loaded cluster startup time: %s", (Object)Time.toDate((int)existingClusterStartTime).toString());
            return existingClusterStartTime;
        }
        int serverStartTime = (int)(session.getKeycloakSessionFactory().getServerStartupTimestamp() / 1000L);
        existingClusterStartTime = (Integer)this.crossDCAwareCacheFactory.getCache().putIfAbsent((Object)"cluster-start-time", (Object)serverStartTime);
        if (existingClusterStartTime == null) {
            logger.debugf("Initialized cluster startup time to %s", (Object)Time.toDate((int)serverStartTime).toString());
            return serverStartTime;
        }
        logger.debugf("Loaded cluster startup time: %s", (Object)Time.toDate((int)existingClusterStartTime).toString());
        return existingClusterStartTime;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Listener
    public class ViewChangeListener {
        @ViewChanged
        public void viewChanged(ViewChangedEvent event) {
            EmbeddedCacheManager cacheManager = event.getCacheManager();
            Transport transport = cacheManager.getTransport();
            if (transport != null && transport.isCoordinator()) {
                Set<String> newAddresses = this.convertAddresses(event.getNewMembers());
                final Set<String> removedNodesAddresses = this.convertAddresses(event.getOldMembers());
                removedNodesAddresses.removeAll(newAddresses);
                if (removedNodesAddresses.isEmpty()) {
                    return;
                }
                logger.debugf("Nodes %s removed from cluster. Removing tasks locked by this nodes", (Object)removedNodesAddresses.toString());
                Cache cache = cacheManager.getCache("work");
                Iterator toRemove = cache.entrySet().stream().filter((Predicate)new Predicate<Map.Entry<String, Serializable>>(){

                    @Override
                    public boolean test(Map.Entry<String, Serializable> entry) {
                        if (!(entry.getValue() instanceof LockEntry)) {
                            return false;
                        }
                        LockEntry lock = (LockEntry)entry.getValue();
                        return removedNodesAddresses.contains(lock.getNode());
                    }
                }).map(new Function<Map.Entry<String, Serializable>, String>(){

                    @Override
                    public String apply(Map.Entry<String, Serializable> entry) {
                        return entry.getKey();
                    }
                }).iterator();
                while (toRemove.hasNext()) {
                    String rem = (String)toRemove.next();
                    if (logger.isTraceEnabled()) {
                        logger.tracef("Removing task %s due it's node left cluster", (Object)rem);
                    }
                    InfinispanClusterProviderFactory.this.notificationsManager.taskFinished(rem, false);
                    cache.remove((Object)rem);
                }
            }
        }

        private Set<String> convertAddresses(Collection<Address> addresses) {
            return addresses.stream().map(new Function<Address, String>(){

                @Override
                public String apply(Address address) {
                    return address.toString();
                }
            }).collect(Collectors.toSet());
        }
    }
}

