/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;

public class CachedUserConsent {
    private final String clientDbId;
    private final Set<ProtocolMapperModel> protocolMappers = new HashSet<ProtocolMapperModel>();
    private final Set<String> roleIds = new HashSet<String>();
    private final Long createdDate;
    private final Long lastUpdatedDate;

    public CachedUserConsent(UserConsentModel consentModel) {
        this.clientDbId = consentModel.getClient().getId();
        this.protocolMappers.addAll(consentModel.getGrantedProtocolMappers());
        for (RoleModel role : consentModel.getGrantedRoles()) {
            this.roleIds.add(role.getId());
        }
        this.createdDate = consentModel.getCreatedDate();
        this.lastUpdatedDate = consentModel.getLastUpdatedDate();
    }

    public String getClientDbId() {
        return this.clientDbId;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        return this.protocolMappers;
    }

    public Set<String> getRoleIds() {
        return this.roleIds;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public Long getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }
}

