/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remotestore;

import java.util.Optional;
import java.util.concurrent.Executor;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.filter.KeyFilter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.persistence.InitializationContextImpl;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.InitializationContext;
import org.infinispan.persistence.spi.PersistenceException;
import org.jboss.logging.Logger;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.remotestore.KeycloakRemoteStoreConfiguration;

@ConfiguredBy(value=KeycloakRemoteStoreConfiguration.class)
public class KeycloakRemoteStore
extends RemoteStore {
    protected static final Logger logger = Logger.getLogger(KeycloakRemoteStore.class);
    private String remoteCacheName;

    public void start() throws PersistenceException {
        this.remoteCacheName = this.getConfiguration().remoteCacheName();
        String cacheTemplateName = this.getConfiguration().useConfigTemplateFromCache();
        if (cacheTemplateName != null) {
            logger.debugf("Will override configuration of cache '%s' from template of cache '%s'", (Object)this.ctx.getCache().getName(), (Object)cacheTemplateName);
            EmbeddedCacheManager cacheManager = this.ctx.getCache().getCacheManager();
            cacheManager.getCache(cacheTemplateName, true);
            Optional<StoreConfiguration> optional = cacheManager.getCacheConfiguration(cacheTemplateName).persistence().stores().stream().filter(storeConfig -> storeConfig instanceof RemoteStoreConfiguration).findFirst();
            if (!optional.isPresent()) {
                throw new CacheException("Unable to find remoteStore on cache '" + cacheTemplateName + ".");
            }
            RemoteStoreConfiguration templateConfig = (RemoteStoreConfiguration)optional.get();
            PersistenceConfigurationBuilder readPersistenceBuilder = new ConfigurationBuilder().read(this.ctx.getCache().getCacheConfiguration()).persistence();
            RemoteStoreConfigurationBuilder configBuilder = new RemoteStoreConfigurationBuilder(readPersistenceBuilder);
            configBuilder.read(templateConfig);
            configBuilder.remoteCacheName(this.remoteCacheName);
            RemoteStoreConfiguration newCfg1 = configBuilder.create();
            KeycloakRemoteStoreConfiguration newCfg = new KeycloakRemoteStoreConfiguration(newCfg1);
            InitializationContextImpl ctx = new InitializationContextImpl((StoreConfiguration)newCfg, this.ctx.getCache(), this.ctx.getMarshaller(), this.ctx.getTimeService(), this.ctx.getByteBufferFactory(), this.ctx.getMarshalledEntryFactory());
            this.init((InitializationContext)ctx);
        } else {
            logger.debugf("Skip overriding configuration from template for cache '%s'", (Object)this.ctx.getCache().getName());
        }
        super.start();
        if (this.getRemoteCache() == null) {
            String cacheName = this.getConfiguration().remoteCacheName();
            throw new CacheException("Remote cache '" + cacheName + "' is not available.");
        }
    }

    public MarshalledEntry load(Object key) throws PersistenceException {
        logger.debugf("Calling load: '%s' for remote cache '%s'", key, (Object)this.remoteCacheName);
        MarshalledEntry entry = super.load(key);
        if (entry == null) {
            return null;
        }
        SessionEntity entity = (SessionEntity)entry.getValue();
        SessionEntityWrapper<SessionEntity> entityWrapper = new SessionEntityWrapper<SessionEntity>(entity);
        MarshalledEntry wrappedEntry = this.marshalledEntry(entry.getKey(), entityWrapper, entry.getMetadata());
        logger.debugf("Found entry in load: %s", (Object)wrappedEntry.toString());
        return wrappedEntry;
    }

    public void process(KeyFilter filter, AdvancedCacheLoader.CacheLoaderTask task, Executor executor, boolean fetchValue, boolean fetchMetadata) {
        logger.debugf("Skip calling process with filter '%s' on cache '%s'", (Object)filter, (Object)this.remoteCacheName);
    }

    public void write(MarshalledEntry entry) throws PersistenceException {
    }

    public boolean delete(Object key) throws PersistenceException {
        logger.debugf("Calling delete for key '%s' on cache '%s'", key, (Object)this.remoteCacheName);
        this.getRemoteCache().remove(key);
        return true;
    }

    protected MarshalledEntry marshalledEntry(Object key, Object value, InternalMetadata metadata) {
        return this.ctx.getMarshalledEntryFactory().newMarshalledEntry(key, value, metadata);
    }

    public KeycloakRemoteStoreConfiguration getConfiguration() {
        return (KeycloakRemoteStoreConfiguration)super.getConfiguration();
    }
}

