/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import org.jboss.logging.Logger;
import org.keycloak.models.sessions.infinispan.changes.UserSessionUpdateTask;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public abstract class UserSessionClientSessionUpdateTask
extends UserSessionUpdateTask {
    public static final Logger logger = Logger.getLogger(UserSessionClientSessionUpdateTask.class);
    private final String clientUUID;

    public UserSessionClientSessionUpdateTask(String clientUUID) {
        this.clientUUID = clientUUID;
    }

    @Override
    public void runUpdate(UserSessionEntity userSession) {
        AuthenticatedClientSessionEntity clientSession = userSession.getAuthenticatedClientSessions().get(this.clientUUID);
        if (clientSession == null) {
            logger.warnf("Not found authenticated client session entity for client %s in userSession %s", (Object)this.clientUUID, (Object)userSession.getId());
            return;
        }
        this.runClientSessionUpdate(clientSession);
    }

    protected abstract void runClientSessionUpdate(AuthenticatedClientSessionEntity var1);
}

