/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.initializer;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.remoting.transport.Transport;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.sessions.infinispan.initializer.BaseCacheInitializer;
import org.keycloak.models.sessions.infinispan.initializer.InitializerState;
import org.keycloak.models.sessions.infinispan.initializer.SessionInitializerWorker;
import org.keycloak.models.sessions.infinispan.initializer.SessionLoader;

public class InfinispanCacheInitializer
extends BaseCacheInitializer {
    private static final Logger log = Logger.getLogger(InfinispanCacheInitializer.class);
    private final int maxErrors;

    public InfinispanCacheInitializer(KeycloakSessionFactory sessionFactory, Cache<String, Serializable> workCache, SessionLoader sessionLoader, String stateKeySuffix, int sessionsPerSegment, int maxErrors) {
        super(sessionFactory, workCache, sessionLoader, stateKeySuffix, sessionsPerSegment);
        this.maxErrors = maxErrors;
    }

    @Override
    public void initCache() {
        this.workCache.getAdvancedCache().getComponentRegistry().registerComponent((Object)this.sessionFactory, KeycloakSessionFactory.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startLoading() {
        InitializerState state = this.getOrCreateInitializerState();
        int processors = Runtime.getRuntime().availableProcessors();
        ExecutorService localExecutor = Executors.newCachedThreadPool();
        Transport transport = this.workCache.getCacheManager().getTransport();
        boolean distributed = transport != null;
        ExecutorService executorService = distributed ? new DefaultExecutorService(this.workCache, localExecutor) : localExecutor;
        int errors = 0;
        try {
            while (!state.isFinished()) {
                int nodesCount = transport == null ? 1 : transport.getMembers().size();
                int distributedWorkersCount = processors * nodesCount;
                log.debugf("Starting next iteration with %d workers", distributedWorkersCount);
                List<Integer> segments = state.getUnfinishedSegments(distributedWorkersCount);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("unfinished segments for this iteration: " + segments));
                }
                LinkedList futures = new LinkedList();
                for (Integer n : segments) {
                    SessionInitializerWorker worker = new SessionInitializerWorker();
                    worker.setWorkerEnvironment(n, this.sessionsPerSegment, this.sessionLoader);
                    if (!distributed) {
                        worker.setEnvironment((Cache<String, Serializable>)this.workCache, null);
                    }
                    Future future = executorService.submit(worker);
                    futures.add(future);
                }
                for (Future future : futures) {
                    try {
                        WorkerResult result = (WorkerResult)future.get();
                        if (result.getSuccess().booleanValue()) {
                            int computedSegment = result.getSegment();
                            state.markSegmentFinished(computedSegment);
                            continue;
                        }
                        if (!log.isTraceEnabled()) continue;
                        log.tracef("Segment %d failed to compute", (Object)result.getSegment());
                    }
                    catch (InterruptedException ie) {
                        log.error((Object)("Interruped exception when computed future. Errors: " + ++errors), (Throwable)ie);
                    }
                    catch (ExecutionException ee) {
                        log.error((Object)("ExecutionException when computed future. Errors: " + ++errors), (Throwable)ee);
                    }
                }
                if (errors >= this.maxErrors) {
                    throw new RuntimeException("Maximum count of worker errors occured. Limit was " + this.maxErrors + ". See server.log for details");
                }
                this.saveStateToCache(state);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("New initializer state pushed. The state is: " + state.printState()));
            }
            this.sessionLoader.afterAllSessionsLoaded(this);
        }
        finally {
            if (distributed) {
                executorService.shutdown();
            }
            localExecutor.shutdown();
        }
    }

    public static class WorkerResult
    implements Serializable {
        private Integer segment;
        private Boolean success;

        public static WorkerResult create(Integer segment, boolean success) {
            WorkerResult res = new WorkerResult();
            res.setSegment(segment);
            res.setSuccess(success);
            return res;
        }

        public Integer getSegment() {
            return this.segment;
        }

        public void setSegment(Integer segment) {
            this.segment = segment;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }
    }
}

