/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.jboss.logging.Logger;

public class KeycloakMarshallUtil {
    private static final Logger log = Logger.getLogger(KeycloakMarshallUtil.class);
    public static final StringExternalizer STRING_EXT = new StringExternalizer();

    public static <K, V> void writeMap(Map<K, V> map, Externalizer<K> keyExternalizer, Externalizer<V> valueExternalizer, ObjectOutput output) throws IOException {
        if (map == null) {
            output.writeByte(0);
        } else {
            output.writeByte(1);
            HashMap<K, V> copy = new HashMap<K, V>(map);
            output.writeInt(copy.size());
            for (Map.Entry entry : copy.entrySet()) {
                keyExternalizer.writeObject(output, entry.getKey());
                valueExternalizer.writeObject(output, entry.getValue());
            }
        }
    }

    public static <K, V, TYPED_MAP extends Map<K, V>> TYPED_MAP readMap(ObjectInput input, Externalizer<K> keyExternalizer, Externalizer<V> valueExternalizer, MarshallUtil.MapBuilder<K, V, TYPED_MAP> mapBuilder) throws IOException, ClassNotFoundException {
        byte b = input.readByte();
        if (b == 0) {
            return null;
        }
        int size = input.readInt();
        Map map = mapBuilder.build(size);
        for (int i = 0; i < size; ++i) {
            Object key = keyExternalizer.readObject(input);
            Object value = valueExternalizer.readObject(input);
            map.put(key, value);
        }
        return (TYPED_MAP)map;
    }

    public static <E> void writeCollection(Collection<E> col, Externalizer<E> valueExternalizer, ObjectOutput output) throws IOException {
        if (col == null) {
            output.writeByte(0);
        } else {
            output.writeByte(1);
            LinkedList<E> copy = new LinkedList<E>(col);
            output.writeInt(copy.size());
            for (Object entry : copy) {
                valueExternalizer.writeObject(output, entry);
            }
        }
    }

    public static <E, T extends Collection<E>> T readCollection(ObjectInput input, Externalizer<E> valueExternalizer, MarshallUtil.CollectionBuilder<E, T> colBuilder) throws ClassNotFoundException, IOException {
        byte b = input.readByte();
        if (b == 0) {
            return null;
        }
        int size = input.readInt();
        Collection col = colBuilder.build(size);
        for (int i = 0; i < size; ++i) {
            Object value = valueExternalizer.readObject(input);
            col.add(value);
        }
        return (T)col;
    }

    private static class StringExternalizer
    implements Externalizer<String> {
        private StringExternalizer() {
        }

        public void writeObject(ObjectOutput output, String str) throws IOException {
            MarshallUtil.marshallString((String)str, (ObjectOutput)output);
        }

        public String readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return MarshallUtil.unmarshallString((ObjectInput)input);
        }
    }

    public static class HashSetBuilder<E>
    implements MarshallUtil.CollectionBuilder<E, HashSet<E>> {
        public HashSet<E> build(int size) {
            return new HashSet(size);
        }
    }

    public static class ConcurrentHashMapBuilder<K, V>
    implements MarshallUtil.MapBuilder<K, V, ConcurrentHashMap<K, V>> {
        public ConcurrentHashMap<K, V> build(int size) {
            return new ConcurrentHashMap(size);
        }
    }
}

