/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.cache.infinispan.entities.AbstractRevisioned;
import org.keycloak.models.cache.infinispan.entities.InRealm;

public class CachedRole
extends AbstractRevisioned
implements InRealm {
    protected final String name;
    protected final String realm;
    protected final String description;
    protected final Boolean scopeParamRequired;
    protected final boolean composite;
    protected final Set<String> composites = new HashSet<String>();

    public CachedRole(Long revision, RoleModel model, RealmModel realm) {
        super(revision, model.getId());
        this.composite = model.isComposite();
        this.description = model.getDescription();
        this.name = model.getName();
        this.scopeParamRequired = model.isScopeParamRequired();
        this.realm = realm.getId();
        if (this.composite) {
            for (RoleModel child : model.getComposites()) {
                this.composites.add(child.getId());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean isScopeParamRequired() {
        return this.scopeParamRequired;
    }

    public boolean isComposite() {
        return this.composite;
    }

    public Set<String> getComposites() {
        return this.composites;
    }
}

