/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization;

import org.keycloak.authorization.model.CachedModel;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheSession;
import org.keycloak.models.cache.infinispan.authorization.entities.CachedResourceServer;
import org.keycloak.representations.idm.authorization.PolicyEnforcementMode;

public class ResourceServerAdapter
implements ResourceServer,
CachedModel<ResourceServer> {
    protected CachedResourceServer cached;
    protected StoreFactoryCacheSession cacheSession;
    protected ResourceServer updated;
    protected boolean invalidated;

    public ResourceServerAdapter(CachedResourceServer cached, StoreFactoryCacheSession cacheSession) {
        this.cached = cached;
        this.cacheSession = cacheSession;
    }

    public ResourceServer getDelegateForUpdate() {
        if (this.updated == null) {
            this.cacheSession.registerResourceServerInvalidation(this.cached.getId());
            this.updated = this.cacheSession.getResourceServerStoreDelegate().findById(this.cached.getId());
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
        return this.updated;
    }

    protected void invalidateFlag() {
        this.invalidated = true;
    }

    public void invalidate() {
        this.invalidated = true;
        this.getDelegateForUpdate();
    }

    public long getCacheTimestamp() {
        return this.cached.getCacheTimestamp();
    }

    protected boolean isUpdated() {
        if (this.updated != null) {
            return true;
        }
        if (!this.invalidated) {
            return false;
        }
        this.updated = this.cacheSession.getResourceServerStoreDelegate().findById(this.cached.getId());
        if (this.updated == null) {
            throw new IllegalStateException("Not found in database");
        }
        return true;
    }

    public String getId() {
        if (this.isUpdated()) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public boolean isAllowRemoteResourceManagement() {
        if (this.isUpdated()) {
            return this.updated.isAllowRemoteResourceManagement();
        }
        return this.cached.isAllowRemoteResourceManagement();
    }

    public void setAllowRemoteResourceManagement(boolean allowRemoteResourceManagement) {
        this.getDelegateForUpdate();
        this.updated.setAllowRemoteResourceManagement(allowRemoteResourceManagement);
    }

    public PolicyEnforcementMode getPolicyEnforcementMode() {
        if (this.isUpdated()) {
            return this.updated.getPolicyEnforcementMode();
        }
        return this.cached.getPolicyEnforcementMode();
    }

    public void setPolicyEnforcementMode(PolicyEnforcementMode enforcementMode) {
        this.getDelegateForUpdate();
        this.updated.setPolicyEnforcementMode(enforcementMode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ResourceServer)) {
            return false;
        }
        ResourceServer that = (ResourceServer)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

