/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public interface SessionUpdateTask<S extends SessionEntity> {
    public void runUpdate(S var1);

    public CacheOperation getOperation(S var1);

    public CrossDCMessageStatus getCrossDCMessageStatus(SessionEntityWrapper<S> var1);

    default public long getLifespanMs() {
        return -1L;
    }

    public static enum CrossDCMessageStatus {
        SYNC,
        NOT_NEEDED;


        CrossDCMessageStatus merge(CrossDCMessageStatus other) {
            if (this == SYNC || other == SYNC) {
                return SYNC;
            }
            return NOT_NEEDED;
        }
    }

    public static enum CacheOperation {
        ADD,
        ADD_IF_ABSENT,
        REMOVE,
        REPLACE;


        CacheOperation merge(CacheOperation other, SessionEntity entity) {
            if (this == REMOVE || other == REMOVE) {
                return REMOVE;
            }
            if (this == ADD | this == ADD_IF_ABSENT) {
                if (other == ADD | other == ADD_IF_ABSENT) {
                    throw new IllegalStateException("Illegal state. Task already in progress for session " + entity.toString());
                }
                return this;
            }
            return REPLACE;
        }
    }
}

