/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.entities.UserEntity;

public class UserAdapter
implements UserModel {
    protected UserEntity user;

    public UserAdapter(UserEntity user) {
        this.user = user;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getLoginName() {
        return this.user.getLoginName();
    }

    public void setLoginName(String loginName) {
        this.user.setLoginName(loginName);
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public boolean isTotp() {
        return this.user.isTotp();
    }

    public void setEnabled(boolean enabled) {
        this.user.setEnabled(enabled);
    }

    public void setAttribute(String name, String value) {
        Map<String, String> attributes = this.user.getAttributes();
        if (attributes == null) {
            attributes = new HashMap<String, String>();
        }
        attributes.put(name, value);
        this.user.setAttributes(attributes);
    }

    public void removeAttribute(String name) {
        Map<String, String> attributes = this.user.getAttributes();
        if (attributes == null) {
            attributes = new HashMap<String, String>();
        }
        attributes.remove(name);
        this.user.setAttributes(attributes);
    }

    public String getAttribute(String name) {
        if (this.user.getAttributes() == null) {
            return null;
        }
        return this.user.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.user.getAttributes());
        return result;
    }

    public Set<UserModel.RequiredAction> getRequiredActions() {
        HashSet<UserModel.RequiredAction> result = new HashSet<UserModel.RequiredAction>();
        result.addAll(this.user.getRequiredActions());
        return result;
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        this.user.getRequiredActions().add(action);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.user.getRequiredActions().remove(action);
    }

    public String getFirstName() {
        return this.user.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.user.setFirstName(firstName);
    }

    public String getLastName() {
        return this.user.getLastName();
    }

    public void setLastName(String lastName) {
        this.user.setLastName(lastName);
    }

    public String getEmail() {
        return this.user.getEmail();
    }

    public void setEmail(String email) {
        this.user.setEmail(email);
    }

    public boolean isEmailVerified() {
        return this.user.isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        this.user.setEmailVerified(verified);
    }

    public void setTotp(boolean totp) {
        this.user.setTotp(totp);
    }

    public int getNotBefore() {
        return this.user.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.user.setNotBefore(notBefore);
    }
}

