/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.entities.ClientEntity;

public class ClientAdapter
implements ClientModel {
    protected ClientEntity entity;
    protected RealmModel realm;

    public ClientAdapter(RealmModel realm, ClientEntity entity) {
        this.realm = realm;
        this.entity = entity;
    }

    public ClientEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getClientId() {
        return this.entity.getName();
    }

    public boolean isEnabled() {
        return this.entity.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.entity.setEnabled(enabled);
    }

    public long getAllowedClaimsMask() {
        return this.entity.getAllowedClaimsMask();
    }

    public void setAllowedClaimsMask(long mask) {
        this.entity.setAllowedClaimsMask(mask);
    }

    public boolean isPublicClient() {
        return this.entity.isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.entity.setPublicClient(flag);
    }

    public Set<String> getWebOrigins() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.entity.getWebOrigins());
        return result;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        this.entity.setWebOrigins(webOrigins);
    }

    public void addWebOrigin(String webOrigin) {
        this.entity.getWebOrigins().add(webOrigin);
    }

    public void removeWebOrigin(String webOrigin) {
        this.entity.getWebOrigins().remove(webOrigin);
    }

    public Set<String> getRedirectUris() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.entity.getRedirectUris());
        return result;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.entity.setRedirectUris(redirectUris);
    }

    public void addRedirectUri(String redirectUri) {
        this.entity.getRedirectUris().add(redirectUri);
    }

    public void removeRedirectUri(String redirectUri) {
        this.entity.getRedirectUris().remove(redirectUri);
    }

    public String getSecret() {
        return this.entity.getSecret();
    }

    public void setSecret(String secret) {
        this.entity.setSecret(secret);
    }

    public boolean validateSecret(String secret) {
        return secret.equals(this.entity.getSecret());
    }

    public int getNotBefore() {
        return this.entity.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.entity.setNotBefore(notBefore);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ClientAdapter that = (ClientAdapter)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.entity.getId().hashCode();
    }
}

