/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.hibernate.annotations.GenericGenerator;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.jpa.entities.UserSessionEntity;

@Entity
@NamedQueries(value={@NamedQuery(name="getAllClientUserSessions", query="select s from ClientUserSessionAssociationEntity s"), @NamedQuery(name="getClientUserSessionBySession", query="select s from ClientUserSessionAssociationEntity s where s.session = :session"), @NamedQuery(name="getClientUserSessionByClient", query="select s from ClientUserSessionAssociationEntity s where s.clientId = :clientId"), @NamedQuery(name="getActiveClientSessions", query="select COUNT(s) from ClientUserSessionAssociationEntity s where s.clientId = :clientId"), @NamedQuery(name="removeClientUserSessionByClient", query="delete from ClientUserSessionAssociationEntity s where s.clientId = :clientId"), @NamedQuery(name="removeClientUserSessionByUser", query="delete from ClientUserSessionAssociationEntity s where s.user = :user"), @NamedQuery(name="removeClientUserSessionByRealm", query="delete from ClientUserSessionAssociationEntity s where s.realm = :realm")})
public class ClientUserSessionAssociationEntity {
    @Id
    @GenericGenerator(name="uuid_generator", strategy="org.keycloak.models.jpa.utils.JpaIdGenerator")
    @GeneratedValue(generator="uuid_generator")
    private String id;
    @ManyToOne(fetch=FetchType.LAZY)
    private UserSessionEntity session;
    @ManyToOne(fetch=FetchType.LAZY)
    private UserEntity user;
    @ManyToOne(fetch=FetchType.LAZY)
    private RealmEntity realm;
    private String clientId;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public UserSessionEntity getSession() {
        return this.session;
    }

    public void setSession(UserSessionEntity session) {
        this.session = session;
    }

    public RealmEntity getRealm() {
        return this.realm;
    }

    public void setRealm(RealmEntity realm) {
        this.realm = realm;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }
}

