/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.jpa.ApplicationAdapter;
import org.keycloak.models.jpa.JpaKeycloakTransaction;
import org.keycloak.models.jpa.OAuthClientAdapter;
import org.keycloak.models.jpa.PersistenceExceptionConverter;
import org.keycloak.models.jpa.RealmAdapter;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.UserAdapter;
import org.keycloak.models.jpa.UserSessionAdapter;
import org.keycloak.models.jpa.UsernameLoginFailureAdapter;
import org.keycloak.models.jpa.entities.ApplicationEntity;
import org.keycloak.models.jpa.entities.ClientUserSessionAssociationEntity;
import org.keycloak.models.jpa.entities.OAuthClientEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.jpa.entities.SocialLinkEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.jpa.entities.UserSessionEntity;
import org.keycloak.models.jpa.entities.UsernameLoginFailureEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.util.Time;

public class JpaKeycloakSession
implements KeycloakSession {
    protected EntityManager em;

    public JpaKeycloakSession(EntityManager em) {
        this.em = PersistenceExceptionConverter.create(em);
    }

    public KeycloakTransaction getTransaction() {
        return new JpaKeycloakTransaction(this.em);
    }

    public RealmModel createRealm(String name) {
        return this.createRealm(KeycloakModelUtils.generateId(), name);
    }

    public RealmModel createRealm(String id, String name) {
        RealmEntity realm = new RealmEntity();
        realm.setName(name);
        realm.setId(id);
        this.em.persist((Object)realm);
        this.em.flush();
        return new RealmAdapter(this, this.em, realm);
    }

    public RealmModel getRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id);
        if (realm == null) {
            return null;
        }
        return new RealmAdapter(this, this.em, realm);
    }

    public List<RealmModel> getRealms() {
        TypedQuery query = this.em.createNamedQuery("getAllRealms", RealmEntity.class);
        List entities = query.getResultList();
        ArrayList<RealmModel> realms = new ArrayList<RealmModel>();
        for (RealmEntity entity : entities) {
            realms.add(new RealmAdapter(this, this.em, entity));
        }
        return realms;
    }

    public RealmModel getRealmByName(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmByName", RealmEntity.class);
        query.setParameter("name", (Object)name);
        List entities = query.getResultList();
        if (entities.size() == 0) {
            return null;
        }
        if (entities.size() > 1) {
            throw new IllegalStateException("Should not be more than one realm with same name");
        }
        RealmEntity realm = (RealmEntity)query.getResultList().get(0);
        if (realm == null) {
            return null;
        }
        return new RealmAdapter(this, this.em, realm);
    }

    public UserModel getUserById(String id, RealmModel realmModel) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserById", UserEntity.class);
        query.setParameter("id", (Object)id);
        RealmEntity realm = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)realmModel.getId());
        query.setParameter("realm", (Object)realm);
        List entities = query.getResultList();
        if (entities.size() == 0) {
            return null;
        }
        return new UserAdapter(realmModel, this.em, (UserEntity)entities.get(0));
    }

    public UserModel getUserByUsername(String username, RealmModel realmModel) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByLoginName", UserEntity.class);
        query.setParameter("loginName", (Object)username);
        RealmEntity realm = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)realmModel.getId());
        query.setParameter("realm", (Object)realm);
        List results = query.getResultList();
        if (results.size() == 0) {
            return null;
        }
        return new UserAdapter(realmModel, this.em, (UserEntity)results.get(0));
    }

    public UserModel getUserByEmail(String email, RealmModel realmModel) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByEmail", UserEntity.class);
        query.setParameter("email", (Object)email);
        RealmEntity realm = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)realmModel.getId());
        query.setParameter("realm", (Object)realm);
        List results = query.getResultList();
        return results.isEmpty() ? null : new UserAdapter(realmModel, this.em, (UserEntity)results.get(0));
    }

    public boolean removeRealm(String id) {
        RealmEntity realm = (RealmEntity)this.em.find(RealmEntity.class, (Object)id);
        if (realm == null) {
            return false;
        }
        RealmAdapter adapter = new RealmAdapter(this, this.em, realm);
        adapter.removeUserSessions();
        for (ApplicationEntity a : new LinkedList<ApplicationEntity>(realm.getApplications())) {
            adapter.removeApplication(a.getId());
        }
        for (OAuthClientModel oauth : adapter.getOAuthClients()) {
            adapter.removeOAuthClient(oauth.getId());
        }
        for (UserEntity u : this.em.createQuery("from UserEntity u where u.realm = :realm", UserEntity.class).setParameter("realm", (Object)realm).getResultList()) {
            adapter.removeUser(u.getLoginName());
        }
        this.em.remove((Object)realm);
        return true;
    }

    public void close() {
        if (this.em.getTransaction().isActive()) {
            this.em.getTransaction().rollback();
        }
        if (this.em.isOpen()) {
            this.em.close();
        }
    }

    public void removeAllData() {
        List<RealmModel> realms = this.getRealms();
        for (RealmModel realm : realms) {
            this.removeRealm(realm.getId());
        }
    }

    public UserModel getUserBySocialLink(SocialLinkModel socialLink, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findUserByLinkAndRealm", UserEntity.class);
        RealmEntity realmEntity = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)realm.getId());
        query.setParameter("realm", (Object)realmEntity);
        query.setParameter("socialProvider", (Object)socialLink.getSocialProvider());
        query.setParameter("socialUserId", (Object)socialLink.getSocialUserId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More results found for socialProvider=" + socialLink.getSocialProvider() + ", socialUserId=" + socialLink.getSocialUserId() + ", results=" + results);
        }
        UserEntity user = (UserEntity)results.get(0);
        return new UserAdapter(realm, this.em, user);
    }

    public List<UserModel> getUsers(RealmModel realm) {
        TypedQuery query = this.em.createQuery("select u from UserEntity u where u.realm = :realm", UserEntity.class);
        RealmEntity realmEntity = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)realm.getId());
        query.setParameter("realm", (Object)realmEntity);
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(realm, this.em, entity));
        }
        return users;
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        TypedQuery query = this.em.createQuery("select u from UserEntity u where u.realm = :realm and ( lower(u.loginName) like :search or lower(concat(u.firstName, ' ', u.lastName)) like :search or u.email like :search )", UserEntity.class);
        RealmEntity realmEntity = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)realm.getId());
        query.setParameter("realm", (Object)realmEntity);
        query.setParameter("search", (Object)("%" + search.toLowerCase() + "%"));
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(realm, this.em, entity));
        }
        return users;
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        StringBuilder builder = new StringBuilder("select u from UserEntity u");
        boolean first = true;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attribute = null;
            if (entry.getKey().equals("username")) {
                attribute = "lower(loginName)";
            } else if (entry.getKey().equalsIgnoreCase("firstName")) {
                attribute = "lower(firstName)";
            } else if (entry.getKey().equalsIgnoreCase("lastName")) {
                attribute = "lower(lastName)";
            } else if (entry.getKey().equalsIgnoreCase("email")) {
                attribute = "lower(email)";
            }
            if (attribute == null) continue;
            if (first) {
                first = false;
                builder.append(" where realm = :realm");
            } else {
                builder.append(" and ");
            }
            builder.append(attribute).append(" like '%").append(entry.getValue().toLowerCase()).append("%'");
        }
        String q = builder.toString();
        TypedQuery query = this.em.createQuery(q, UserEntity.class);
        RealmEntity realmEntity = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)realm.getId());
        query.setParameter("realm", (Object)realmEntity);
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(realm, this.em, entity));
        }
        return users;
    }

    private SocialLinkEntity findSocialLink(UserModel user, String socialProvider) {
        TypedQuery query = this.em.createNamedQuery("findSocialLinkByUserAndProvider", SocialLinkEntity.class);
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        query.setParameter("user", (Object)userEntity);
        query.setParameter("socialProvider", (Object)socialProvider);
        List results = query.getResultList();
        return results.size() > 0 ? (SocialLinkEntity)results.get(0) : null;
    }

    public Set<SocialLinkModel> getSocialLinks(UserModel user, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findSocialLinkByUser", SocialLinkEntity.class);
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        query.setParameter("user", (Object)userEntity);
        List results = query.getResultList();
        HashSet<SocialLinkModel> set = new HashSet<SocialLinkModel>();
        for (SocialLinkEntity entity : results) {
            set.add(new SocialLinkModel(entity.getSocialProvider(), entity.getSocialUserId(), entity.getSocialUsername()));
        }
        return set;
    }

    public SocialLinkModel getSocialLink(UserModel user, String socialProvider, RealmModel realm) {
        SocialLinkEntity entity = this.findSocialLink(user, socialProvider);
        return entity != null ? new SocialLinkModel(entity.getSocialProvider(), entity.getSocialUserId(), entity.getSocialUsername()) : null;
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        RoleEntity entity = (RoleEntity)this.em.find(RoleEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        if (!realm.getId().equals(entity.getRealmId())) {
            return null;
        }
        return new RoleAdapter(realm, this.em, entity);
    }

    public ApplicationModel getApplicationById(String id, RealmModel realm) {
        ApplicationEntity app = (ApplicationEntity)this.em.find(ApplicationEntity.class, (Object)id);
        if (app == null || !realm.getId().equals(app.getRealm().getId())) {
            return null;
        }
        return new ApplicationAdapter(realm, this.em, app);
    }

    public OAuthClientModel getOAuthClientById(String id, RealmModel realm) {
        OAuthClientEntity client = (OAuthClientEntity)this.em.find(OAuthClientEntity.class, (Object)id);
        if (client == null || !realm.getId().equals(client.getRealm().getId())) {
            return null;
        }
        return new OAuthClientAdapter(realm, client, this.em);
    }

    public UsernameLoginFailureModel getUserLoginFailure(String username, RealmModel realm) {
        String id = username + "-" + realm.getId();
        UsernameLoginFailureEntity entity = (UsernameLoginFailureEntity)this.em.find(UsernameLoginFailureEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return new UsernameLoginFailureAdapter(entity);
    }

    public UsernameLoginFailureModel addUserLoginFailure(String username, RealmModel realm) {
        UsernameLoginFailureModel model = this.getUserLoginFailure(username, realm);
        if (model != null) {
            return model;
        }
        String id = username + "-" + realm.getId();
        UsernameLoginFailureEntity entity = new UsernameLoginFailureEntity();
        entity.setId(id);
        entity.setUsername(username);
        RealmEntity realmEntity = (RealmEntity)this.em.getReference(RealmEntity.class, (Object)realm.getId());
        entity.setRealm(realmEntity);
        this.em.persist((Object)entity);
        return new UsernameLoginFailureAdapter(entity);
    }

    public List<UsernameLoginFailureModel> getAllUserLoginFailures(RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getAllFailures", UsernameLoginFailureEntity.class);
        List entities = query.getResultList();
        ArrayList<UsernameLoginFailureModel> models = new ArrayList<UsernameLoginFailureModel>();
        for (UsernameLoginFailureEntity entity : entities) {
            models.add(new UsernameLoginFailureAdapter(entity));
        }
        return models;
    }

    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String ipAddress) {
        UserSessionEntity entity = new UserSessionEntity();
        entity.setRealmId(realm.getId());
        entity.setUserId(user.getId());
        entity.setIpAddress(ipAddress);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
        this.em.persist((Object)entity);
        return new UserSessionAdapter(this.em, realm, entity);
    }

    public UserSessionModel getUserSession(String id, RealmModel realm) {
        UserSessionEntity entity = (UserSessionEntity)this.em.find(UserSessionEntity.class, (Object)id);
        return entity != null ? new UserSessionAdapter(this.em, realm, entity) : null;
    }

    public List<UserSessionModel> getUserSessions(UserModel user, RealmModel realm) {
        LinkedList<UserSessionModel> sessions = new LinkedList<UserSessionModel>();
        for (UserSessionEntity e : this.em.createNamedQuery("getUserSessionByUser", UserSessionEntity.class).setParameter("userId", (Object)user.getId()).getResultList()) {
            sessions.add(new UserSessionAdapter(this.em, realm, e));
        }
        return sessions;
    }

    public Set<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        HashSet<UserSessionModel> list = new HashSet<UserSessionModel>();
        TypedQuery query = this.em.createNamedQuery("getClientUserSessionByClient", ClientUserSessionAssociationEntity.class);
        String id = client.getId();
        query.setParameter("clientId", (Object)id);
        List results = query.getResultList();
        for (ClientUserSessionAssociationEntity entity : results) {
            list.add(new UserSessionAdapter(this.em, realm, entity.getSession()));
        }
        return list;
    }

    public int getActiveUserSessions(RealmModel realm, ClientModel client) {
        Query query = this.em.createNamedQuery("getActiveClientSessions");
        query.setParameter("clientId", (Object)client.getId());
        Object count = query.getSingleResult();
        return ((Number)count).intValue();
    }

    public void removeUserSession(UserSessionModel session) {
        this.em.remove((Object)((UserSessionAdapter)session).getEntity());
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.em.createNamedQuery("removeClientUserSessionByUser").setParameter("userId", (Object)user.getId()).executeUpdate();
        this.em.createNamedQuery("removeUserSessionByUser").setParameter("userId", (Object)user.getId()).executeUpdate();
    }

    public void removeExpiredUserSessions(RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getUserSessionExpired", UserSessionEntity.class).setParameter("maxTime", (Object)(Time.currentTime() - realm.getSsoSessionMaxLifespan())).setParameter("idleTime", (Object)(Time.currentTime() - realm.getSsoSessionIdleTimeout()));
        List results = query.getResultList();
        for (UserSessionEntity entity : results) {
            this.em.remove((Object)entity);
        }
    }

    public void removeUserSessions(RealmModel realm) {
        this.em.createNamedQuery("removeClientUserSessionByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        this.em.createNamedQuery("removeRealmUserSessions").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }
}

