/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.keycloak.models.ClientIdentityProviderMappingModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.entities.ClientEntity;
import org.keycloak.models.jpa.entities.ClientIdentityProviderMappingEntity;
import org.keycloak.models.jpa.entities.IdentityProviderEntity;
import org.keycloak.models.jpa.entities.ProtocolMapperEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.jpa.entities.ScopeMappingEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class ClientAdapter
implements ClientModel {
    protected ClientEntity entity;
    protected RealmModel realm;
    protected EntityManager em;

    public ClientAdapter(RealmModel realm, ClientEntity entity, EntityManager em) {
        this.realm = realm;
        this.entity = entity;
        this.em = em;
    }

    public ClientEntity getEntity() {
        return this.entity;
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public String getClientId() {
        return this.entity.getName();
    }

    public boolean isEnabled() {
        return this.entity.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.entity.setEnabled(enabled);
    }

    public boolean isPublicClient() {
        return this.entity.isPublicClient();
    }

    public void setPublicClient(boolean flag) {
        this.entity.setPublicClient(flag);
    }

    public boolean isFrontchannelLogout() {
        return this.entity.isFrontchannelLogout();
    }

    public void setFrontchannelLogout(boolean flag) {
        this.entity.setFrontchannelLogout(flag);
    }

    public boolean isFullScopeAllowed() {
        return this.entity.isFullScopeAllowed();
    }

    public void setFullScopeAllowed(boolean value) {
        this.entity.setFullScopeAllowed(value);
    }

    public Set<String> getWebOrigins() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.entity.getWebOrigins());
        return result;
    }

    public void setWebOrigins(Set<String> webOrigins) {
        this.entity.setWebOrigins(webOrigins);
    }

    public void addWebOrigin(String webOrigin) {
        this.entity.getWebOrigins().add(webOrigin);
    }

    public void removeWebOrigin(String webOrigin) {
        this.entity.getWebOrigins().remove(webOrigin);
    }

    public Set<String> getRedirectUris() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.entity.getRedirectUris());
        return result;
    }

    public void setRedirectUris(Set<String> redirectUris) {
        this.entity.setRedirectUris(redirectUris);
    }

    public void addRedirectUri(String redirectUri) {
        this.entity.getRedirectUris().add(redirectUri);
    }

    public void removeRedirectUri(String redirectUri) {
        this.entity.getRedirectUris().remove(redirectUri);
    }

    public String getSecret() {
        return this.entity.getSecret();
    }

    public void setSecret(String secret) {
        this.entity.setSecret(secret);
    }

    public boolean validateSecret(String secret) {
        return secret.equals(this.entity.getSecret());
    }

    public int getNotBefore() {
        return this.entity.getNotBefore();
    }

    public void setNotBefore(int notBefore) {
        this.entity.setNotBefore(notBefore);
    }

    public Set<RoleModel> getRealmScopeMappings() {
        Set<RoleModel> roleMappings = this.getScopeMappings();
        HashSet<RoleModel> appRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel) || !((RealmModel)container).getId().equals(this.realm.getId())) continue;
            appRoles.add(role);
        }
        return appRoles;
    }

    public Set<RoleModel> getScopeMappings() {
        TypedQuery query = this.em.createNamedQuery("clientScopeMappingIds", String.class);
        query.setParameter("client", (Object)this.getEntity());
        List ids = query.getResultList();
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String roleId : ids) {
            RoleModel role = this.realm.getRoleById(roleId);
            if (role == null) continue;
            roles.add(role);
        }
        return roles;
    }

    public void addScopeMapping(RoleModel role) {
        if (this.hasScope(role)) {
            return;
        }
        ScopeMappingEntity entity = new ScopeMappingEntity();
        entity.setClient(this.getEntity());
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        entity.setRole(roleEntity);
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
    }

    public void deleteScopeMapping(RoleModel role) {
        TypedQuery<ScopeMappingEntity> query = this.getRealmScopeMappingQuery(role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (ScopeMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
    }

    protected TypedQuery<ScopeMappingEntity> getRealmScopeMappingQuery(RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("hasScope", ScopeMappingEntity.class);
        query.setParameter("client", (Object)this.getEntity());
        RoleEntity roleEntity = RoleAdapter.toRoleEntity(role, this.em);
        query.setParameter("role", (Object)roleEntity);
        return query;
    }

    public boolean hasScope(RoleModel role) {
        if (this.isFullScopeAllowed()) {
            return true;
        }
        Set<RoleModel> roles = this.getScopeMappings();
        if (roles.contains(role)) {
            return true;
        }
        for (RoleModel mapping : roles) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ClientAdapter that = (ClientAdapter)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.entity.getId().hashCode();
    }

    public String getProtocol() {
        return this.entity.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.entity.setProtocol(protocol);
    }

    public void setAttribute(String name, String value) {
        this.entity.getAttributes().put(name, value);
    }

    public void removeAttribute(String name) {
        this.entity.getAttributes().remove(name);
    }

    public String getAttribute(String name) {
        return this.entity.getAttributes().get(name);
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> copy = new HashMap<String, String>();
        copy.putAll(this.entity.getAttributes());
        return copy;
    }

    public void updateIdentityProviders(List<ClientIdentityProviderMappingModel> identityProviders) {
        Collection<ClientIdentityProviderMappingEntity> entities = this.entity.getIdentityProviders();
        HashSet<String> already = new HashSet<String>();
        ArrayList<ClientIdentityProviderMappingEntity> remove = new ArrayList<ClientIdentityProviderMappingEntity>();
        for (ClientIdentityProviderMappingEntity entity : entities) {
            IdentityProviderEntity identityProvider = entity.getIdentityProvider();
            boolean toRemove = true;
            for (ClientIdentityProviderMappingModel model : identityProviders) {
                if (!model.getIdentityProvider().equals(identityProvider.getAlias())) continue;
                toRemove = false;
                break;
            }
            if (toRemove) {
                remove.add(entity);
                continue;
            }
            already.add(entity.getIdentityProvider().getAlias());
        }
        for (ClientIdentityProviderMappingEntity entity : remove) {
            entities.remove(entity);
            this.em.remove((Object)entity);
        }
        this.em.flush();
        for (ClientIdentityProviderMappingModel model : identityProviders) {
            ClientIdentityProviderMappingEntity mappingEntity = null;
            if (!already.contains(model.getIdentityProvider())) {
                mappingEntity = new ClientIdentityProviderMappingEntity();
                entities.add(mappingEntity);
            } else {
                for (ClientIdentityProviderMappingEntity entity : entities) {
                    if (!entity.getIdentityProvider().getAlias().equals(model.getIdentityProvider())) continue;
                    mappingEntity = entity;
                    break;
                }
            }
            TypedQuery query = this.em.createNamedQuery("findIdentityProviderByAlias", IdentityProviderEntity.class).setParameter("alias", (Object)model.getIdentityProvider());
            IdentityProviderEntity identityProviderEntity = (IdentityProviderEntity)query.getSingleResult();
            mappingEntity.setIdentityProvider(identityProviderEntity);
            mappingEntity.setClient(this.entity);
            mappingEntity.setRetrieveToken(model.isRetrieveToken());
            this.em.persist((Object)mappingEntity);
        }
        this.em.flush();
    }

    public List<ClientIdentityProviderMappingModel> getIdentityProviders() {
        ArrayList<ClientIdentityProviderMappingModel> models = new ArrayList<ClientIdentityProviderMappingModel>();
        for (ClientIdentityProviderMappingEntity entity : this.entity.getIdentityProviders()) {
            ClientIdentityProviderMappingModel model = new ClientIdentityProviderMappingModel();
            model.setIdentityProvider(entity.getIdentityProvider().getAlias());
            model.setRetrieveToken(entity.isRetrieveToken());
            models.add(model);
        }
        return models;
    }

    public boolean isAllowedRetrieveTokenFromIdentityProvider(String providerId) {
        for (ClientIdentityProviderMappingModel model : this.getIdentityProviders()) {
            if (!model.getIdentityProvider().equals(providerId)) continue;
            return model.isRetrieveToken();
        }
        return false;
    }

    public static boolean contains(String str, String[] array) {
        for (String s : array) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    public Set<ProtocolMapperModel> getProtocolMappers() {
        HashSet<ProtocolMapperModel> mappings = new HashSet<ProtocolMapperModel>();
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            ProtocolMapperModel mapping = new ProtocolMapperModel();
            mapping.setId(entity.getId());
            mapping.setName(entity.getName());
            mapping.setProtocol(entity.getProtocol());
            mapping.setProtocolMapper(entity.getProtocolMapper());
            mapping.setConsentRequired(entity.isConsentRequired());
            mapping.setConsentText(entity.getConsentText());
            HashMap<String, String> config = new HashMap<String, String>();
            if (entity.getConfig() != null) {
                config.putAll(entity.getConfig());
            }
            mapping.setConfig(config);
            mappings.add(mapping);
        }
        return mappings;
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        if (this.getProtocolMapperByName(model.getProtocol(), model.getName()) != null) {
            throw new RuntimeException("protocol mapper name must be unique per protocol");
        }
        String id = KeycloakModelUtils.generateId();
        ProtocolMapperEntity entity = new ProtocolMapperEntity();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setProtocol(model.getProtocol());
        entity.setProtocolMapper(model.getProtocolMapper());
        entity.setClient(this.entity);
        entity.setConfig(model.getConfig());
        entity.setConsentRequired(model.isConsentRequired());
        entity.setConsentText(model.getConsentText());
        this.em.persist((Object)entity);
        this.entity.getProtocolMappers().add(entity);
        return this.entityToModel(entity);
    }

    protected ProtocolMapperEntity getProtocolMapperEntity(String id) {
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            if (!entity.getId().equals(id)) continue;
            return entity;
        }
        return null;
    }

    protected ProtocolMapperEntity getProtocolMapperEntityByName(String protocol, String name) {
        for (ProtocolMapperEntity entity : this.entity.getProtocolMappers()) {
            if (!entity.getProtocol().equals(protocol) || !entity.getName().equals(name)) continue;
            return entity;
        }
        return null;
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity toDelete = this.getProtocolMapperEntity(mapping.getId());
        if (toDelete != null) {
            this.entity.getProtocolMappers().remove(toDelete);
            this.em.remove((Object)toDelete);
        }
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntity(mapping.getId());
        entity.setProtocolMapper(mapping.getProtocolMapper());
        entity.setConsentRequired(mapping.isConsentRequired());
        entity.setConsentText(mapping.getConsentText());
        if (entity.getConfig() == null) {
            entity.setConfig(mapping.getConfig());
        } else {
            entity.getConfig().clear();
            entity.getConfig().putAll(mapping.getConfig());
        }
        this.em.flush();
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntity(id);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        ProtocolMapperEntity entity = this.getProtocolMapperEntityByName(protocol, name);
        if (entity == null) {
            return null;
        }
        return this.entityToModel(entity);
    }

    protected ProtocolMapperModel entityToModel(ProtocolMapperEntity entity) {
        ProtocolMapperModel mapping = new ProtocolMapperModel();
        mapping.setId(entity.getId());
        mapping.setName(entity.getName());
        mapping.setProtocol(entity.getProtocol());
        mapping.setProtocolMapper(entity.getProtocolMapper());
        mapping.setConsentRequired(entity.isConsentRequired());
        mapping.setConsentText(entity.getConsentText());
        HashMap<String, String> config = new HashMap<String, String>();
        if (entity.getConfig() != null) {
            config.putAll(entity.getConfig());
        }
        mapping.setConfig(config);
        return mapping;
    }
}

