/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.connections.jpa.DefaultJpaConnectionProvider;
import org.keycloak.connections.jpa.HibernateStatsReporter;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionProviderFactory;
import org.keycloak.connections.jpa.JpaKeycloakTransaction;
import org.keycloak.connections.jpa.PersistenceExceptionConverter;
import org.keycloak.connections.jpa.updater.JpaUpdaterProvider;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.provider.ServerInfoAwareProviderFactory;
import org.keycloak.timer.ScheduledTask;
import org.keycloak.timer.TimerProvider;

public class DefaultJpaConnectionProviderFactory
implements JpaConnectionProviderFactory,
ServerInfoAwareProviderFactory {
    private static final Logger logger = Logger.getLogger(DefaultJpaConnectionProviderFactory.class);
    private volatile EntityManagerFactory emf;
    private Config.Scope config;
    private Map<String, String> operationalInfo;

    public JpaConnectionProvider create(KeycloakSession session) {
        this.lazyInit(session);
        EntityManager em = this.emf.createEntityManager();
        em = PersistenceExceptionConverter.create(em);
        session.getTransaction().enlist((KeycloakTransaction)new JpaKeycloakTransaction(em));
        return new DefaultJpaConnectionProvider(em);
    }

    public void close() {
        if (this.emf != null) {
            this.emf.close();
        }
    }

    public String getId() {
        return "default";
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.emf == null) {
            DefaultJpaConnectionProviderFactory defaultJpaConnectionProviderFactory = this;
            synchronized (defaultJpaConnectionProviderFactory) {
                if (this.emf == null) {
                    String databaseSchema;
                    logger.debug((Object)"Initializing JPA connections");
                    Connection connection = null;
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    String unitName = "keycloak-default";
                    String dataSource = this.config.get("dataSource");
                    if (dataSource != null) {
                        if (this.config.getBoolean("jta", Boolean.valueOf(false)).booleanValue()) {
                            properties.put("javax.persistence.jtaDataSource", dataSource);
                        } else {
                            properties.put("javax.persistence.nonJtaDataSource", dataSource);
                        }
                    } else {
                        String password;
                        properties.put("javax.persistence.jdbc.url", this.config.get("url"));
                        properties.put("javax.persistence.jdbc.driver", this.config.get("driver"));
                        String user = this.config.get("user");
                        if (user != null) {
                            properties.put("javax.persistence.jdbc.user", user);
                        }
                        if ((password = this.config.get("password")) != null) {
                            properties.put("javax.persistence.jdbc.password", password);
                        }
                    }
                    String schema = this.getSchema();
                    if (schema != null) {
                        properties.put("hibernate.default_schema", schema);
                    }
                    if ((databaseSchema = this.config.get("databaseSchema")) == null) {
                        throw new RuntimeException("Property 'databaseSchema' needs to be specified in the configuration");
                    }
                    if (databaseSchema.equals("development-update")) {
                        properties.put("hibernate.hbm2ddl.auto", "update");
                        databaseSchema = null;
                    } else if (databaseSchema.equals("development-validate")) {
                        properties.put("hibernate.hbm2ddl.auto", "validate");
                        databaseSchema = null;
                    }
                    properties.put("hibernate.show_sql", this.config.getBoolean("showSql", Boolean.valueOf(false)));
                    properties.put("hibernate.format_sql", this.config.getBoolean("formatSql", Boolean.valueOf(true)));
                    connection = this.getConnection();
                    try {
                        int globalStatsInterval;
                        this.prepareOperationalInfo(connection);
                        String driverDialect = this.detectDialect(connection);
                        if (driverDialect != null) {
                            properties.put("hibernate.dialect", driverDialect);
                        }
                        if (databaseSchema != null) {
                            logger.trace((Object)"Updating database");
                            JpaUpdaterProvider updater = (JpaUpdaterProvider)session.getProvider(JpaUpdaterProvider.class);
                            if (updater == null) {
                                throw new RuntimeException("Can't update database: JPA updater provider not found");
                            }
                            if (databaseSchema.equals("update")) {
                                String currentVersion = null;
                                try {
                                    ResultSet resultSet = connection.createStatement().executeQuery(updater.getCurrentVersionSql(schema));
                                    if (resultSet.next()) {
                                        currentVersion = resultSet.getString(1);
                                    }
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                if (currentVersion == null || !"1.9.2".equals(currentVersion)) {
                                    updater.update(connection, schema);
                                } else {
                                    logger.debug((Object)"Database is up to date");
                                }
                            } else if (databaseSchema.equals("validate")) {
                                updater.validate(connection, schema);
                            } else {
                                throw new RuntimeException("Invalid value for databaseSchema: " + databaseSchema);
                            }
                            logger.trace((Object)"Database update completed");
                        }
                        if ((globalStatsInterval = this.config.getInt("globalStatsInterval", Integer.valueOf(-1)).intValue()) != -1) {
                            properties.put("hibernate.generate_statistics", true);
                        }
                        logger.trace((Object)"Creating EntityManagerFactory");
                        this.emf = JpaUtils.createEntityManagerFactory(unitName, properties, this.getClass().getClassLoader());
                        logger.trace((Object)"EntityManagerFactory created");
                        if (globalStatsInterval != -1) {
                            this.startGlobalStats(session, globalStatsInterval);
                        }
                    }
                    catch (Exception e) {
                        if (connection != null) {
                            try {
                                connection.rollback();
                            }
                            catch (SQLException e2) {
                                logger.warn((Object)"Can't rollback connection", (Throwable)e2);
                            }
                        }
                        throw e;
                    }
                    finally {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException e) {
                                logger.warn((Object)"Can't close connection", (Throwable)e);
                            }
                        }
                    }
                }
            }
        }
    }

    protected void prepareOperationalInfo(Connection connection) {
        try {
            this.operationalInfo = new LinkedHashMap<String, String>();
            DatabaseMetaData md = connection.getMetaData();
            this.operationalInfo.put("databaseUrl", md.getURL());
            this.operationalInfo.put("databaseUser", md.getUserName());
            this.operationalInfo.put("databaseProduct", md.getDatabaseProductName() + " " + md.getDatabaseProductVersion());
            this.operationalInfo.put("databaseDriver", md.getDriverName() + " " + md.getDriverVersion());
            logger.debugf("Database info: %s", (Object)this.operationalInfo.toString());
        }
        catch (SQLException e) {
            logger.warn((Object)("Unable to prepare operational info due database exception: " + e.getMessage()));
        }
    }

    protected String detectDialect(Connection connection) {
        block7: {
            String driverDialect = this.config.get("driverDialect");
            if (driverDialect != null && driverDialect.length() > 0) {
                return driverDialect;
            }
            try {
                String dbProductName = connection.getMetaData().getDatabaseProductName();
                String dbProductVersion = connection.getMetaData().getDatabaseProductVersion();
                if (!dbProductName.equals("Microsoft SQL Server")) break block7;
                String topVersionStr = dbProductVersion.split("\\.")[0];
                boolean shouldSet2012Dialect = true;
                try {
                    int topVersion = Integer.parseInt(topVersionStr);
                    if (topVersion < 12) {
                        shouldSet2012Dialect = false;
                    }
                }
                catch (NumberFormatException topVersion) {
                    // empty catch block
                }
                if (shouldSet2012Dialect) {
                    String sql2012Dialect = "org.hibernate.dialect.SQLServer2012Dialect";
                    logger.debugf("Manually override hibernate dialect to %s", (Object)sql2012Dialect);
                    return sql2012Dialect;
                }
            }
            catch (SQLException e) {
                logger.warnf("Unable to detect hibernate dialect due database exception : %s", (Object)e.getMessage());
            }
        }
        return null;
    }

    protected void startGlobalStats(KeycloakSession session, int globalStatsIntervalSecs) {
        logger.debugf("Started Hibernate statistics with the interval %s seconds", globalStatsIntervalSecs);
        TimerProvider timer = (TimerProvider)session.getProvider(TimerProvider.class);
        timer.scheduleTask((ScheduledTask)new HibernateStatsReporter(this.emf), (long)(globalStatsIntervalSecs * 1000), "ReportHibernateGlobalStats");
    }

    @Override
    public Connection getConnection() {
        try {
            String dataSourceLookup = this.config.get("dataSource");
            if (dataSourceLookup != null) {
                DataSource dataSource = (DataSource)new InitialContext().lookup(dataSourceLookup);
                return dataSource.getConnection();
            }
            Class.forName(this.config.get("driver"));
            return DriverManager.getConnection(this.config.get("url"), this.config.get("user"), this.config.get("password"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to connect to database", e);
        }
    }

    @Override
    public String getSchema() {
        return this.config.get("schema");
    }

    public Map<String, String> getOperationalInfo() {
        return this.operationalInfo;
    }
}

