/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.InsertStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;

public class JpaUpdate13_0_0_MigrateDefaultRoles
extends CustomKeycloakTask {
    private final Map<String, String> realmIdsAndNames = new HashMap<String, String>();

    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        this.extractRealmIdsAndNames("SELECT ID,NAME FROM " + this.getTableName("REALM"));
        String clientTable = this.getTableName("CLIENT");
        String clientDefaultRolesTable = this.getTableName("CLIENT_DEFAULT_ROLES");
        String compositeRoleTable = this.getTableName("COMPOSITE_ROLE");
        for (Map.Entry<String, String> entry : this.realmIdsAndNames.entrySet()) {
            String id = UUID.randomUUID().toString();
            String roleName = this.determineDefaultRoleName(entry.getKey(), entry.getValue());
            this.statements.add(new InsertStatement(null, null, this.database.correctObjectName("KEYCLOAK_ROLE", Table.class)).addColumnValue("ID", (Object)id).addColumnValue("CLIENT_REALM_CONSTRAINT", (Object)entry.getValue()).addColumnValue("CLIENT_ROLE", (Object)Boolean.FALSE).addColumnValue("DESCRIPTION", (Object)("${role_" + roleName + "}")).addColumnValue("NAME", (Object)roleName).addColumnValue("REALM_ID", (Object)entry.getValue()).addColumnValue("REALM", (Object)entry.getValue()));
            this.statements.add(new UpdateStatement(null, null, this.database.correctObjectName("REALM", Table.class)).addNewColumnValue("DEFAULT_ROLE", (Object)id).setWhereClause("REALM.ID=?").addWhereParameter((Object)entry.getValue()));
            this.statements.add(new RawSqlStatement("INSERT INTO " + compositeRoleTable + " (COMPOSITE, CHILD_ROLE) SELECT '" + id + "', ROLE_ID FROM " + this.getTableName("REALM_DEFAULT_ROLES") + " WHERE REALM_ID = '" + this.database.escapeStringForDatabase(entry.getValue()) + "'"));
            this.statements.add(new RawSqlStatement("INSERT INTO " + compositeRoleTable + " (COMPOSITE, CHILD_ROLE) SELECT '" + id + "', " + clientDefaultRolesTable + ".ROLE_ID FROM " + clientDefaultRolesTable + " INNER JOIN " + clientTable + " ON " + clientTable + ".ID = " + clientDefaultRolesTable + ".CLIENT_ID AND " + clientTable + ".REALM_ID = '" + this.database.escapeStringForDatabase(entry.getValue()) + "'"));
        }
    }

    private void extractRealmIdsAndNames(String sql) throws CustomChangeException {
        try (PreparedStatement statement = this.jdbcConnection.prepareStatement(sql);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                this.realmIdsAndNames.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when extracting data from previous version", (Throwable)e);
        }
    }

    private String determineDefaultRoleName(String realmId, String realmName) throws CustomChangeException {
        String roleName = "default-roles-" + realmName.toLowerCase();
        if (this.isRoleNameAvailable(realmId, roleName)) {
            return roleName;
        }
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            roleName = "default-roles-" + realmName.toLowerCase() + "-" + i;
            if (!this.isRoleNameAvailable(realmId, roleName)) continue;
            return roleName;
        }
        throw new CustomChangeException(this.getTaskId() + ": Exception when extracting data from previous version. Unable to determine default role name.");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isRoleNameAvailable(String realmId, String roleName) throws CustomChangeException {
        try (PreparedStatement statement = this.jdbcConnection.prepareStatement("SELECT ID FROM " + this.getTableName("KEYCLOAK_ROLE") + " WHERE REALM_ID=? AND NAME=?");){
            boolean bl;
            block14: {
                statement.setString(1, realmId);
                statement.setString(2, roleName);
                ResultSet rs = statement.executeQuery();
                try {
                    boolean bl2 = bl = !rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when extracting data from previous version", (Throwable)e);
        }
    }

    @Override
    protected String getTaskId() {
        return "Migrate Default roles (13.0.0)";
    }
}

